/*
 * Decompiled with CFR 0.152.
 */
package ru.minezone.launcher.utils;

import java.io.File;

public class OSHelper {
    private static OS currentOS;

    public static OS getOS() {
        return currentOS;
    }

    public static boolean isWindows() {
        return currentOS == OS.WINDOWS;
    }

    public static boolean isLinux() {
        return currentOS == OS.LINUX;
    }

    public static boolean isMacOS() {
        return currentOS == OS.MACOS;
    }

    public static File getWorkDir() {
        String userHome = System.getProperty("user.home");
        switch (currentOS) {
            case WINDOWS: {
                String appData = System.getenv("APPDATA");
                if (appData != null) {
                    return new File(appData, ".minezone");
                }
                return new File(userHome, ".minezone");
            }
            case MACOS: {
                return new File(userHome, "Library/Application Support/minezone");
            }
        }
        return new File(userHome, ".minezone");
    }

    public static File getJavaPath() {
        String javaHome = System.getProperty("java.home");
        String javaBin = javaHome + File.separator + "bin" + File.separator;
        if (currentOS == OS.WINDOWS) {
            return new File(javaBin + "javaw.exe");
        }
        return new File(javaBin + "java");
    }

    public static long getTotalMemory() {
        return Runtime.getRuntime().maxMemory() / 0x100000L;
    }

    static {
        String osName = System.getProperty("os.name").toLowerCase();
        currentOS = osName.contains("win") ? OS.WINDOWS : (osName.contains("nix") || osName.contains("nux") ? OS.LINUX : (osName.contains("mac") ? OS.MACOS : OS.UNKNOWN));
    }

    public static enum OS {
        WINDOWS,
        LINUX,
        MACOS,
        UNKNOWN;

    }
}

