/*
 * Decompiled with CFR 0.152.
 */
package ru.minezone.launcher.utils;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import ru.minezone.launcher.utils.OSHelper;

public class LogHelper {
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static PrintWriter logWriter;
    private static boolean debugMode;

    public static void info(String message) {
        LogHelper.log("INFO", message);
    }

    public static void warning(String message) {
        LogHelper.log("WARNING", message);
    }

    public static void error(String message) {
        LogHelper.log("ERROR", message);
    }

    public static void error(String message, Throwable t) {
        LogHelper.log("ERROR", message + ": " + t.getMessage());
        if (debugMode) {
            t.printStackTrace();
        }
    }

    public static void debug(String message) {
        if (debugMode) {
            LogHelper.log("DEBUG", message);
        }
    }

    private static void log(String level, String message) {
        String timestamp = dateFormat.format(new Date());
        String logMessage = String.format("[%s] [%s] %s", timestamp, level, message);
        System.out.println(logMessage);
        if (logWriter != null) {
            logWriter.println(logMessage);
        }
    }

    static {
        debugMode = true;
        try {
            File logDir = new File(OSHelper.getWorkDir(), "logs");
            if (!logDir.exists()) {
                logDir.mkdirs();
            }
            String logFileName = new SimpleDateFormat("yyyy-MM-dd").format(new Date()) + ".log";
            File logFile = new File(logDir, logFileName);
            logWriter = new PrintWriter((Writer)new FileWriter(logFile, true), true);
        }
        catch (IOException e) {
            System.err.println("Failed to initialize log file: " + e.getMessage());
        }
    }
}

