/*
 * Decompiled with CFR 0.152.
 */
package ru.minezone.launcher.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import ru.minezone.launcher.utils.LogHelper;

public class Config {
    private File configFile;
    private Properties properties;
    public static final String SERVER_URL = "https://minezone.su/launcher/launcher.php";
    public static final String UPDATES_URL = "https://minezone.su/launcher/files/clients/";
    public static final String SKINS_URL = "https://minezone.su/skins/";
    public static final String CLOAKS_URL = "https://minezone.su/cloaks/";

    public Config(File configFile) {
        this.configFile = configFile;
        this.properties = new Properties();
    }

    public void load() {
        if (this.configFile.exists()) {
            try (FileInputStream fis = new FileInputStream(this.configFile);){
                this.properties.load(fis);
                LogHelper.info("Config loaded successfully");
            }
            catch (IOException e) {
                LogHelper.error("Failed to load config", e);
            }
        } else {
            this.setDefaults();
            this.save();
        }
    }

    public void save() {
        try (FileOutputStream fos = new FileOutputStream(this.configFile);){
            this.properties.store(fos, "MineZone Launcher Configuration");
            LogHelper.info("Config saved successfully");
        }
        catch (IOException e) {
            LogHelper.error("Failed to save config", e);
        }
    }

    private void setDefaults() {
        this.properties.setProperty("ram.min", "2048");
        this.properties.setProperty("ram.max", "4096");
        this.properties.setProperty("last.login", "");
        this.properties.setProperty("last.client", "1.12.2");
        this.properties.setProperty("fullscreen", "false");
        this.properties.setProperty("autoenter", "false");
        this.properties.setProperty("hide.launcher", "true");
        this.properties.setProperty("vote.url", "https://minecraft-servers.ru/project/minezone");
    }

    public String get(String key) {
        return this.properties.getProperty(key, "");
    }

    public String get(String key, String defaultValue) {
        return this.properties.getProperty(key, defaultValue);
    }

    public void set(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public int getInt(String key, int defaultValue) {
        try {
            return Integer.parseInt(this.properties.getProperty(key, String.valueOf(defaultValue)));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return Boolean.parseBoolean(this.properties.getProperty(key, String.valueOf(defaultValue)));
    }
}

