/*
 * Decompiled with CFR 0.152.
 */
package ru.minezone.launcher.security;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import javax.swing.SwingUtilities;
import ru.minezone.launcher.utils.LogHelper;

public class SingleInstanceLock {
    private static final int LOCK_PORT = 47777;
    private static final String LOCK_FILE = ".launcher.lock";
    private static ServerSocket lockSocket = null;
    private static FileLock fileLock = null;
    private static FileChannel lockChannel = null;

    public static boolean tryLock() {
        if (SingleInstanceLock.trySocketLock()) {
            return true;
        }
        return SingleInstanceLock.tryFileLock();
    }

    private static boolean trySocketLock() {
        try {
            lockSocket = new ServerSocket(47777, 1, InetAddress.getLoopbackAddress());
            LogHelper.info("Instance lock acquired (socket)");
            return true;
        }
        catch (IOException e) {
            LogHelper.warning("Another instance is already running (socket)");
            SingleInstanceLock.tryActivateExisting();
            return false;
        }
    }

    private static boolean tryFileLock() {
        try {
            Path lockPath = SingleInstanceLock.getLockFilePath();
            Files.createDirectories(lockPath.getParent(), new FileAttribute[0]);
            lockChannel = FileChannel.open(lockPath, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
            fileLock = lockChannel.tryLock();
            if (fileLock != null) {
                String pid = ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
                lockChannel.write(ByteBuffer.wrap(pid.getBytes()));
                Runtime.getRuntime().addShutdownHook(new Thread(SingleInstanceLock::release));
                LogHelper.info("Instance lock acquired (file)");
                return true;
            }
            lockChannel.close();
            LogHelper.warning("Another instance is already running (file)");
            return false;
        }
        catch (Exception e) {
            LogHelper.warning("Could not acquire file lock: " + e.getMessage());
            return false;
        }
    }

    private static Path getLockFilePath() {
        String userHome = System.getProperty("user.home");
        return Paths.get(userHome, ".minezone", LOCK_FILE);
    }

    private static void tryActivateExisting() {
        try {
            Socket socket = new Socket(InetAddress.getLoopbackAddress(), 47777);
            socket.getOutputStream().write("ACTIVATE\n".getBytes());
            socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void startCommandListener(Runnable onActivate) {
        if (lockSocket == null) {
            return;
        }
        Thread listener = new Thread(() -> {
            while (!lockSocket.isClosed()) {
                try {
                    Socket client = lockSocket.accept();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(client.getInputStream()));
                    String command = reader.readLine();
                    if ("ACTIVATE".equals(command)) {
                        SwingUtilities.invokeLater(onActivate);
                    }
                    client.close();
                }
                catch (Exception exception) {}
            }
        }, "InstanceListener");
        listener.setDaemon(true);
        listener.start();
    }

    public static void release() {
        try {
            if (lockSocket != null && !lockSocket.isClosed()) {
                lockSocket.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (fileLock != null && fileLock.isValid()) {
                fileLock.release();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (lockChannel != null && lockChannel.isOpen()) {
                lockChannel.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Files.deleteIfExists(SingleInstanceLock.getLockFilePath());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isLocked() {
        return lockSocket != null || fileLock != null;
    }
}

