/*
 * Decompiled with CFR 0.152.
 */
package ru.minezone.launcher.security;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.net.HttpURLConnection;
import java.net.NetworkInterface;
import java.net.URL;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.util.Base64;
import java.util.Enumeration;
import java.util.List;
import java.util.UUID;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import ru.minezone.launcher.utils.LogHelper;

public class LauncherGuard {
    private static final String GUARD_SERVER = "https://minezone.su/launcher/guard.php";
    private static boolean initialized = false;
    private static String launcherHash = null;
    private static String hwid = null;
    private static final String[] SUSPICIOUS_PROCESSES = new String[]{"ollydbg", "x64dbg", "x32dbg", "ida", "ida64", "idaq", "idaq64", "windbg", "dbgview", "processhacker", "procmon", "procexp", "wireshark", "fiddler", "charles", "burp", "mitmproxy", "cheatengine", "artmoney", "gamehacker", "dnspy", "dotpeek", "jd-gui", "jadx", "bytecode", "recaf", "cfr", "procyon", "httpanalyzer", "httpdebugger", "smartsniff"};
    private static final String[] SUSPICIOUS_WINDOWS = new String[]{"OllyDbg", "x64dbg", "IDA", "Ghidra", "Cheat Engine", "Process Hacker", "Process Monitor", "HTTP Debugger", "Fiddler", "Wireshark", "dnSpy", "JD-GUI", "Recaf"};

    public static boolean initialize() {
        if (initialized) {
            return true;
        }
        try {
            LogHelper.info("Initializing security...");
            if (LauncherGuard.isDebuggerAttached()) {
                LauncherGuard.showSecurityError("\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d \u043e\u0442\u043b\u0430\u0434\u0447\u0438\u043a!");
                return false;
            }
            if (LauncherGuard.hasSuspiciousProcesses()) {
                LauncherGuard.showSecurityError("\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u043e \u043f\u043e\u0434\u043e\u0437\u0440\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u041f\u041e!");
                return false;
            }
            if (LauncherGuard.isVirtualMachine() && !LauncherGuard.isVMAllowed()) {
                LogHelper.warning("Running in VM - some features may be limited");
            }
            launcherHash = LauncherGuard.calculateLauncherHash();
            hwid = LauncherGuard.generateHWID();
            LauncherGuard.verifyIntegrityAsync();
            LauncherGuard.startSecurityMonitor();
            initialized = true;
            LogHelper.info("Security initialized successfully");
            return true;
        }
        catch (Exception e) {
            LogHelper.error("Security initialization failed", e);
            return false;
        }
    }

    public static boolean isDebuggerAttached() {
        List<String> args = ManagementFactory.getRuntimeMXBean().getInputArguments();
        for (String arg : args) {
            String lower = arg.toLowerCase();
            if (!lower.contains("-agentlib:jdwp") && !lower.contains("-xdebug") && !lower.contains("-xrunjdwp") && !lower.contains("suspend=")) continue;
            return true;
        }
        long start = System.nanoTime();
        for (int i = 0; i < 1000000; ++i) {
            Math.sqrt(i);
        }
        long elapsed = System.nanoTime() - start;
        return elapsed > 500000000L;
    }

    public static boolean hasSuspiciousProcesses() {
        try {
            String os = System.getProperty("os.name").toLowerCase();
            if (os.contains("win")) {
                return LauncherGuard.checkWindowsProcesses();
            }
            if (os.contains("linux") || os.contains("mac")) {
                return LauncherGuard.checkUnixProcesses();
            }
        }
        catch (Exception e) {
            LogHelper.warning("Could not check processes: " + e.getMessage());
        }
        return false;
    }

    private static boolean checkWindowsProcesses() throws Exception {
        String line;
        Process process = Runtime.getRuntime().exec("tasklist /FO CSV /NH");
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        while ((line = reader.readLine()) != null) {
            String lower = line.toLowerCase();
            for (String suspicious : SUSPICIOUS_PROCESSES) {
                if (!lower.contains(suspicious)) continue;
                LogHelper.warning("Suspicious process detected: " + suspicious);
                return true;
            }
        }
        reader.close();
        return false;
    }

    private static boolean checkUnixProcesses() throws Exception {
        String line;
        Process process = Runtime.getRuntime().exec("ps aux");
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        while ((line = reader.readLine()) != null) {
            String lower = line.toLowerCase();
            for (String suspicious : SUSPICIOUS_PROCESSES) {
                if (!lower.contains(suspicious)) continue;
                LogHelper.warning("Suspicious process detected: " + suspicious);
                return true;
            }
        }
        reader.close();
        return false;
    }

    public static boolean isVirtualMachine() {
        String[] vmIndicators = new String[]{"VMware", "VirtualBox", "Virtual", "VBOX", "Oracle VM", "Hyper-V", "Parallels", "QEMU", "KVM", "Xen"};
        String vendor = System.getProperty("java.vm.vendor", "");
        String vmName = System.getProperty("java.vm.name", "");
        String osName = System.getProperty("os.name", "");
        for (String indicator : vmIndicators) {
            if (!vendor.contains(indicator) && !vmName.contains(indicator) && !osName.contains(indicator)) continue;
            return true;
        }
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface ni = interfaces.nextElement();
                byte[] mac = ni.getHardwareAddress();
                if (mac == null || mac.length < 3 || !(mac[0] == 0 && mac[1] == 12 && mac[2] == 41 || mac[0] == 0 && mac[1] == 80 && mac[2] == 86 || mac[0] == 8 && mac[1] == 0 && mac[2] == 39) && (mac[0] != 0 || mac[1] != 21 || mac[2] != 93)) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static boolean isVMAllowed() {
        return true;
    }

    public static String calculateLauncherHash() {
        try {
            String jarPath = LauncherGuard.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
            File jarFile = new File(jarPath);
            if (!jarFile.exists() || !jarFile.getName().endsWith(".jar")) {
                return LauncherGuard.calculateClassesHash();
            }
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            try (FileInputStream fis = new FileInputStream(jarFile);){
                int read;
                byte[] buffer = new byte[8192];
                while ((read = fis.read(buffer)) != -1) {
                    digest.update(buffer, 0, read);
                }
            }
            byte[] hash = digest.digest();
            StringBuilder sb = new StringBuilder();
            for (byte b : hash) {
                sb.append(String.format("%02x", b));
            }
            return sb.toString();
        }
        catch (Exception e) {
            LogHelper.error("Failed to calculate launcher hash", e);
            return null;
        }
    }

    private static String calculateClassesHash() throws Exception {
        String[] criticalClasses;
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        for (String className : criticalClasses = new String[]{"ru.minezone.launcher.MineZoneLauncher", "ru.minezone.launcher.auth.AuthManager", "ru.minezone.launcher.security.LauncherGuard"}) {
            String path = "/" + className.replace('.', '/') + ".class";
            try (InputStream is = LauncherGuard.class.getResourceAsStream(path);){
                int read;
                if (is == null) continue;
                byte[] buffer = new byte[8192];
                while ((read = is.read(buffer)) != -1) {
                    digest.update(buffer, 0, read);
                }
            }
        }
        byte[] hash = digest.digest();
        StringBuilder sb = new StringBuilder();
        for (byte b : hash) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    public static String generateHWID() {
        try {
            StringBuilder hwid = new StringBuilder();
            String cpu = System.getenv("PROCESSOR_IDENTIFIER");
            if (cpu == null) {
                cpu = System.getProperty("os.arch");
            }
            hwid.append(cpu);
            try {
                Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
                while (interfaces.hasMoreElements()) {
                    NetworkInterface ni = interfaces.nextElement();
                    byte[] mac = ni.getHardwareAddress();
                    if (mac == null || mac.length <= 0) continue;
                    for (byte b : mac) {
                        hwid.append(String.format("%02X", b));
                    }
                    break;
                }
            }
            catch (Exception interfaces) {
                // empty catch block
            }
            hwid.append(System.getenv("COMPUTERNAME"));
            hwid.append(System.getProperty("user.name"));
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(hwid.toString().getBytes());
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < 16; ++i) {
                result.append(String.format("%02x", hash[i]));
            }
            return result.toString();
        }
        catch (Exception e) {
            LogHelper.error("Failed to generate HWID", e);
            return UUID.randomUUID().toString().replace("-", "").substring(0, 32);
        }
    }

    private static void verifyIntegrityAsync() {
        new Thread(() -> {
            block28: {
                try {
                    URL url = new URL(GUARD_SERVER);
                    HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                    conn.setRequestMethod("POST");
                    conn.setDoOutput(true);
                    conn.setConnectTimeout(5000);
                    conn.setReadTimeout(5000);
                    String data = String.format("action=verify&hash=%s&hwid=%s&version=%s", URLEncoder.encode(launcherHash != null ? launcherHash : "", "UTF-8"), URLEncoder.encode(hwid != null ? hwid : "", "UTF-8"), URLEncoder.encode("1.0.0", "UTF-8"));
                    try (OutputStream os = conn.getOutputStream();){
                        os.write(data.getBytes());
                    }
                    int responseCode = conn.getResponseCode();
                    if (responseCode != 200) break block28;
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
                        String response = reader.readLine();
                        if (response != null && response.contains("blocked")) {
                            SwingUtilities.invokeLater(() -> {
                                LauncherGuard.showSecurityError("\u0412\u0430\u0448 \u0430\u043a\u043a\u0430\u0443\u043d\u0442 \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d!");
                                System.exit(1);
                            });
                        }
                    }
                }
                catch (Exception e) {
                    LogHelper.warning("Could not verify integrity: " + e.getMessage());
                }
            }
        }, "SecurityVerifier").start();
    }

    private static void startSecurityMonitor() {
        Thread monitor = new Thread(() -> {
            block3: while (true) {
                try {
                    do {
                        Thread.sleep(30000L);
                        if (!LauncherGuard.isDebuggerAttached()) continue;
                        SwingUtilities.invokeLater(() -> {
                            LauncherGuard.showSecurityError("\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d \u043e\u0442\u043b\u0430\u0434\u0447\u0438\u043a!");
                            System.exit(1);
                        });
                        break block3;
                    } while (!LauncherGuard.hasSuspiciousProcesses());
                    SwingUtilities.invokeLater(() -> {
                        LauncherGuard.showSecurityError("\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u043e \u043f\u043e\u0434\u043e\u0437\u0440\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u041f\u041e!");
                        System.exit(1);
                    });
                }
                catch (InterruptedException e) {
                }
                catch (Exception e) {
                    LogHelper.warning("Security monitor error: " + e.getMessage());
                    continue;
                }
                break;
            }
        }, "SecurityMonitor");
        monitor.setDaemon(true);
        monitor.start();
    }

    private static void showSecurityError(String message) {
        JOptionPane.showMessageDialog(null, message + "\n\n\u0417\u0430\u043f\u0443\u0441\u043a \u043b\u0430\u0443\u043d\u0447\u0435\u0440\u0430 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u0435\u043d.\n\u041e\u0431\u0440\u0430\u0442\u0438\u0442\u0435\u0441\u044c \u0432 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u043a\u0443.", "\u041e\u0448\u0438\u0431\u043a\u0430 \u0431\u0435\u0437\u043e\u043f\u0430\u0441\u043d\u043e\u0441\u0442\u0438", 0);
    }

    public static String getHWID() {
        if (hwid == null) {
            hwid = LauncherGuard.generateHWID();
        }
        return hwid;
    }

    public static String getLauncherHash() {
        return launcherHash;
    }

    public static String encrypt(String data, String key) {
        try {
            byte[] keyBytes = key.getBytes();
            byte[] dataBytes = data.getBytes();
            byte[] result = new byte[dataBytes.length];
            for (int i = 0; i < dataBytes.length; ++i) {
                result[i] = (byte)(dataBytes[i] ^ keyBytes[i % keyBytes.length]);
            }
            return Base64.getEncoder().encodeToString(result);
        }
        catch (Exception e) {
            return data;
        }
    }

    public static String decrypt(String data, String key) {
        try {
            byte[] keyBytes = key.getBytes();
            byte[] dataBytes = Base64.getDecoder().decode(data);
            byte[] result = new byte[dataBytes.length];
            for (int i = 0; i < dataBytes.length; ++i) {
                result[i] = (byte)(dataBytes[i] ^ keyBytes[i % keyBytes.length]);
            }
            return new String(result);
        }
        catch (Exception e) {
            return data;
        }
    }
}

