/*
 * Decompiled with CFR 0.152.
 */
package ru.minezone.launcher.security;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import ru.minezone.launcher.MineZoneLauncher;
import ru.minezone.launcher.client.ClientProfile;
import ru.minezone.launcher.utils.Config;
import ru.minezone.launcher.utils.LogHelper;

public class ClientIntegrityChecker {
    private final Map<String, String> validHashes = new ConcurrentHashMap<String, String>();
    private final Set<String> allowedFiles = new HashSet<String>();
    private static final Set<String> ALLOWED_MOD_EXTENSIONS = new HashSet<String>(Arrays.asList(".jar", ".jar.disabled", ".zip"));
    private static final Set<String> MUTABLE_DIRS = new HashSet<String>(Arrays.asList("saves", "screenshots", "logs", "resourcepacks", "shaderpacks", "crash-reports", "schematics", "journeymap", "optional"));
    private final File clientDir;
    private final ClientProfile profile;
    private volatile boolean monitoring = false;
    private volatile boolean initialCheckComplete = false;
    private Thread monitorThread;
    private Process gameProcess;
    private static final long INITIAL_CHECK_DURATION = 30000L;
    private static final long MONITOR_INTERVAL = 15000L;
    private Consumer<String> onFileDeletedCallback;
    private final List<String> deletedFiles = new ArrayList<String>();

    public ClientIntegrityChecker(File clientDir, ClientProfile profile) {
        this.clientDir = clientDir;
        this.profile = profile;
        this.loadAllowedFiles();
    }

    private void loadAllowedFiles() {
        block17: {
            try {
                File exceptionsFile;
                Config config = MineZoneLauncher.getInstance().getConfig();
                String allowed = config.get("integrity.allowed_mods", "");
                if (!allowed.isEmpty()) {
                    String[] files;
                    for (String file : files = allowed.split(",")) {
                        String trimmed = file.trim().toLowerCase();
                        if (trimmed.isEmpty()) continue;
                        this.allowedFiles.add(trimmed);
                        LogHelper.info("Allowed mod: " + trimmed);
                    }
                }
                if (!(exceptionsFile = new File(this.clientDir, "mods_allowed.txt")).exists()) break block17;
                try (BufferedReader reader = new BufferedReader(new FileReader(exceptionsFile));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        if ((line = line.trim().toLowerCase()).isEmpty() || line.startsWith("#")) continue;
                        this.allowedFiles.add(line);
                        LogHelper.info("Allowed mod (from file): " + line);
                    }
                }
            }
            catch (Exception e) {
                LogHelper.warning("Failed to load allowed mods: " + e.getMessage());
            }
        }
    }

    private boolean isFileAllowed(String fileName) {
        String lower = fileName.toLowerCase();
        if (this.allowedFiles.contains(lower)) {
            return true;
        }
        for (String allowed : this.allowedFiles) {
            String prefix;
            if (!allowed.endsWith("*") || !lower.startsWith(prefix = allowed.substring(0, allowed.length() - 1))) continue;
            return true;
        }
        return false;
    }

    public boolean initialize() {
        try {
            File coremodsDir;
            LogHelper.info("Initializing client integrity checker...");
            this.validHashes.clear();
            File modsDir = new File(this.clientDir, "mods");
            if (modsDir.exists()) {
                this.scanDirectory(modsDir, "mods");
            }
            if ((coremodsDir = new File(this.clientDir, "coremods")).exists()) {
                this.scanDirectory(coremodsDir, "coremods");
            }
            LogHelper.info("Integrity checker initialized with " + this.validHashes.size() + " valid files");
            return true;
        }
        catch (Exception e) {
            LogHelper.error("Failed to initialize integrity checker", e);
            return false;
        }
    }

    public void startMonitoring(Process gameProcess, Consumer<String> onFileDeleted) {
        if (this.monitoring) {
            return;
        }
        this.gameProcess = gameProcess;
        this.onFileDeletedCallback = onFileDeleted;
        this.monitoring = true;
        this.initialCheckComplete = false;
        this.deletedFiles.clear();
        this.monitorThread = new Thread(() -> {
            LogHelper.info("Client integrity monitoring started (initial check: 30 sec)");
            long startTime = System.currentTimeMillis();
            while (this.monitoring && gameProcess.isAlive()) {
                long elapsed = System.currentTimeMillis() - startTime;
                if (!this.initialCheckComplete && elapsed < 30000L) {
                    this.checkAndRemoveIllegalFiles();
                    try {
                        Thread.sleep(3000L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
                if (!this.initialCheckComplete) {
                    this.initialCheckComplete = true;
                    LogHelper.info("Initial integrity check complete. Switching to monitoring mode.");
                    if (!this.deletedFiles.isEmpty()) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("\u0423\u0434\u0430\u043b\u0435\u043d\u043e \u043f\u043e\u0434\u043b\u043e\u0436\u0435\u043d\u043d\u044b\u0445 \u0444\u0430\u0439\u043b\u043e\u0432: ").append(this.deletedFiles.size());
                        for (String f : this.deletedFiles) {
                            sb.append("\n - ").append(f);
                        }
                        LogHelper.warning(sb.toString());
                    }
                }
                this.checkAndRemoveIllegalFiles();
                try {
                    Thread.sleep(15000L);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
            LogHelper.info("Client integrity monitoring stopped");
        }, "IntegrityMonitor");
        this.monitorThread.setDaemon(true);
        this.monitorThread.start();
    }

    private void checkAndRemoveIllegalFiles() {
        try {
            File coremodsDir;
            File modsDir = new File(this.clientDir, "mods");
            if (modsDir.exists()) {
                this.checkDirectoryAndRemove(modsDir, "mods");
            }
            if ((coremodsDir = new File(this.clientDir, "coremods")).exists()) {
                this.checkDirectoryAndRemove(coremodsDir, "coremods");
            }
        }
        catch (Exception e) {
            LogHelper.warning("Integrity check error: " + e.getMessage());
        }
    }

    private void checkDirectoryAndRemove(File dir, String prefix) {
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            String relativePath = prefix + "/" + file.getName();
            if (file.isDirectory()) {
                if (MUTABLE_DIRS.contains(file.getName().toLowerCase())) continue;
                this.checkDirectoryAndRemove(file, relativePath);
                continue;
            }
            String name = file.getName().toLowerCase();
            boolean isModFile = false;
            for (String ext : ALLOWED_MOD_EXTENSIONS) {
                if (!name.endsWith(ext)) continue;
                isModFile = true;
                break;
            }
            if (!isModFile || this.validHashes.containsKey(relativePath)) continue;
            if (this.isFileAllowed(file.getName())) {
                LogHelper.info("Allowed file (exception): " + file.getName());
                continue;
            }
            LogHelper.warning("Removing illegal file: " + file.getName());
            try {
                if (file.delete()) {
                    this.deletedFiles.add(file.getName());
                    if (this.onFileDeletedCallback != null) {
                        this.onFileDeletedCallback.accept(file.getName());
                    }
                    LogHelper.info("Deleted: " + file.getName());
                    continue;
                }
                file.deleteOnExit();
                LogHelper.warning("File locked, will delete on exit: " + file.getName());
            }
            catch (Exception e) {
                LogHelper.warning("Failed to delete: " + file.getName() + " - " + e.getMessage());
            }
        }
    }

    public void stopMonitoring() {
        this.monitoring = false;
        if (this.monitorThread != null) {
            this.monitorThread.interrupt();
        }
    }

    private void scanDirectory(File dir, String prefix) {
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            String relativePath = prefix + "/" + file.getName();
            if (file.isDirectory()) {
                if (MUTABLE_DIRS.contains(file.getName().toLowerCase())) continue;
                this.scanDirectory(file, relativePath);
                continue;
            }
            this.scanFile(file, relativePath);
        }
    }

    private void scanFile(File file, String relativePath) {
        if (!file.exists()) {
            return;
        }
        try {
            String hash = this.calculateHash(file);
            this.validHashes.put(relativePath, hash);
        }
        catch (Exception e) {
            LogHelper.warning("Failed to hash: " + relativePath);
        }
    }

    private String calculateHash(File file) throws Exception {
        MessageDigest md = MessageDigest.getInstance("MD5");
        try (FileInputStream fis = new FileInputStream(file);){
            int read;
            byte[] buffer = new byte[8192];
            while ((read = fis.read(buffer)) != -1) {
                md.update(buffer, 0, read);
            }
        }
        byte[] hash = md.digest();
        StringBuilder sb = new StringBuilder();
        for (byte b : hash) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    public int countMods() {
        int count = 0;
        File modsDir = new File(this.clientDir, "mods");
        if (modsDir.exists()) {
            count += this.countJarsInDir(modsDir);
        }
        return count;
    }

    private int countJarsInDir(File dir) {
        int count = 0;
        File[] files = dir.listFiles();
        if (files == null) {
            return 0;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                if (MUTABLE_DIRS.contains(file.getName().toLowerCase())) continue;
                count += this.countJarsInDir(file);
                continue;
            }
            if (!file.getName().endsWith(".jar")) continue;
            ++count;
        }
        return count;
    }

    public List<String> getDeletedFiles() {
        return new ArrayList<String>(this.deletedFiles);
    }

    public boolean isInitialCheckComplete() {
        return this.initialCheckComplete;
    }

    public void addAllowedException(String fileName) {
        this.allowedFiles.add(fileName.toLowerCase());
    }

    public static void saveAllowedMods(List<String> mods) {
        try {
            Config config = MineZoneLauncher.getInstance().getConfig();
            config.set("integrity.allowed_mods", String.join((CharSequence)",", mods));
            config.save();
        }
        catch (Exception e) {
            LogHelper.error("Failed to save allowed mods", e);
        }
    }
}

