/*
 * Decompiled with CFR 0.152.
 */
package ru.minezone.launcher.security;

import java.lang.reflect.Field;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import ru.minezone.launcher.utils.LogHelper;

public class AntiDump {
    private static boolean enabled = false;
    private static final List<String> protectedStrings = new ArrayList<String>();

    public static void enable() {
        if (enabled) {
            return;
        }
        try {
            AntiDump.clearStringPool();
            AntiDump.protectFromReflection();
            AntiDump.monitorClassLoaders();
            enabled = true;
            LogHelper.info("AntiDump protection enabled");
        }
        catch (Exception e) {
            LogHelper.warning("Could not enable AntiDump: " + e.getMessage());
        }
    }

    public static void protect(String sensitive) {
        if (sensitive != null) {
            protectedStrings.add(sensitive);
        }
    }

    public static void clearSensitiveData() {
        for (String s : protectedStrings) {
            try {
                AntiDump.clearString(s);
            }
            catch (Exception exception) {}
        }
        protectedStrings.clear();
        System.gc();
        System.runFinalization();
    }

    private static void clearString(String s) throws Exception {
        if (s == null) {
            return;
        }
        Field valueField = String.class.getDeclaredField("value");
        valueField.setAccessible(true);
        Object value = valueField.get(s);
        if (value instanceof char[]) {
            char[] chars = (char[])value;
            Arrays.fill(chars, '\u0000');
        } else if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            Arrays.fill(bytes, (byte)0);
        }
    }

    private static void clearStringPool() {
        for (int i = 0; i < 10000; ++i) {
            String garbage = "garbage" + System.nanoTime() + Math.random();
            garbage.intern();
        }
        System.gc();
    }

    private static void protectFromReflection() {
        try {
            if (System.getSecurityManager() != null) {
                LogHelper.info("SecurityManager already set, skipping");
                return;
            }
            System.setSecurityManager(new SecurityManager(){

                @Override
                public void checkPermission(Permission perm) {
                    String name = perm.getName();
                    if (name == null) {
                        return;
                    }
                    if (name.equals("setSecurityManager")) {
                        StackTraceElement[] stack;
                        for (StackTraceElement el : stack = Thread.currentThread().getStackTrace()) {
                            String cn = el.getClassName();
                            if (!cn.startsWith("ru.minezone.launcher")) continue;
                            return;
                        }
                        throw new SecurityException("Cannot change SecurityManager");
                    }
                }

                @Override
                public void checkPackageAccess(String pkg) {
                }

                @Override
                public void checkAccess(Thread t) {
                }

                @Override
                public void checkAccess(ThreadGroup g) {
                }
            });
            LogHelper.info("SecurityManager installed (safe mode)");
        }
        catch (Exception e) {
            LogHelper.warning("Could not set SecurityManager: " + e.getMessage());
        }
    }

    private static void monitorClassLoaders() {
        Thread monitor = new Thread(() -> {
            ClassLoader systemLoader = ClassLoader.getSystemClassLoader();
            while (true) {
                try {
                    block4: while (true) {
                        Thread.sleep(5000L);
                        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
                        while (true) {
                            if (currentLoader == null) continue block4;
                            String loaderName = currentLoader.getClass().getName();
                            if (loaderName.contains("inject") || loaderName.contains("hook") || loaderName.contains("agent") || loaderName.contains("instrument")) {
                                LogHelper.warning("Suspicious ClassLoader detected: " + loaderName);
                            }
                            currentLoader = currentLoader.getParent();
                        }
                        break;
                    }
                }
                catch (InterruptedException e) {
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
        }, "ClassLoaderMonitor");
        monitor.setDaemon(true);
        monitor.start();
    }

    public static boolean isCallerTrusted() {
        StackTraceElement[] stack;
        for (StackTraceElement element : stack = Thread.currentThread().getStackTrace()) {
            String className = element.getClassName();
            if (className.startsWith("java.") || className.startsWith("javax.") || className.startsWith("sun.") || className.startsWith("ru.minezone.launcher")) continue;
            return false;
        }
        return true;
    }

    public static byte[] obfuscateInMemory(byte[] data) {
        if (data == null) {
            return null;
        }
        byte[] result = new byte[data.length];
        long seed = System.nanoTime();
        for (int i = 0; i < data.length; ++i) {
            result[i] = (byte)((long)data[i] ^ seed >> i % 8 ^ (long)(i * 17));
        }
        Arrays.fill(data, (byte)0);
        return result;
    }

    public static byte[] deobfuscateInMemory(byte[] data, long seed) {
        if (data == null) {
            return null;
        }
        byte[] result = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            result[i] = (byte)((long)data[i] ^ seed >> i % 8 ^ (long)(i * 17));
        }
        return result;
    }
}

