/*
 * Decompiled with CFR 0.152.
 */
package ru.minezone.launcher.request;

import org.json.JSONObject;
import ru.minezone.launcher.utils.LogHelper;

public class Response {
    private boolean success;
    private JSONObject data;

    public Response(boolean success) {
        this.success = success;
        this.data = new JSONObject();
    }

    public Response(JSONObject json) {
        this.data = json;
        this.success = json.optBoolean("success", !json.has("error"));
    }

    public static Response parse(String responseBody) {
        if (responseBody == null || responseBody.isEmpty()) {
            return new Response(false);
        }
        try {
            JSONObject json = new JSONObject(responseBody);
            return new Response(json);
        }
        catch (Exception e) {
            LogHelper.error("Failed to parse response", e);
            return new Response(false);
        }
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getString(String key) {
        return this.data.optString(key, "");
    }

    public int getInt(String key) {
        return this.data.optInt(key, 0);
    }

    public boolean getBoolean(String key) {
        return this.data.optBoolean(key, false);
    }
}

