/*
 * Decompiled with CFR 0.152.
 */
package ru.minezone.launcher.request;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import ru.minezone.launcher.request.Response;
import ru.minezone.launcher.utils.LogHelper;

public class RequestManager {
    private static final int TIMEOUT = 15000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Response sendRequest(String urlString, Map<String, String> params) throws IOException {
        LogHelper.debug("Sending request to: " + urlString);
        URL url = new URL(urlString);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        try {
            String responseBody;
            connection.setRequestMethod("POST");
            connection.setConnectTimeout(15000);
            connection.setReadTimeout(15000);
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            connection.setRequestProperty("User-Agent", "MineZoneLauncher/1.0");
            String postData = RequestManager.buildPostData(params);
            try (OutputStream os = connection.getOutputStream();){
                os.write(postData.getBytes(StandardCharsets.UTF_8));
            }
            int responseCode = connection.getResponseCode();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(responseCode >= 200 && responseCode < 300 ? connection.getInputStream() : connection.getErrorStream(), StandardCharsets.UTF_8));){
                String line;
                StringBuilder sb = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                }
                responseBody = sb.toString();
            }
            Response response = Response.parse(responseBody);
            return response;
        }
        finally {
            connection.disconnect();
        }
    }

    private static String buildPostData(Map<String, String> params) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append(URLEncoder.encode(entry.getKey(), "UTF-8"));
            sb.append("=");
            sb.append(URLEncoder.encode(entry.getValue(), "UTF-8"));
        }
        return sb.toString();
    }
}

