/*
 * Decompiled with CFR 0.152.
 */
package ru.minezone.launcher.gui.components;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.RoundRectangle2D;
import java.net.URI;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import ru.minezone.launcher.gui.components.ModernButton;
import ru.minezone.launcher.utils.Config;

public class VoteDialog
extends JDialog {
    private static final Color CYAN = new Color(56, 189, 248);
    private static final Color PURPLE = new Color(139, 92, 246);
    private static final Color DIAMOND_BLUE = new Color(30, 180, 255);
    private static final Color DIAMOND_LIGHT = new Color(150, 220, 255);
    private Timer animTimer;
    private double time = 0.0;
    private double diamondRotation = 0.0;
    private double diamondScale = 1.0;
    private double sparklePhase = 0.0;
    private String voteUrl;
    private Config config;
    private Runnable onVoteClick;

    public VoteDialog(JFrame parent, Config config) {
        super((Frame)parent, true);
        this.config = config;
        this.voteUrl = config.get("vote.url", "https://minecraft-servers.ru/project/minezone");
        this.setUndecorated(true);
        this.setSize(380, 320);
        this.setLocationRelativeTo(parent);
        this.setBackground(new Color(0, 0, 0, 0));
        this.initUI();
        this.startAnimation();
    }

    public static boolean shouldShow(String username) {
        long dayMs;
        Preferences prefs = Preferences.userNodeForPackage(VoteDialog.class);
        long lastVote = prefs.getLong("lastVote_" + username, 0L);
        long now = System.currentTimeMillis();
        return now - lastVote >= (dayMs = 86400000L);
    }

    public static void markVoted(String username) {
        Preferences prefs = Preferences.userNodeForPackage(VoteDialog.class);
        prefs.putLong("lastVote_" + username, System.currentTimeMillis());
    }

    private void initUI() {
        JPanel mainPanel = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                int w = this.getWidth();
                int h = this.getHeight();
                for (int i = 12; i > 0; --i) {
                    g2d.setColor(new Color(0, 0, 0, 15 - i));
                    g2d.fill(new RoundRectangle2D.Double(i, i, w - i * 2, h - i * 2, 24.0, 24.0));
                }
                g2d.setPaint(new GradientPaint(0.0f, 0.0f, new Color(16, 22, 36), 0.0f, h, new Color(10, 14, 24)));
                g2d.fill(new RoundRectangle2D.Double(0.0, 0.0, w, h, 22.0, 22.0));
                double borderPhase = VoteDialog.this.time * 0.4;
                Color bc1 = VoteDialog.this.blendColors(CYAN, PURPLE, (float)(Math.sin(borderPhase) * 0.5 + 0.5));
                Color bc2 = VoteDialog.this.blendColors(PURPLE, DIAMOND_BLUE, (float)(Math.sin(borderPhase + 1.5) * 0.5 + 0.5));
                g2d.setPaint(new LinearGradientPaint(0.0f, 0.0f, w, h, new float[]{0.0f, 0.5f, 1.0f}, new Color[]{bc1, bc2, bc1}));
                g2d.setStroke(new BasicStroke(2.0f));
                g2d.draw(new RoundRectangle2D.Double(1.0, 1.0, w - 2, h - 2, 22.0, 22.0));
                g2d.setPaint(new GradientPaint(0.0f, 0.0f, new Color(255, 255, 255, 20), 0.0f, (float)h * 0.25f, new Color(255, 255, 255, 0)));
                g2d.fill(new RoundRectangle2D.Double(2.0, 2.0, w - 4, (double)h * 0.25, 20.0, 20.0));
                g2d.dispose();
            }
        };
        mainPanel.setOpaque(false);
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.setBorder(BorderFactory.createEmptyBorder(20, 30, 20, 30));
        JPanel topPanel = new JPanel(new FlowLayout(2, 0, 0));
        topPanel.setOpaque(false);
        JButton closeBtn = new JButton(){
            private boolean hover = false;
            {
                this.setPreferredSize(new Dimension(28, 28));
                this.setContentAreaFilled(false);
                this.setBorderPainted(false);
                this.setFocusPainted(false);
                this.setCursor(Cursor.getPredefinedCursor(12));
                this.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        hover = true;
                        this.repaint();
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        hover = false;
                        this.repaint();
                    }
                });
            }

            @Override
            protected void paintComponent(Graphics g) {
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                int w = this.getWidth();
                int h = this.getHeight();
                if (this.hover) {
                    g2d.setColor(new Color(255, 100, 100, 50));
                    g2d.fillOval(2, 2, w - 4, h - 4);
                }
                g2d.setColor(this.hover ? new Color(255, 120, 120) : new Color(120, 130, 150));
                g2d.setStroke(new BasicStroke(2.0f, 1, 1));
                int p = 8;
                g2d.drawLine(p, p, w - p, h - p);
                g2d.drawLine(w - p, p, p, h - p);
                g2d.dispose();
            }
        };
        closeBtn.addActionListener(e -> this.dispose());
        topPanel.add(closeBtn);
        topPanel.setMaximumSize(new Dimension(320, 30));
        mainPanel.add(topPanel);
        JLabel title = new JLabel("\u041f\u0440\u043e\u0433\u043e\u043b\u043e\u0441\u0443\u0439 \u0437\u0430 \u043d\u0430\u0441!");
        title.setFont(new Font("Segoe UI", 1, 20));
        title.setForeground(Color.WHITE);
        title.setAlignmentX(0.5f);
        mainPanel.add(title);
        mainPanel.add(Box.createVerticalStrut(8));
        JLabel desc = new JLabel("<html><center>\u0413\u043e\u043b\u043e\u0441\u0443\u0439 \u043a\u0430\u0436\u0434\u044b\u0439 \u0434\u0435\u043d\u044c<br>\u0438 \u043f\u043e\u043b\u0443\u0447\u0430\u0439 \u0431\u043e\u043d\u0443\u0441\u044b!</center></html>");
        desc.setFont(new Font("Segoe UI", 0, 13));
        desc.setForeground(new Color(160, 170, 190));
        desc.setAlignmentX(0.5f);
        mainPanel.add(desc);
        mainPanel.add(Box.createVerticalStrut(15));
        JPanel rewardPanel = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                int w = this.getWidth();
                int h = this.getHeight();
                int cx = w / 2 - 40;
                int cy = h / 2;
                this.drawAnimatedDiamond(g2d, cx, cy);
                g2d.setFont(new Font("Segoe UI", 1, 28));
                FontMetrics fm = g2d.getFontMetrics();
                String reward = "+50";
                String currency = " \u042d\u041c";
                int textX = cx + 55;
                int textY = cy + fm.getAscent() / 3;
                g2d.setColor(new Color(CYAN.getRed(), CYAN.getGreen(), CYAN.getBlue(), 40));
                g2d.drawString(reward, textX + 1, textY + 1);
                g2d.drawString(reward, textX - 1, textY - 1);
                g2d.setPaint(new LinearGradientPaint(textX, textY - 20, textX + 60, textY + 10, new float[]{0.0f, 0.5f, 1.0f}, new Color[]{CYAN, DIAMOND_LIGHT, CYAN}));
                g2d.drawString(reward, textX, textY);
                g2d.setFont(new Font("Segoe UI", 1, 18));
                g2d.setColor(new Color(180, 200, 220));
                g2d.drawString(currency, textX + fm.stringWidth(reward) - 15, textY);
                g2d.dispose();
            }

            private void drawAnimatedDiamond(Graphics2D g, int cx, int cy) {
                double glowPulse = 0.5 + Math.sin(VoteDialog.this.time * 2.0) * 0.3;
                for (int i = 20; i > 0; --i) {
                    float alpha = (float)(glowPulse * 0.015 * (double)(20 - i));
                    g.setColor(new Color(DIAMOND_BLUE.getRed(), DIAMOND_BLUE.getGreen(), DIAMOND_BLUE.getBlue(), Math.min(255, Math.max(0, (int)(alpha * 255.0f)))));
                    int size = 40 + i * 3;
                    g.fillOval(cx - size / 2, cy - size / 2, size, size);
                }
                AffineTransform old = g.getTransform();
                g.translate(cx, cy);
                double wobble = Math.sin(VoteDialog.this.time * 1.5) * 0.1;
                g.rotate(wobble);
                g.scale(VoteDialog.this.diamondScale, VoteDialog.this.diamondScale);
                int w = 36;
                int h = 44;
                int[] topX = new int[]{0, -w / 2, -w / 3, w / 3, w / 2};
                int[] topY = new int[]{-h / 2 + 5, -h / 4, -h / 2, -h / 2, -h / 4};
                g.setPaint(new GradientPaint(-w / 2, -h / 2, DIAMOND_LIGHT, w / 2, -h / 4, DIAMOND_BLUE));
                g.fillPolygon(topX, topY, 5);
                int[] leftX = new int[]{-w / 2, -w / 3, 0, 0};
                int[] leftY = new int[]{-h / 4, -h / 2, -h / 2 + 5, h / 2};
                g.setPaint(new GradientPaint(-w / 2, 0.0f, new Color(20, 140, 220), 0.0f, h / 2, new Color(10, 80, 160)));
                g.fillPolygon(leftX, leftY, 4);
                int[] rightX = new int[]{w / 2, w / 3, 0, 0};
                int[] rightY = new int[]{-h / 4, -h / 2, -h / 2 + 5, h / 2};
                g.setPaint(new GradientPaint(0.0f, -h / 4, DIAMOND_BLUE, w / 2, h / 2, new Color(40, 160, 240)));
                g.fillPolygon(rightX, rightY, 4);
                int[] centerX = new int[]{0, -w / 3, 0, w / 3};
                int[] centerY = new int[]{-h / 2 + 5, -h / 2, -h / 3, -h / 2};
                g.setPaint(new GradientPaint(0.0f, -h / 2, DIAMOND_LIGHT, 0.0f, -h / 3, new Color(100, 200, 255)));
                g.fillPolygon(centerX, centerY, 4);
                g.setColor(new Color(255, 255, 255, 180));
                g.setStroke(new BasicStroke(1.5f));
                g.drawLine(-w / 4, -h / 3, -w / 6, -h / 4);
                g.setColor(new Color(80, 180, 255, 150));
                g.setStroke(new BasicStroke(1.0f));
                g.drawPolygon(topX, topY, 5);
                g.drawPolygon(leftX, leftY, 4);
                g.drawPolygon(rightX, rightY, 4);
                this.drawSparkles(g, w, h);
                g.setTransform(old);
            }

            private void drawSparkles(Graphics2D g, int w, int h) {
                double sp = VoteDialog.this.sparklePhase;
                g.setColor(new Color(255, 255, 255, 200));
                for (int i = 0; i < 4; ++i) {
                    double angle = sp + (double)i * Math.PI / 2.0;
                    double dist = 30.0 + Math.sin(VoteDialog.this.time * 3.0 + (double)i) * 5.0;
                    int sx = (int)(Math.cos(angle) * dist);
                    int sy = (int)(Math.sin(angle) * dist);
                    float alpha = (float)(0.5 + Math.sin(VoteDialog.this.time * 4.0 + (double)i * 1.5) * 0.5);
                    g.setColor(new Color(255, 255, 255, (int)(alpha * 200.0f)));
                    int size = 3 + (int)(Math.sin(VoteDialog.this.time * 5.0 + (double)i) * 2.0);
                    g.setStroke(new BasicStroke(1.5f));
                    g.drawLine(sx - size, sy, sx + size, sy);
                    g.drawLine(sx, sy - size, sx, sy + size);
                }
            }
        };
        rewardPanel.setOpaque(false);
        rewardPanel.setPreferredSize(new Dimension(300, 90));
        rewardPanel.setMaximumSize(new Dimension(300, 90));
        rewardPanel.setAlignmentX(0.5f);
        mainPanel.add(rewardPanel);
        mainPanel.add(Box.createVerticalStrut(20));
        ModernButton voteButton = new ModernButton("\u0413\u041e\u041b\u041e\u0421\u041e\u0412\u0410\u0422\u042c", ModernButton.ButtonType.PRIMARY);
        voteButton.setMaximumSize(new Dimension(200, 46));
        voteButton.setFont(new Font("Segoe UI", 1, 14));
        voteButton.setAlignmentX(0.5f);
        voteButton.addActionListener(e -> {
            try {
                Desktop.getDesktop().browse(new URI(this.voteUrl));
                if (this.onVoteClick != null) {
                    this.onVoteClick.run();
                }
                this.dispose();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        });
        mainPanel.add(voteButton);
        mainPanel.add(Box.createVerticalStrut(12));
        JLabel hint = new JLabel("\u041e\u0442\u043a\u0440\u044b\u0442\u044c \u0432 \u0431\u0440\u0430\u0443\u0437\u0435\u0440\u0435");
        hint.setFont(new Font("Segoe UI", 0, 11));
        hint.setForeground(new Color(100, 110, 130));
        hint.setAlignmentX(0.5f);
        mainPanel.add(hint);
        this.setContentPane(mainPanel);
    }

    private void startAnimation() {
        this.animTimer = new Timer(16, e -> {
            this.time += 0.016;
            this.sparklePhase += 0.02;
            this.diamondScale = 1.0 + Math.sin(this.time * 2.0) * 0.05;
            this.repaint();
        });
        this.animTimer.start();
    }

    public void setOnVoteClick(Runnable callback) {
        this.onVoteClick = callback;
    }

    private Color blendColors(Color c1, Color c2, float r) {
        r = Math.max(0.0f, Math.min(1.0f, r));
        float ir = 1.0f - r;
        return new Color((int)((float)c1.getRed() * ir + (float)c2.getRed() * r), (int)((float)c1.getGreen() * ir + (float)c2.getGreen() * r), (int)((float)c1.getBlue() * ir + (float)c2.getBlue() * r));
    }

    @Override
    public void dispose() {
        if (this.animTimer != null) {
            this.animTimer.stop();
        }
        super.dispose();
    }
}

