/*
 * Decompiled with CFR 0.152.
 */
package ru.minezone.launcher.gui.components;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.swing.JPanel;
import javax.swing.Timer;

public class SnowfallPanel
extends JPanel {
    private List<Snowflake> snowflakes;
    private Timer animationTimer;
    private Random random;
    private boolean enabled = true;
    private static final int SNOWFLAKE_COUNT = 150;

    public SnowfallPanel() {
        this.setOpaque(false);
        this.random = new Random();
        this.snowflakes = new ArrayList<Snowflake>();
        for (int i = 0; i < 150; ++i) {
            this.snowflakes.add(this.createSnowflake(true));
        }
        this.animationTimer = new Timer(25, e -> {
            if (this.enabled) {
                this.updateSnowflakes();
                this.repaint();
            }
        });
        this.animationTimer.start();
    }

    private Snowflake createSnowflake(boolean randomY) {
        Snowflake s = new Snowflake();
        s.x = this.random.nextInt(Math.max(1, this.getWidth() > 0 ? this.getWidth() : 1200));
        s.y = randomY ? (double)this.random.nextInt(Math.max(1, this.getHeight() > 0 ? this.getHeight() : 700)) : (double)(this.random.nextInt(50) * -1);
        s.size = 1.5 + this.random.nextDouble() * 5.0;
        s.speed = 0.4 + this.random.nextDouble() * 1.8;
        s.opacity = 0.25f + this.random.nextFloat() * 0.75f;
        s.wobbleAmplitude = this.random.nextDouble() * 2.0;
        s.wobbleSpeed = 0.015 + this.random.nextDouble() * 0.025;
        s.wobbleOffset = this.random.nextDouble() * Math.PI * 2.0;
        s.rotation = this.random.nextDouble() * 360.0;
        s.rotationSpeed = this.random.nextDouble() * 3.0 - 1.5;
        s.type = this.random.nextInt(4);
        s.glowSize = s.size * (1.5 + this.random.nextDouble());
        return s;
    }

    private void updateSnowflakes() {
        int width = this.getWidth();
        int height = this.getHeight();
        if (width <= 0 || height <= 0) {
            return;
        }
        for (Snowflake s : this.snowflakes) {
            s.y += s.speed;
            s.wobbleOffset += s.wobbleSpeed;
            s.x += Math.sin(s.wobbleOffset) * s.wobbleAmplitude;
            s.rotation += s.rotationSpeed;
            if (s.y > (double)(height + 15)) {
                s.x = this.random.nextInt(width);
                s.y = -this.random.nextInt(30);
                s.size = 1.5 + this.random.nextDouble() * 5.0;
                s.speed = 0.4 + this.random.nextDouble() * 1.8;
                s.opacity = 0.25f + this.random.nextFloat() * 0.75f;
                s.type = this.random.nextInt(4);
            }
            if (s.x < -15.0) {
                s.x = width + 10;
            }
            if (!(s.x > (double)(width + 15))) continue;
            s.x = -10.0;
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!this.enabled) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (Snowflake s : this.snowflakes) {
            this.drawSnowflake(g2d, s);
        }
        g2d.dispose();
    }

    private void drawSnowflake(Graphics2D g2d, Snowflake s) {
        g2d.setComposite(AlphaComposite.getInstance(3, s.opacity));
        int x = (int)s.x;
        int y = (int)s.y;
        int size = (int)s.size;
        switch (s.type) {
            case 0: {
                g2d.setComposite(AlphaComposite.getInstance(3, s.opacity * 0.3f));
                g2d.setColor(new Color(200, 220, 255));
                g2d.fill(new Ellipse2D.Double((double)x - s.glowSize / 4.0, (double)y - s.glowSize / 4.0, s.glowSize, s.glowSize));
                g2d.setComposite(AlphaComposite.getInstance(3, s.opacity));
                g2d.setColor(Color.WHITE);
                g2d.fill(new Ellipse2D.Double(x, y, size, size));
                break;
            }
            case 1: {
                g2d.setColor(Color.WHITE);
                g2d.translate(x + size / 2, y + size / 2);
                g2d.rotate(Math.toRadians(s.rotation));
                this.drawStar(g2d, 0, 0, size / 2 + 1, size / 4, 6);
                g2d.rotate(-Math.toRadians(s.rotation));
                g2d.translate(-(x + size / 2), -(y + size / 2));
                break;
            }
            case 2: {
                g2d.setColor(Color.WHITE);
                g2d.setStroke(new BasicStroke(1.0f));
                g2d.translate(x + size / 2, y + size / 2);
                g2d.rotate(Math.toRadians(s.rotation));
                int len = size / 2 + 1;
                for (int i = 0; i < 6; ++i) {
                    double angle = 1.0471975511965976 * (double)i;
                    int x2 = (int)(Math.cos(angle) * (double)len);
                    int y2 = (int)(Math.sin(angle) * (double)len);
                    g2d.drawLine(0, 0, x2, y2);
                    if (size <= 3) continue;
                    int mx = (int)(Math.cos(angle) * (double)len * 0.6);
                    int my = (int)(Math.sin(angle) * (double)len * 0.6);
                    int bx = (int)(Math.cos(angle + 0.5) * (double)len * 0.3);
                    int by = (int)(Math.sin(angle + 0.5) * (double)len * 0.3);
                    g2d.drawLine(mx, my, mx + bx, my + by);
                    bx = (int)(Math.cos(angle - 0.5) * (double)len * 0.3);
                    by = (int)(Math.sin(angle - 0.5) * (double)len * 0.3);
                    g2d.drawLine(mx, my, mx + bx, my + by);
                }
                g2d.rotate(-Math.toRadians(s.rotation));
                g2d.translate(-(x + size / 2), -(y + size / 2));
                break;
            }
            case 3: {
                RadialGradientPaint rgp = new RadialGradientPaint((float)x + (float)size / 2.0f, (float)y + (float)size / 2.0f, size, new float[]{0.0f, 0.5f, 1.0f}, new Color[]{new Color(255, 255, 255, (int)(s.opacity * 255.0f)), new Color(200, 220, 255, (int)(s.opacity * 150.0f)), new Color(180, 200, 255, 0)});
                g2d.setPaint(rgp);
                g2d.fill(new Ellipse2D.Double(x - size / 2, y - size / 2, size * 2, size * 2));
            }
        }
    }

    private void drawStar(Graphics2D g, int cx, int cy, int outerR, int innerR, int points) {
        int[] xPoints = new int[points * 2];
        int[] yPoints = new int[points * 2];
        for (int i = 0; i < points * 2; ++i) {
            double angle = Math.PI / (double)points * (double)i - 1.5707963267948966;
            int r = i % 2 == 0 ? outerR : innerR;
            xPoints[i] = cx + (int)(Math.cos(angle) * (double)r);
            yPoints[i] = cy + (int)(Math.sin(angle) * (double)r);
        }
        g.fillPolygon(xPoints, yPoints, points * 2);
    }

    public void setSnowEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    private static class Snowflake {
        double x;
        double y;
        double size;
        double speed;
        float opacity;
        double wobbleAmplitude;
        double wobbleSpeed;
        double wobbleOffset;
        double rotation;
        double rotationSpeed;
        double glowSize;
        int type;

        private Snowflake() {
        }
    }
}

