/*
 * Decompiled with CFR 0.152.
 */
package ru.minezone.launcher.gui.components;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import ru.minezone.launcher.gui.Theme;
import ru.minezone.launcher.gui.components.ModernButton;

public class ServerOfflineDialog
extends JDialog {
    private boolean confirmed = false;
    private float fadeAlpha = 0.0f;
    private float pulsePhase = 0.0f;
    private Timer animTimer;
    private Timer fadeTimer;

    public ServerOfflineDialog(Frame owner, String serverName) {
        super(owner, "\u0421\u0435\u0440\u0432\u0435\u0440 \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d", true);
        this.initUI(serverName);
        this.setOpacity(0.0f);
        this.fadeTimer = new Timer(16, e -> {
            this.fadeAlpha += 0.08f;
            if (this.fadeAlpha >= 1.0f) {
                this.fadeAlpha = 1.0f;
                this.fadeTimer.stop();
            }
            this.setOpacity(this.fadeAlpha);
        });
        this.animTimer = new Timer(16, e -> {
            this.pulsePhase += 0.05f;
            this.repaint();
        });
        this.animTimer.start();
    }

    private void initUI(String serverName) {
        this.setUndecorated(true);
        this.setSize(420, 260);
        this.setLocationRelativeTo(this.getOwner());
        this.setBackground(new Color(0, 0, 0, 0));
        JPanel mainPanel = new JPanel(new BorderLayout()){

            @Override
            protected void paintComponent(Graphics g) {
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                int w = this.getWidth();
                int h = this.getHeight();
                for (int i = 0; i < 15; ++i) {
                    g2d.setColor(new Color(0, 0, 0, 25 - i));
                    g2d.fill(new RoundRectangle2D.Double(i, i, w - i * 2, h - i * 2, 25.0, 25.0));
                }
                GradientPaint bg = new GradientPaint(0.0f, 0.0f, new Color(30, 25, 35), 0.0f, h, new Color(20, 18, 25));
                g2d.setPaint(bg);
                g2d.fill(new RoundRectangle2D.Double(8.0, 8.0, w - 16, h - 16, 20.0, 20.0));
                float pulse = (float)(Math.sin(ServerOfflineDialog.this.pulsePhase) * 0.3 + 0.7);
                GradientPaint border = new GradientPaint(0.0f, 0.0f, new Color(248, 86, 86, (int)(200.0f * pulse)), w, h, new Color(180, 60, 100, (int)(150.0f * pulse)));
                g2d.setPaint(border);
                g2d.setStroke(new BasicStroke(2.5f));
                g2d.draw(new RoundRectangle2D.Double(8.0, 8.0, w - 16, h - 16, 20.0, 20.0));
                GradientPaint topGlow = new GradientPaint(0.0f, 8.0f, new Color(248, 86, 86, (int)(40.0f * pulse)), 0.0f, 60.0f, new Color(248, 86, 86, 0));
                g2d.setPaint(topGlow);
                g2d.fill(new RoundRectangle2D.Double(8.0, 8.0, w - 16, 52.0, 20.0, 20.0));
                g2d.dispose();
            }
        };
        mainPanel.setOpaque(false);
        mainPanel.setBorder(BorderFactory.createEmptyBorder(25, 30, 25, 30));
        JPanel headerPanel = new JPanel(new FlowLayout(1, 15, 0)){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                int iconX = 30;
                int iconY = 8;
                int iconSize = 32;
                float pulse = (float)(Math.sin(ServerOfflineDialog.this.pulsePhase) * 0.4 + 0.6);
                for (int i = 8; i > 0; --i) {
                    g2d.setColor(new Color(248, 86, 86, (int)(15.0f * pulse * (float)(8 - i) / 8.0f)));
                    int offset = i * 2;
                    int[] xPoints = new int[]{iconX + iconSize / 2, iconX - offset, iconX + iconSize + offset};
                    int[] yPoints = new int[]{iconY - offset, iconY + iconSize + offset, iconY + iconSize + offset};
                    g2d.fillPolygon(xPoints, yPoints, 3);
                }
                g2d.setColor(new Color(248, 86, 86));
                int[] xPoints = new int[]{iconX + iconSize / 2, iconX, iconX + iconSize};
                int[] yPoints = new int[]{iconY, iconY + iconSize, iconY + iconSize};
                g2d.fillPolygon(xPoints, yPoints, 3);
                g2d.setColor(Color.WHITE);
                g2d.setFont(new Font("Segoe UI", 1, 18));
                g2d.drawString("!", iconX + iconSize / 2 - 3, iconY + iconSize - 8);
                g2d.dispose();
            }
        };
        headerPanel.setOpaque(false);
        headerPanel.setPreferredSize(new Dimension(360, 50));
        JLabel titleLabel = new JLabel("\u0421\u0435\u0440\u0432\u0435\u0440 \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d");
        titleLabel.setFont(new Font("Segoe UI", 1, 20));
        titleLabel.setForeground(new Color(248, 120, 120));
        headerPanel.add(Box.createHorizontalStrut(50));
        headerPanel.add(titleLabel);
        mainPanel.add((Component)headerPanel, "North");
        JPanel contentPanel = new JPanel();
        contentPanel.setOpaque(false);
        contentPanel.setLayout(new BoxLayout(contentPanel, 1));
        contentPanel.setBorder(BorderFactory.createEmptyBorder(15, 10, 15, 10));
        JLabel messageLabel = new JLabel("<html><center>\u0421\u0435\u0440\u0432\u0435\u0440 <b>" + serverName + "</b> \u0432 \u0434\u0430\u043d\u043d\u044b\u0439 \u043c\u043e\u043c\u0435\u043d\u0442 \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d.<br><br>\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0439 \u043a\u043b\u0438\u0435\u043d\u0442?</center></html>");
        messageLabel.setFont(new Font("Segoe UI", 0, 14));
        messageLabel.setForeground(Theme.TEXT_SECONDARY);
        messageLabel.setAlignmentX(0.5f);
        messageLabel.setHorizontalAlignment(0);
        contentPanel.add(messageLabel);
        mainPanel.add((Component)contentPanel, "Center");
        JPanel buttonsPanel = new JPanel(new FlowLayout(1, 20, 0));
        buttonsPanel.setOpaque(false);
        ModernButton noBtn = new ModernButton("\u041d\u0435\u0442, \u0432\u044b\u0431\u0435\u0440\u0443 \u0434\u0440\u0443\u0433\u043e\u0439", ModernButton.ButtonType.SECONDARY);
        noBtn.setPreferredSize(new Dimension(160, 42));
        noBtn.addActionListener(e -> {
            this.confirmed = false;
            this.fadeOut();
        });
        buttonsPanel.add(noBtn);
        ModernButton yesBtn = new ModernButton("\u0414\u0430, \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c", ModernButton.ButtonType.PRIMARY){

            @Override
            protected void paintComponent(Graphics g) {
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                int w = this.getWidth();
                int h = this.getHeight();
                GradientPaint gradient = new GradientPaint(0.0f, 0.0f, new Color(248, 150, 86), w, h, new Color(248, 86, 86));
                g2d.setPaint(gradient);
                g2d.fill(new RoundRectangle2D.Double(0.0, 0.0, w, h, 12.0, 12.0));
                g2d.setPaint(new GradientPaint(0.0f, 0.0f, new Color(255, 255, 255, 60), 0.0f, h / 2, new Color(255, 255, 255, 0)));
                g2d.fill(new RoundRectangle2D.Double(0.0, 0.0, w, h / 2, 12.0, 12.0));
                g2d.setColor(Color.WHITE);
                g2d.setFont(this.getFont());
                FontMetrics fm = g2d.getFontMetrics();
                String text = this.getText();
                int textX = (w - fm.stringWidth(text)) / 2;
                int textY = (h + fm.getAscent() - fm.getDescent()) / 2;
                g2d.drawString(text, textX, textY);
                g2d.dispose();
            }
        };
        yesBtn.setPreferredSize(new Dimension(140, 42));
        yesBtn.setFont(new Font("Segoe UI", 1, 13));
        yesBtn.addActionListener(e -> {
            this.confirmed = true;
            this.fadeOut();
        });
        buttonsPanel.add(yesBtn);
        mainPanel.add((Component)buttonsPanel, "South");
        this.setContentPane(mainPanel);
        this.getRootPane().registerKeyboardAction(e -> {
            this.confirmed = false;
            this.fadeOut();
        }, KeyStroke.getKeyStroke(27, 0), 2);
    }

    private void fadeOut() {
        Timer outTimer = new Timer(16, null);
        outTimer.addActionListener(e -> {
            this.fadeAlpha -= 0.12f;
            if (this.fadeAlpha <= 0.0f) {
                this.fadeAlpha = 0.0f;
                outTimer.stop();
                this.animTimer.stop();
                this.dispose();
            }
            this.setOpacity(Math.max(0.0f, this.fadeAlpha));
        });
        outTimer.start();
    }

    public boolean showDialog() {
        this.fadeTimer.start();
        this.setVisible(true);
        return this.confirmed;
    }

    public static boolean show(Frame owner, String serverName) {
        ServerOfflineDialog dialog = new ServerOfflineDialog(owner, serverName);
        return dialog.showDialog();
    }
}

