/*
 * Decompiled with CFR 0.152.
 */
package ru.minezone.launcher.gui.components;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Arc2D;
import java.awt.geom.RoundRectangle2D;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import ru.minezone.launcher.client.ClientProfile;
import ru.minezone.launcher.gui.Theme;

public class ServerCard
extends JPanel {
    private ClientProfile profile;
    private boolean selected = false;
    private boolean hovered = false;
    private float hoverAnim = 0.0f;
    private float selectAnim = 0.0f;
    private float pulsePhase = 0.0f;
    private float wavePhase = 0.0f;
    private Timer animationTimer;
    private ActionListener selectListener;
    private int displayedOnline = 0;
    private int targetOnline = 0;
    private int maxOnline = 100;
    private int modsCount = 0;
    private boolean serverOnline = true;
    private boolean checkingStatus = false;
    private String serverMotd = "";
    private int pingMs = -1;
    private float offlinePulse = 0.0f;
    private Timer statusTimer;
    private static final int STATUS_CHECK_INTERVAL = 30000;

    public ServerCard(ClientProfile profile) {
        this.profile = profile;
        this.targetOnline = profile.getOnline();
        this.countModsFromFolder();
        this.init();
        this.checkServerStatus();
        this.startStatusTimer();
    }

    private void countModsFromFolder() {
        File modsDir;
        File clientDir = this.profile.getClientDir();
        if (clientDir != null && clientDir.exists() && (modsDir = new File(clientDir, "mods")).exists()) {
            this.modsCount = this.countJars(modsDir);
        }
        if (this.modsCount == 0) {
            this.modsCount = this.profile.getModsCount();
        }
    }

    private int countJars(File dir) {
        int count = 0;
        File[] files = dir.listFiles();
        if (files == null) {
            return 0;
        }
        for (File f : files) {
            if (f.isDirectory()) {
                count += this.countJars(f);
                continue;
            }
            if (!f.getName().endsWith(".jar")) continue;
            ++count;
        }
        return count;
    }

    private void init() {
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(280, 150));
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.animationTimer = new Timer(16, e -> {
            float ts;
            float th;
            boolean repaint = false;
            float f = th = this.hovered ? 1.0f : 0.0f;
            if (Math.abs(this.hoverAnim - th) > 0.01f) {
                this.hoverAnim += (th - this.hoverAnim) * 0.15f;
                repaint = true;
            }
            float f2 = ts = this.selected ? 1.0f : 0.0f;
            if (Math.abs(this.selectAnim - ts) > 0.01f) {
                this.selectAnim += (ts - this.selectAnim) * 0.12f;
                repaint = true;
            }
            this.pulsePhase += 0.08f;
            this.wavePhase += 0.03f;
            if (!this.serverOnline) {
                this.offlinePulse += 0.05f;
            }
            if (this.displayedOnline != this.targetOnline) {
                int d = this.targetOnline - this.displayedOnline;
                this.displayedOnline += Math.max(1, Math.abs(d) / 5) * Integer.signum(d);
                repaint = true;
            }
            if (repaint || this.selected || this.hovered || !this.serverOnline) {
                this.repaint();
            }
        });
        this.animationTimer.start();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (ServerCard.this.isEnabled()) {
                    ServerCard.this.hovered = true;
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ServerCard.this.hovered = false;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (ServerCard.this.isEnabled() && ServerCard.this.selectListener != null) {
                    ServerCard.this.selectListener.actionPerformed(new ActionEvent(ServerCard.this, 0, "select"));
                }
            }
        });
    }

    private void startStatusTimer() {
        this.statusTimer = new Timer(30000, e -> this.checkServerStatus());
        this.statusTimer.start();
    }

    public void checkServerStatus() {
        if (this.checkingStatus) {
            return;
        }
        String serverIp = this.profile.getServerIp();
        int serverPort = this.profile.getServerPort();
        if (serverIp == null || serverIp.isEmpty()) {
            this.serverOnline = true;
            return;
        }
        this.checkingStatus = true;
        new Thread(() -> {
            try {
                ServerPingResult result = this.pingMinecraftServer(serverIp, serverPort);
                SwingUtilities.invokeLater(() -> {
                    this.serverOnline = result.online;
                    if (result.online) {
                        this.targetOnline = result.playersOnline;
                        this.maxOnline = result.playersMax;
                        this.serverMotd = result.motd;
                        this.pingMs = result.ping;
                    } else {
                        this.targetOnline = 0;
                        this.pingMs = -1;
                    }
                    this.checkingStatus = false;
                    this.repaint();
                });
            }
            catch (Exception e) {
                SwingUtilities.invokeLater(() -> {
                    this.serverOnline = false;
                    this.targetOnline = 0;
                    this.pingMs = -1;
                    this.checkingStatus = false;
                    this.repaint();
                });
            }
        }).start();
    }

    private ServerPingResult pingMinecraftServer(String host, int port) {
        ServerPingResult result = new ServerPingResult();
        long startTime = System.currentTimeMillis();
        try (Socket socket = new Socket();){
            socket.connect(new InetSocketAddress(host, port), 3000);
            result.ping = (int)(System.currentTimeMillis() - startTime);
            result.online = true;
            try {
                int packetId;
                DataOutputStream out = new DataOutputStream(socket.getOutputStream());
                DataInputStream in = new DataInputStream(socket.getInputStream());
                ByteArrayOutputStream handshake = new ByteArrayOutputStream();
                DataOutputStream handshakeOut = new DataOutputStream(handshake);
                this.writeVarInt(handshakeOut, 0);
                this.writeVarInt(handshakeOut, 4);
                this.writeString(handshakeOut, host);
                handshakeOut.writeShort(port);
                this.writeVarInt(handshakeOut, 1);
                byte[] handshakeData = handshake.toByteArray();
                this.writeVarInt(out, handshakeData.length);
                out.write(handshakeData);
                this.writeVarInt(out, 1);
                this.writeVarInt(out, 0);
                out.flush();
                int length = this.readVarInt(in);
                if (length > 0 && (packetId = this.readVarInt(in)) == 0) {
                    String json = this.readString(in);
                    this.parseServerResponse(json, result);
                }
            }
            catch (Exception e) {
                result.playersOnline = this.profile.getOnline();
                result.playersMax = 100;
            }
        }
        catch (Exception e) {
            result.online = false;
        }
        return result;
    }

    private void parseServerResponse(String json, ServerPingResult result) {
        try {
            String value;
            int end;
            int start;
            int idx;
            if (json.contains("\"online\"")) {
                idx = json.indexOf("\"online\"");
                start = json.indexOf(":", idx) + 1;
                end = json.indexOf(",", start);
                if (end == -1) {
                    end = json.indexOf("}", start);
                }
                value = json.substring(start, end).trim();
                result.playersOnline = Integer.parseInt(value);
            }
            if (json.contains("\"max\"")) {
                idx = json.indexOf("\"max\"");
                start = json.indexOf(":", idx) + 1;
                end = json.indexOf(",", start);
                if (end == -1) {
                    end = json.indexOf("}", start);
                }
                value = json.substring(start, end).trim();
                result.playersMax = Integer.parseInt(value);
            }
            if (json.contains("\"text\"")) {
                idx = json.indexOf("\"text\"");
                start = json.indexOf("\"", idx + 7) + 1;
                end = json.indexOf("\"", start);
                result.motd = json.substring(start, end);
            } else if (json.contains("\"description\"") && json.charAt(json.indexOf(":", idx = json.indexOf("\"description\"")) + 1) == '\"') {
                start = json.indexOf("\"", idx + 14) + 1;
                end = json.indexOf("\"", start);
                result.motd = json.substring(start, end);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void writeVarInt(DataOutputStream out, int value) throws IOException {
        while ((value & 0xFFFFFF80) != 0) {
            out.writeByte(value & 0x7F | 0x80);
            value >>>= 7;
        }
        out.writeByte(value);
    }

    private int readVarInt(DataInputStream in) throws IOException {
        int value;
        block1: {
            value = 0;
            int position = 0;
            do {
                byte currentByte = in.readByte();
                value |= (currentByte & 0x7F) << position;
                if ((currentByte & 0x80) == 0) break block1;
            } while ((position += 7) < 32);
            throw new RuntimeException("VarInt too big");
        }
        return value;
    }

    private void writeString(DataOutputStream out, String s) throws IOException {
        byte[] bytes = s.getBytes("UTF-8");
        this.writeVarInt(out, bytes.length);
        out.write(bytes);
    }

    private String readString(DataInputStream in) throws IOException {
        int length = this.readVarInt(in);
        byte[] bytes = new byte[length];
        in.readFully(bytes);
        return new String(bytes, "UTF-8");
    }

    @Override
    protected void paintComponent(Graphics g) {
        Color bg;
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int w = this.getWidth();
        int h = this.getHeight();
        int r = 16;
        float glow = Math.max(this.hoverAnim, this.selectAnim);
        if (glow > 0.0f) {
            Color glowColor = this.serverOnline ? new Color(56, 189, 248) : new Color(248, 56, 56);
            for (int i = 10; i > 0; --i) {
                g2d.setColor(new Color(glowColor.getRed(), glowColor.getGreen(), glowColor.getBlue(), (int)((0.05f - (float)i * 0.004f) * glow * 255.0f)));
                g2d.fill(new RoundRectangle2D.Double(-i, -i + 2, w + i * 2, h + i * 2, r + i, r + i));
            }
        }
        Color color = bg = this.serverOnline ? this.interpolate(new Color(30, 38, 52), new Color(38, 48, 65), glow) : this.interpolate(new Color(35, 28, 28), new Color(45, 35, 35), glow);
        if (!this.isEnabled()) {
            bg = new Color(bg.getRed() / 2, bg.getGreen() / 2, bg.getBlue() / 2);
        }
        g2d.setPaint(new GradientPaint(0.0f, 0.0f, bg, 0.0f, h, this.darker(bg, 0.88f)));
        g2d.fill(new RoundRectangle2D.Double(0.0, 0.0, w, h, r, r));
        g2d.setPaint(new GradientPaint(0.0f, 0.0f, new Color(255, 255, 255, (int)(18.0f + 12.0f * this.hoverAnim)), 0.0f, 50.0f, new Color(255, 255, 255, 0)));
        g2d.fill(new RoundRectangle2D.Double(0.0, 0.0, w, 50.0, r, r));
        if (this.selectAnim > 0.0f && this.serverOnline) {
            g2d.setClip(new RoundRectangle2D.Double(0.0, 0.0, w, h, r, r));
            g2d.setColor(new Color(56, 189, 248, (int)(25.0f * this.selectAnim)));
            int[] xp = new int[w + 2];
            int[] yp = new int[w + 2];
            xp[0] = 0;
            yp[0] = h;
            for (int i = 0; i < w; ++i) {
                xp[i + 1] = i;
                yp[i + 1] = h - 15 + (int)(Math.sin((double)this.wavePhase + (double)i * 0.03) * 6.0);
            }
            xp[w + 1] = w;
            yp[w + 1] = h;
            g2d.fillPolygon(xp, yp, w + 2);
            g2d.setClip(null);
        }
        float ba = 0.25f + this.selectAnim * 0.5f + this.hoverAnim * 0.2f;
        Color borderStart = this.serverOnline ? new Color(56, 189, 248) : new Color(248, 86, 86);
        Color borderEnd = this.serverOnline ? new Color(139, 92, 246) : new Color(180, 60, 60);
        g2d.setPaint(new GradientPaint(0.0f, 0.0f, new Color(borderStart.getRed(), borderStart.getGreen(), borderStart.getBlue(), (int)(ba * 255.0f)), w, h, new Color(borderEnd.getRed(), borderEnd.getGreen(), borderEnd.getBlue(), (int)(ba * 180.0f))));
        g2d.setStroke(new BasicStroke(this.selected ? 2.5f : 1.5f));
        g2d.draw(new RoundRectangle2D.Double(1.0, 1.0, w - 2, h - 2, r, r));
        if (this.selectAnim > 0.0f || this.hoverAnim > 0.0f) {
            float lw = (float)w * 0.65f * Math.max(this.selectAnim, this.hoverAnim * 0.5f);
            g2d.setPaint(new GradientPaint(((float)w - lw) / 2.0f, 0.0f, borderStart, ((float)w + lw) / 2.0f, 0.0f, borderEnd));
            g2d.fill(new RoundRectangle2D.Double(((float)w - lw) / 2.0f, 0.0, lw, 3.0, 3.0, 3.0));
        }
        this.drawIcon(g2d, 16, 16, 40);
        g2d.setFont(new Font("Segoe UI", 1, 18));
        g2d.setColor(this.isEnabled() ? Theme.TEXT_PRIMARY : Theme.TEXT_DISABLED);
        g2d.drawString(this.profile.getTitle(), 66, 38);
        String ver = "MC " + this.profile.getVersion();
        g2d.setFont(new Font("Segoe UI", 1, 10));
        int vw = g2d.getFontMetrics().stringWidth(ver) + 12;
        g2d.setPaint(new GradientPaint(66.0f, 48.0f, new Color(56, 189, 248, 35), 66 + vw, 48.0f, new Color(139, 92, 246, 35)));
        g2d.fillRoundRect(66, 48, vw, 16, 8, 8);
        g2d.setColor(Theme.ACCENT_PRIMARY);
        g2d.drawString(ver, 72, 60);
        g2d.setFont(Theme.FONT_SMALL);
        g2d.setColor(this.isEnabled() ? Theme.TEXT_SECONDARY : Theme.TEXT_DISABLED);
        String desc = this.profile.getDescription();
        if (desc.length() > 36) {
            desc = desc.substring(0, 33) + "...";
        }
        g2d.drawString(desc, 16, 85);
        int sy = 100;
        g2d.setColor(new Color(255, 255, 255, 12));
        g2d.drawLine(12, sy, w - 12, sy);
        int cx = 32;
        int cy = (sy += 16) + 10;
        int cr = 16;
        g2d.setColor(new Color(20, 25, 35));
        g2d.fillOval(cx - cr, cy - cr, cr * 2, cr * 2);
        int maxO = Math.max(100, this.maxOnline);
        float pct = this.serverOnline ? Math.min(1.0f, (float)this.displayedOnline / (float)maxO) : 0.0f;
        g2d.setStroke(new BasicStroke(3.0f, 1, 1));
        g2d.setColor(new Color(40, 50, 65));
        g2d.drawOval(cx - cr + 3, cy - cr + 3, (cr - 3) * 2, (cr - 3) * 2);
        if (this.serverOnline) {
            g2d.setPaint(new GradientPaint(cx - cr, cy, Theme.ACCENT_SECONDARY, cx + cr, cy, Theme.ACCENT_PRIMARY));
        } else {
            g2d.setPaint(new GradientPaint(cx - cr, cy, new Color(180, 60, 60), cx + cr, cy, new Color(248, 86, 86)));
        }
        g2d.draw(new Arc2D.Double(cx - cr + 3, cy - cr + 3, (cr - 3) * 2, (cr - 3) * 2, 90.0, -360.0f * pct, 0));
        g2d.setFont(new Font("Segoe UI", 1, 11));
        String os = this.serverOnline ? String.valueOf(this.displayedOnline) : "\u2014";
        FontMetrics fm = g2d.getFontMetrics();
        g2d.setColor(Theme.TEXT_PRIMARY);
        g2d.drawString(os, cx - fm.stringWidth(os) / 2, cy + 4);
        float pulse = (float)(Math.sin(this.serverOnline ? (double)this.pulsePhase : (double)this.offlinePulse) * 0.4 + 0.6);
        int is = (int)(5.0f + pulse * 3.0f);
        Color statusColor = this.serverOnline ? Theme.ONLINE : new Color(248, 86, 86);
        g2d.setColor(new Color(statusColor.getRed(), statusColor.getGreen(), statusColor.getBlue(), (int)(70.0f * pulse)));
        g2d.fillOval(cx + cr - 3 - is / 2, cy - cr + 3 - is / 2, is, is);
        g2d.setColor(statusColor);
        g2d.fillOval(cx + cr - 3, cy - cr + 3, 4, 4);
        g2d.setFont(new Font("Segoe UI", 0, 9));
        g2d.setColor(this.serverOnline ? Theme.TEXT_SECONDARY : new Color(248, 120, 120));
        g2d.drawString(this.serverOnline ? "\u043e\u043d\u043b\u0430\u0439\u043d" : "\u043e\u0444\u0444\u043b\u0430\u0439\u043d", cx - 12, cy + cr + 9);
        if (this.serverOnline && this.pingMs > 0) {
            g2d.setFont(new Font("Segoe UI", 0, 9));
            g2d.setColor(this.pingMs < 100 ? Theme.ONLINE : (this.pingMs < 200 ? new Color(255, 200, 50) : new Color(248, 86, 86)));
            g2d.drawString(this.pingMs + "ms", cx + cr + 8, cy - 5);
        }
        String mt = this.modsCount + " \u043c\u043e\u0434\u043e\u0432";
        g2d.setFont(new Font("Segoe UI", 1, 12));
        int mtw = g2d.getFontMetrics().stringWidth(mt);
        int mx = w - mtw - 18;
        g2d.setColor(Theme.TEXT_PRIMARY);
        g2d.drawString(mt, mx, sy + 12);
        g2d.setColor(Theme.ACCENT_SECONDARY);
        g2d.setStroke(new BasicStroke(1.5f));
        int px = mx - 18;
        int py = sy + 3;
        g2d.drawRoundRect(px, py, 11, 11, 3, 3);
        g2d.drawLine(px + 5, py - 2, px + 5, py + 2);
        g2d.drawLine(px + 11, py + 5, px + 14, py + 5);
        g2d.setFont(new Font("Segoe UI", 0, 9));
        g2d.setColor(Theme.TEXT_SECONDARY);
        g2d.drawString("\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e", mx - 3, sy + 25);
        if (this.selectAnim > 0.0f) {
            int chx = w - 34;
            int chy = 12;
            int chs = 24;
            g2d.setColor(new Color(56, 189, 248, (int)(this.selectAnim * 255.0f)));
            g2d.fillOval(chx, chy, chs, chs);
            g2d.setColor(Color.WHITE);
            g2d.setStroke(new BasicStroke(2.5f, 1, 1));
            int ccx = chx + chs / 2;
            int ccy = chy + chs / 2;
            float cp = Math.min(1.0f, this.selectAnim * 1.8f);
            if (cp > 0.0f) {
                int x1 = ccx - 5;
                int y1 = ccy;
                int x2 = ccx - 1;
                int y2 = ccy + 4;
                int x3 = ccx + 6;
                int y3 = ccy - 4;
                if (cp < 0.5f) {
                    float t = cp * 2.0f;
                    g2d.drawLine(x1, y1, (int)((float)x1 + (float)(x2 - x1) * t), (int)((float)y1 + (float)(y2 - y1) * t));
                } else {
                    g2d.drawLine(x1, y1, x2, y2);
                    float t = (cp - 0.5f) * 2.0f;
                    g2d.drawLine(x2, y2, (int)((float)x2 + (float)(x3 - x2) * t), (int)((float)y2 + (float)(y3 - y2) * t));
                }
            }
        }
        g2d.dispose();
    }

    private void drawIcon(Graphics2D g2d, int x, int y, int size) {
        String t = this.profile.getTitle().toLowerCase();
        g2d.setStroke(new BasicStroke(2.5f, 1, 1));
        Color ic = this.serverOnline ? this.interpolate(Theme.ACCENT_SECONDARY, Theme.ACCENT_PRIMARY, this.selectAnim) : new Color(180, 80, 80);
        int cx = x + size / 2;
        int cy = y + size / 2;
        int rr = size / 2 - 5;
        if (this.selectAnim > 0.0f || this.hoverAnim > 0.0f) {
            g2d.setColor(new Color(ic.getRed(), ic.getGreen(), ic.getBlue(), (int)(30.0f * Math.max(this.selectAnim, this.hoverAnim))));
            g2d.fillOval(cx - rr - 5, cy - rr - 5, (rr + 5) * 2, (rr + 5) * 2);
        }
        g2d.setColor(ic);
        if (t.contains("hitech") || t.contains("tech") || t.contains("industrial")) {
            int[] xp = new int[]{cx, cx + 5, cx + 1, cx + 6, cx - 5, cx, cx - 6};
            int[] yp = new int[]{cy - rr, cy - 2, cy - 2, cy + rr, cy + 2, cy + 2, cy - rr};
            g2d.fillPolygon(xp, yp, 7);
        } else if (t.contains("magic") || t.contains("\u043c\u0430\u0433") || t.contains("thaumcraft")) {
            for (int i = 0; i < 5; ++i) {
                double a = 1.5707963267948966 + 1.2566370614359172 * (double)i;
                double a2 = a + 0.6283185307179586;
                g2d.drawLine(cx, cy, cx + (int)(Math.cos(a) * (double)rr), cy - (int)(Math.sin(a) * (double)rr));
                g2d.drawLine(cx + (int)(Math.cos(a) * (double)rr), cy - (int)(Math.sin(a) * (double)rr), cx + (int)(Math.cos(a2) * (double)rr * 0.4), cy - (int)(Math.sin(a2) * (double)rr * 0.4));
            }
            g2d.fillOval(cx - 3, cy - 3, 6, 6);
        } else {
            g2d.drawRect(cx - rr + 4, cy - rr + 4, (rr - 4) * 2, (rr - 4) * 2);
            g2d.drawLine(cx - rr + 4, cy, cx + rr - 4, cy);
            g2d.drawLine(cx, cy - rr + 4, cx, cy + rr - 4);
            g2d.fillOval(cx - 3, cy - 3, 6, 6);
        }
    }

    private Color interpolate(Color a, Color b, float t) {
        return new Color((int)((float)a.getRed() + (float)(b.getRed() - a.getRed()) * t), (int)((float)a.getGreen() + (float)(b.getGreen() - a.getGreen()) * t), (int)((float)a.getBlue() + (float)(b.getBlue() - a.getBlue()) * t));
    }

    private Color darker(Color c, float f) {
        return new Color((int)((float)c.getRed() * f), (int)((float)c.getGreen() * f), (int)((float)c.getBlue() * f), c.getAlpha());
    }

    public void setSelected(boolean s) {
        this.selected = s;
    }

    public void updateOnline(int o) {
        this.targetOnline = o;
        this.profile.setOnline(o);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public ClientProfile getProfile() {
        return this.profile;
    }

    public void addSelectListener(ActionListener l) {
        this.selectListener = l;
    }

    @Override
    public void setEnabled(boolean e) {
        super.setEnabled(e);
        this.setCursor(e ? Cursor.getPredefinedCursor(12) : Cursor.getDefaultCursor());
        this.repaint();
    }

    public void refreshModsCount() {
        this.countModsFromFolder();
        this.repaint();
    }

    public boolean isServerOnline() {
        return this.serverOnline;
    }

    public int getPing() {
        return this.pingMs;
    }

    public void dispose() {
        if (this.animationTimer != null) {
            this.animationTimer.stop();
        }
        if (this.statusTimer != null) {
            this.statusTimer.stop();
        }
    }

    private static class ServerPingResult {
        boolean online = false;
        int playersOnline = 0;
        int playersMax = 100;
        String motd = "";
        int ping = -1;

        private ServerPingResult() {
        }
    }
}

