/*
 * Decompiled with CFR 0.152.
 */
package ru.minezone.launcher.gui.components;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Arc2D;
import java.net.URI;
import javax.swing.JPanel;
import javax.swing.Timer;
import ru.minezone.launcher.utils.LogHelper;

public class RadialMenuButton
extends JPanel {
    private static final String URL_LK = "https://minezone.su/cabinet/";
    private static final String URL_SHOP = "https://minezone.su/shop/";
    private static final String URL_FORUM = "https://minezone.su/forum/";
    private static final String URL_VK = "https://vk.com/minezonesu";
    private static final String[] ITEM_NAMES = new String[]{"\u041b\u041a", "\u041c\u0430\u0433\u0430\u0437\u0438\u043d", "\u0424\u043e\u0440\u0443\u043c", "VK"};
    private static final String[] ITEM_URLS = new String[]{"https://minezone.su/cabinet/", "https://minezone.su/shop/", "https://minezone.su/forum/", "https://vk.com/minezonesu"};
    private static final String[] ITEM_TOOLTIPS = new String[]{"\u041b\u0438\u0447\u043d\u044b\u0439 \u043a\u0430\u0431\u0438\u043d\u0435\u0442", "\u041c\u0430\u0433\u0430\u0437\u0438\u043d", "\u0424\u043e\u0440\u0443\u043c", "\u041d\u0430\u0448\u0430 \u0433\u0440\u0443\u043f\u043f\u0430"};
    private static final Color[] ITEM_COLORS = new Color[]{new Color(56, 189, 248), new Color(139, 92, 246), new Color(52, 211, 153), new Color(77, 133, 209)};
    private volatile boolean expanded = false;
    private volatile boolean hovered = false;
    private volatile int hoveredItem = -1;
    private float expandProgress = 0.0f;
    private float pulsePhase = 0.0f;
    private float glowPhase = 0.0f;
    private float[] itemScale = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    private static final int BUTTON_SIZE = 46;
    private static final int MENU_RADIUS = 65;
    private static final int ITEM_SIZE = 36;
    private Timer animTimer;

    public RadialMenuButton() {
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(220, 130));
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.animTimer = new Timer(20, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RadialMenuButton.this.updateAnimation();
                RadialMenuButton.this.repaint();
            }
        });
        this.animTimer.start();
        MouseAdapter mouseHandler = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                RadialMenuButton.this.hovered = true;
                RadialMenuButton.this.expanded = true;
            }

            @Override
            public void mouseExited(MouseEvent e) {
                RadialMenuButton.this.hovered = false;
                RadialMenuButton.this.expanded = false;
                RadialMenuButton.this.hoveredItem = -1;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (RadialMenuButton.this.hoveredItem >= 0 && RadialMenuButton.this.hoveredItem < ITEM_URLS.length) {
                    RadialMenuButton.this.openUrl(ITEM_URLS[RadialMenuButton.this.hoveredItem]);
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                RadialMenuButton.this.checkHoveredItem(e.getX(), e.getY());
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                RadialMenuButton.this.checkHoveredItem(e.getX(), e.getY());
            }
        };
        this.addMouseListener(mouseHandler);
        this.addMouseMotionListener(mouseHandler);
    }

    private void updateAnimation() {
        this.pulsePhase += 0.06f;
        this.glowPhase += 0.04f;
        float target = this.expanded ? 1.0f : 0.0f;
        this.expandProgress += (target - this.expandProgress) * 0.15f;
        for (int i = 0; i < 4; ++i) {
            float itemTarget = this.expanded ? 1.0f : 0.0f;
            float delay = (float)i * 0.15f;
            if (this.expanded && this.expandProgress > delay) {
                int n = i;
                this.itemScale[n] = this.itemScale[n] + (1.0f - this.itemScale[i]) * 0.2f;
                continue;
            }
            if (this.expanded) continue;
            int n = i;
            this.itemScale[n] = this.itemScale[n] + (0.0f - this.itemScale[i]) * 0.2f;
        }
    }

    private void checkHoveredItem(int mx, int my) {
        int cx = this.getWidth() / 2;
        int cy = this.getHeight() - 23 - 5;
        this.hoveredItem = -1;
        if (this.expandProgress > 0.5f) {
            for (int i = 0; i < 4; ++i) {
                Point p = this.getItemPos(i, cx, cy);
                double dist = Math.sqrt(Math.pow(mx - p.x, 2.0) + Math.pow(my - p.y, 2.0));
                if (!(dist < 23.0)) continue;
                this.hoveredItem = i;
                break;
            }
        }
    }

    private Point getItemPos(int index, int cx, int cy) {
        double[] angles = new double[]{2.670353755551324, 1.9477874452256718, 1.1938052083641213, 0.47123889803846897};
        double angle = angles[index];
        float r = 65.0f * this.itemScale[index];
        int x = cx + (int)(Math.cos(angle) * (double)r);
        int y = cy - (int)(Math.sin(angle) * (double)r);
        return new Point(x, y);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int cx = this.getWidth() / 2;
        int cy = this.getHeight() - 23 - 5;
        if (this.expandProgress > 0.1f) {
            for (int i = 0; i < 4; ++i) {
                if (!(this.itemScale[i] > 0.05f)) continue;
                this.drawMenuItem(g2, i, cx, cy);
            }
        }
        this.drawCenterButton(g2, cx, cy);
        g2.dispose();
    }

    private void drawCenterButton(Graphics2D g2, int cx, int cy) {
        float pulse = (float)(Math.sin(this.pulsePhase) * 0.3 + 0.7);
        float glow = (float)(Math.sin((double)this.glowPhase * 1.5) * 0.5 + 0.5);
        for (int i = 12; i > 0; --i) {
            int alpha = (int)(pulse * (float)(12 - i) * 2.0f);
            g2.setColor(new Color(56, 189, 248, alpha));
            int s = 46 + i * 3;
            g2.fillOval(cx - s / 2, cy - s / 2, s, s);
        }
        GradientPaint gp = new GradientPaint(cx - 23, cy - 23, new Color(56, 189, 248), cx + 23, cy + 23, new Color(139, 92, 246));
        g2.setPaint(gp);
        g2.fillOval(cx - 23, cy - 23, 46, 46);
        g2.setPaint(new GradientPaint(cx, cy - 23, new Color(255, 255, 255, 70), cx, cy, new Color(255, 255, 255, 0)));
        g2.fillOval(cx - 23 + 3, cy - 23 + 3, 40, 23);
        g2.setColor(Color.WHITE);
        g2.setStroke(new BasicStroke(2.5f, 1, 1));
        if (this.expandProgress < 0.5f) {
            g2.drawLine(cx - 7, cy - 5, cx + 7, cy - 5);
            g2.drawLine(cx - 7, cy, cx + 7, cy);
            g2.drawLine(cx - 7, cy + 5, cx + 7, cy + 5);
        } else {
            float t = (this.expandProgress - 0.5f) * 2.0f;
            int o = (int)(7.0f * t);
            g2.drawLine(cx - o, cy - o, cx + o, cy + o);
            g2.drawLine(cx - o, cy + o, cx + o, cy - o);
        }
        g2.setStroke(new BasicStroke(2.0f));
        g2.setColor(new Color(255, 255, 255, (int)(80.0f + 50.0f * glow)));
        double arc = this.glowPhase * 50.0f;
        g2.draw(new Arc2D.Double(cx - 23 - 4, cy - 23 - 4, 54.0, 54.0, arc, 80.0, 0));
        g2.draw(new Arc2D.Double(cx - 23 - 4, cy - 23 - 4, 54.0, 54.0, arc + 180.0, 80.0, 0));
    }

    private void drawMenuItem(Graphics2D g2, int index, int cx, int cy) {
        Point pos = this.getItemPos(index, cx, cy);
        float scale = this.itemScale[index];
        boolean isHovered = this.hoveredItem == index;
        int size = (int)(36.0f * scale * (isHovered ? 1.15f : 1.0f));
        if (size < 5) {
            return;
        }
        Color color = ITEM_COLORS[index];
        if (isHovered) {
            for (int i = 8; i > 0; --i) {
                g2.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), (8 - i) * 4));
                int gs = size + i * 3;
                g2.fillOval(pos.x - gs / 2, pos.y - gs / 2, gs, gs);
            }
        }
        Color bg = isHovered ? color : new Color(40, 50, 65);
        g2.setColor(bg);
        g2.fillOval(pos.x - size / 2, pos.y - size / 2, size, size);
        g2.setColor(color);
        g2.setStroke(new BasicStroke(2.0f));
        g2.drawOval(pos.x - size / 2, pos.y - size / 2, size, size);
        g2.setColor(Color.WHITE);
        g2.setFont(new Font("Segoe UI", 1, isHovered ? 11 : 10));
        FontMetrics fm = g2.getFontMetrics();
        String text = ITEM_NAMES[index];
        g2.drawString(text, pos.x - fm.stringWidth(text) / 2, pos.y + fm.getAscent() / 2 - 2);
        if (isHovered && scale > 0.8f) {
            g2.setFont(new Font("Segoe UI", 0, 9));
            g2.setColor(new Color(200, 200, 200));
            fm = g2.getFontMetrics();
            String tip = ITEM_TOOLTIPS[index];
            g2.drawString(tip, pos.x - fm.stringWidth(tip) / 2, pos.y + size / 2 + 12);
        }
    }

    private void openUrl(String url) {
        try {
            Desktop.getDesktop().browse(new URI(url));
        }
        catch (Exception e) {
            LogHelper.error("Failed to open URL: " + url, e);
        }
    }

    public void dispose() {
        if (this.animTimer != null) {
            this.animTimer.stop();
        }
    }
}

