/*
 * Decompiled with CFR 0.152.
 */
package ru.minezone.launcher.gui.components;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.Timer;
import javax.swing.plaf.basic.BasicScrollBarUI;
import ru.minezone.launcher.gui.Theme;
import ru.minezone.launcher.gui.components.ModernButton;
import ru.minezone.launcher.utils.LogHelper;

public class ModsDialog
extends JDialog {
    private List<ModEntry> mods = new ArrayList<ModEntry>();
    private Map<String, Boolean> modStates = new HashMap<String, Boolean>();
    private boolean confirmed = false;
    private JPanel modsListPanel;
    private float fadeAlpha = 0.0f;
    private Timer fadeTimer;
    private static final Map<String, String> CATEGORIES = new LinkedHashMap<String, String>();
    private static final Map<String, ModInfo> KNOWN_MODS;
    private static final Map<String, String[]> MOD_GROUPS;

    public ModsDialog(Frame owner, File modsDir) {
        super(owner, "\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430 \u043c\u043e\u0434\u043e\u0432", true);
        this.scanMods(modsDir);
        this.initUI();
        this.setOpacity(0.0f);
        this.fadeTimer = new Timer(16, e -> {
            this.fadeAlpha += 0.08f;
            if (this.fadeAlpha >= 1.0f) {
                this.fadeAlpha = 1.0f;
                this.fadeTimer.stop();
            }
            this.setOpacity(this.fadeAlpha);
        });
    }

    private void scanMods(File modsDir) {
        File[] mainMods;
        File[] files;
        if (!modsDir.exists()) {
            return;
        }
        File optionalDir = new File(modsDir, "optional");
        if (optionalDir.exists() && (files = optionalDir.listFiles((dir, name) -> name.endsWith(".jar") || name.endsWith(".jar.disabled"))) != null) {
            for (File file : files) {
                this.addMod(file, true);
            }
        }
        if ((mainMods = modsDir.listFiles((dir, name) -> name.endsWith(".jar") || name.endsWith(".jar.disabled"))) != null) {
            for (File file : mainMods) {
                String lower = file.getName().toLowerCase();
                if (!this.isSmartMovingRelated(lower) && !this.isOptionalMod(file.getName())) continue;
                this.addMod(file, false);
            }
        }
    }

    private boolean isSmartMovingRelated(String filename) {
        String lower = filename.toLowerCase();
        return lower.contains("smartmoving") || lower.contains("smart-moving") || lower.contains("smartrender") || lower.contains("smart-render") || lower.contains("smartcore") || lower.contains("smart-core") || lower.contains("playerapi") || lower.contains("player-api") || lower.contains("renderplayerapi") || lower.contains("render-player-api");
    }

    private boolean isOptionalMod(String filename) {
        String lower = filename.toLowerCase();
        for (String key : KNOWN_MODS.keySet()) {
            if (!lower.contains(key)) continue;
            ModInfo info = KNOWN_MODS.get(key);
            return info.category.equals("visual") || info.category.equals("util");
        }
        return false;
    }

    private void addMod(File file, boolean isOptional) {
        String name = file.getName();
        boolean enabled = !name.endsWith(".disabled");
        String cleanName = name.replace(".disabled", "").replace(".jar", "");
        ModEntry entry = new ModEntry();
        entry.file = file;
        entry.fileName = cleanName;
        entry.enabled = enabled;
        entry.isOptional = isOptional;
        String lower = cleanName.toLowerCase();
        for (Map.Entry<String, ModInfo> known : KNOWN_MODS.entrySet()) {
            if (!lower.contains(known.getKey())) continue;
            entry.info = known.getValue();
            break;
        }
        if (entry.info == null) {
            entry.info = new ModInfo(cleanName, "\u041e\u043f\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u044b\u0439 \u043c\u043e\u0434", "other", enabled);
        }
        this.mods.add(entry);
        this.modStates.put(entry.fileName, enabled);
    }

    private void initUI() {
        this.setUndecorated(true);
        this.setSize(550, 600);
        this.setLocationRelativeTo(this.getOwner());
        this.setBackground(new Color(0, 0, 0, 0));
        JPanel mainPanel = new JPanel(new BorderLayout()){

            @Override
            protected void paintComponent(Graphics g) {
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                for (int i = 0; i < 10; ++i) {
                    g2d.setColor(new Color(0, 0, 0, 20 - i * 2));
                    g2d.fill(new RoundRectangle2D.Double(i, i, this.getWidth() - i * 2, this.getHeight() - i * 2, 25.0, 25.0));
                }
                GradientPaint bg = new GradientPaint(0.0f, 0.0f, new Color(25, 32, 45), 0.0f, this.getHeight(), new Color(15, 20, 30));
                g2d.setPaint(bg);
                g2d.fill(new RoundRectangle2D.Double(5.0, 5.0, this.getWidth() - 10, this.getHeight() - 10, 20.0, 20.0));
                GradientPaint border = new GradientPaint(0.0f, 0.0f, Theme.ACCENT_PRIMARY, this.getWidth(), this.getHeight(), Theme.ACCENT_SECONDARY);
                g2d.setPaint(border);
                g2d.setStroke(new BasicStroke(2.0f));
                g2d.draw(new RoundRectangle2D.Double(5.0, 5.0, this.getWidth() - 10, this.getHeight() - 10, 20.0, 20.0));
                g2d.dispose();
            }
        };
        mainPanel.setOpaque(false);
        mainPanel.setBorder(BorderFactory.createEmptyBorder(20, 25, 20, 25));
        JPanel headerPanel = this.createHeaderPanel();
        mainPanel.add((Component)headerPanel, "North");
        this.modsListPanel = new JPanel();
        this.modsListPanel.setOpaque(false);
        this.modsListPanel.setLayout(new BoxLayout(this.modsListPanel, 1));
        this.populateModsList();
        JScrollPane scrollPane = new JScrollPane(this.modsListPanel);
        scrollPane.setOpaque(false);
        scrollPane.getViewport().setOpaque(false);
        scrollPane.setBorder(null);
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.getVerticalScrollBar().setUnitIncrement(16);
        scrollPane.getVerticalScrollBar().setUI(new ModernScrollBarUI());
        mainPanel.add((Component)scrollPane, "Center");
        JPanel buttonsPanel = this.createButtonsPanel();
        mainPanel.add((Component)buttonsPanel, "South");
        this.setContentPane(mainPanel);
    }

    private JPanel createHeaderPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(false);
        panel.setBorder(BorderFactory.createEmptyBorder(0, 0, 20, 0));
        JPanel titlePanel = new JPanel(new FlowLayout(0, 10, 0));
        titlePanel.setOpaque(false);
        JLabel icon = new JLabel(){
            private double rotation = 0.0;
            private Timer rotTimer = new Timer(50, e -> {
                this.rotation += 2.0;
                this.repaint();
            });
            {
                this.rotTimer.start();
                this.setPreferredSize(new Dimension(36, 36));
            }

            @Override
            protected void paintComponent(Graphics g) {
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                int cx = this.getWidth() / 2;
                int cy = this.getHeight() / 2;
                g2d.translate(cx, cy);
                g2d.rotate(Math.toRadians(this.rotation));
                g2d.setColor(Theme.ACCENT_PRIMARY);
                g2d.setStroke(new BasicStroke(2.5f));
                for (int i = 0; i < 8; ++i) {
                    double angle = 0.7853981633974483 * (double)i;
                    int r1 = 10;
                    int r2 = 14;
                    g2d.drawLine((int)(Math.cos(angle) * (double)r1), (int)(Math.sin(angle) * (double)r1), (int)(Math.cos(angle) * (double)r2), (int)(Math.sin(angle) * (double)r2));
                }
                g2d.drawOval(-8, -8, 16, 16);
                g2d.fillOval(-3, -3, 6, 6);
                g2d.dispose();
            }
        };
        titlePanel.add(icon);
        JLabel title = new JLabel("\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430 \u043c\u043e\u0434\u043e\u0432");
        title.setFont(new Font("Segoe UI", 1, 22));
        title.setForeground(Theme.TEXT_PRIMARY);
        titlePanel.add(title);
        panel.add((Component)titlePanel, "West");
        JButton closeBtn = new JButton(){
            private boolean hover = false;
            {
                this.setPreferredSize(new Dimension(32, 32));
                this.setContentAreaFilled(false);
                this.setBorderPainted(false);
                this.setCursor(Cursor.getPredefinedCursor(12));
                this.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        hover = true;
                        this.repaint();
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        hover = false;
                        this.repaint();
                    }
                });
            }

            @Override
            protected void paintComponent(Graphics g) {
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                if (this.hover) {
                    g2d.setColor(new Color(255, 100, 100, 50));
                    g2d.fillOval(2, 2, this.getWidth() - 4, this.getHeight() - 4);
                }
                g2d.setColor(this.hover ? Theme.ERROR : Theme.TEXT_SECONDARY);
                g2d.setStroke(new BasicStroke(2.0f, 1, 1));
                int cx = this.getWidth() / 2;
                int cy = this.getHeight() / 2;
                g2d.drawLine(cx - 5, cy - 5, cx + 5, cy + 5);
                g2d.drawLine(cx + 5, cy - 5, cx - 5, cy + 5);
                g2d.dispose();
            }
        };
        closeBtn.addActionListener(e -> this.fadeOut());
        panel.add((Component)closeBtn, "East");
        JLabel hint = new JLabel("\u0412\u043a\u043b\u044e\u0447\u0438\u0442\u0435 \u0438\u043b\u0438 \u043e\u0442\u043a\u043b\u044e\u0447\u0438\u0442\u0435 \u043e\u043f\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u044b\u0435 \u043c\u043e\u0434\u044b");
        hint.setFont(Theme.FONT_SMALL);
        hint.setForeground(Theme.TEXT_SECONDARY);
        hint.setBorder(BorderFactory.createEmptyBorder(10, 46, 0, 0));
        panel.add((Component)hint, "South");
        return panel;
    }

    private void populateModsList() {
        this.modsListPanel.removeAll();
        LinkedHashMap byCategory = new LinkedHashMap();
        for (String string : CATEGORIES.keySet()) {
            byCategory.put(string, new ArrayList());
        }
        for (ModEntry modEntry : this.mods) {
            String cat;
            if (modEntry.info != null && modEntry.info.hidden) continue;
            String string = cat = modEntry.info != null ? modEntry.info.category : "other";
            if (!byCategory.containsKey(cat)) {
                cat = "other";
            }
            ((List)byCategory.get(cat)).add(modEntry);
        }
        for (Map.Entry entry : byCategory.entrySet()) {
            if (((List)entry.getValue()).isEmpty()) continue;
            String catName = CATEGORIES.get(entry.getKey());
            JPanel catHeader = new JPanel(new FlowLayout(0, 5, 0));
            catHeader.setOpaque(false);
            catHeader.setMaximumSize(new Dimension(Integer.MAX_VALUE, 30));
            JLabel catIcon = new JLabel(this.getCategoryIcon((String)entry.getKey()));
            catIcon.setForeground(Theme.ACCENT_PRIMARY);
            catHeader.add(catIcon);
            JLabel catLabel = new JLabel(catName);
            catLabel.setFont(new Font("Segoe UI", 1, 13));
            catLabel.setForeground(Theme.ACCENT_PRIMARY);
            catHeader.add(catLabel);
            this.modsListPanel.add(Box.createVerticalStrut(15));
            this.modsListPanel.add(catHeader);
            this.modsListPanel.add(Box.createVerticalStrut(8));
            for (ModEntry mod : (List)entry.getValue()) {
                this.modsListPanel.add(this.createModCard(mod));
                this.modsListPanel.add(Box.createVerticalStrut(8));
            }
        }
        this.modsListPanel.add(Box.createVerticalGlue());
        this.modsListPanel.revalidate();
        this.modsListPanel.repaint();
    }

    private String getCategoryIcon(String category) {
        switch (category) {
            case "gameplay": {
                return "\ud83c\udfae";
            }
            case "visual": {
                return "\u25c8";
            }
            case "optim": {
                return "\u26a1";
            }
            case "util": {
                return "\u25c6";
            }
        }
        return "\u25cf";
    }

    private JPanel createModCard(ModEntry mod) {
        JPanel card = new JPanel(new BorderLayout(15, 0)){
            private boolean hover;
            private float hoverAnim;
            private Timer animTimer;
            {
                this.hover = false;
                this.hoverAnim = 0.0f;
                this.setOpaque(false);
                this.setMaximumSize(new Dimension(Integer.MAX_VALUE, 65));
                this.setPreferredSize(new Dimension(450, 65));
                this.setBorder(BorderFactory.createEmptyBorder(10, 15, 10, 15));
                this.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        hover = true;
                        this.startAnim(true);
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        hover = false;
                        this.startAnim(false);
                    }
                });
            }

            private void startAnim(boolean in) {
                if (this.animTimer != null) {
                    this.animTimer.stop();
                }
                this.animTimer = new Timer(16, e -> {
                    if (in) {
                        this.hoverAnim += 0.15f;
                        if (this.hoverAnim >= 1.0f) {
                            this.hoverAnim = 1.0f;
                            this.animTimer.stop();
                        }
                    } else {
                        this.hoverAnim -= 0.15f;
                        if (this.hoverAnim <= 0.0f) {
                            this.hoverAnim = 0.0f;
                            this.animTimer.stop();
                        }
                    }
                    this.repaint();
                });
                this.animTimer.start();
            }

            @Override
            protected void paintComponent(Graphics g) {
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                Color bgColor = new Color((int)(40.0f + 15.0f * this.hoverAnim), (int)(48.0f + 15.0f * this.hoverAnim), (int)(65.0f + 15.0f * this.hoverAnim), 220);
                g2d.setColor(bgColor);
                g2d.fill(new RoundRectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight(), 12.0, 12.0));
                if (this.hoverAnim > 0.0f) {
                    g2d.setColor(new Color(Theme.ACCENT_PRIMARY.getRed(), Theme.ACCENT_PRIMARY.getGreen(), Theme.ACCENT_PRIMARY.getBlue(), (int)(100.0f * this.hoverAnim)));
                    g2d.setStroke(new BasicStroke(1.5f));
                    g2d.draw(new RoundRectangle2D.Double(0.0, 0.0, this.getWidth() - 1, this.getHeight() - 1, 12.0, 12.0));
                }
                g2d.dispose();
                super.paintComponent(g);
            }
        };
        JPanel infoPanel = new JPanel();
        infoPanel.setOpaque(false);
        infoPanel.setLayout(new BoxLayout(infoPanel, 1));
        JLabel nameLabel = new JLabel(mod.info.name);
        nameLabel.setFont(new Font("Segoe UI", 1, 14));
        nameLabel.setForeground(Theme.TEXT_PRIMARY);
        nameLabel.setAlignmentX(0.0f);
        infoPanel.add(nameLabel);
        infoPanel.add(Box.createVerticalStrut(4));
        String description = mod.info.description;
        String modKey = this.getModKey(mod.fileName);
        if (MOD_GROUPS.containsKey(modKey)) {
            description = description + " (+ \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0438)";
        }
        JLabel descLabel = new JLabel(description);
        descLabel.setFont(Theme.FONT_SMALL);
        descLabel.setForeground(Theme.TEXT_SECONDARY);
        descLabel.setAlignmentX(0.0f);
        infoPanel.add(descLabel);
        card.add((Component)infoPanel, "Center");
        AnimatedToggle toggle = new AnimatedToggle(mod.enabled);
        toggle.addActionListener(e -> {
            mod.enabled = toggle.isSelected();
            this.modStates.put(mod.fileName, mod.enabled);
            String key = this.getModKey(mod.fileName);
            if (MOD_GROUPS.containsKey(key)) {
                String[] deps;
                block0: for (String depKey : deps = MOD_GROUPS.get(key)) {
                    for (ModEntry depMod : this.mods) {
                        if (!this.getModKey(depMod.fileName).equals(depKey)) continue;
                        depMod.enabled = mod.enabled;
                        this.modStates.put(depMod.fileName, mod.enabled);
                        continue block0;
                    }
                }
            }
        });
        JPanel togglePanel = new JPanel(new FlowLayout(2, 0, 10));
        togglePanel.setOpaque(false);
        togglePanel.add(toggle);
        card.add((Component)togglePanel, "East");
        return card;
    }

    private JPanel createButtonsPanel() {
        JPanel panel = new JPanel(new FlowLayout(2, 15, 0));
        panel.setOpaque(false);
        panel.setBorder(BorderFactory.createEmptyBorder(20, 0, 0, 0));
        ModernButton resetBtn = new ModernButton("\u0421\u0431\u0440\u043e\u0441\u0438\u0442\u044c", ModernButton.ButtonType.SECONDARY);
        resetBtn.setPreferredSize(new Dimension(120, 42));
        resetBtn.addActionListener(e -> this.resetToDefaults());
        panel.add(resetBtn);
        ModernButton playBtn = new ModernButton("\u0417\u0410\u041f\u0423\u0421\u0422\u0418\u0422\u042c", ModernButton.ButtonType.PRIMARY);
        playBtn.setPreferredSize(new Dimension(150, 42));
        playBtn.setFont(new Font("Segoe UI", 1, 14));
        playBtn.addActionListener(e -> {
            this.confirmed = true;
            this.fadeOut();
        });
        panel.add(playBtn);
        return panel;
    }

    private void resetToDefaults() {
        for (ModEntry mod : this.mods) {
            mod.enabled = mod.info.enabledByDefault;
            this.modStates.put(mod.fileName, mod.enabled);
        }
        this.populateModsList();
    }

    private void fadeOut() {
        Timer outTimer = new Timer(16, null);
        outTimer.addActionListener(e -> {
            this.fadeAlpha -= 0.1f;
            if (this.fadeAlpha <= 0.0f) {
                this.fadeAlpha = 0.0f;
                outTimer.stop();
                this.dispose();
            }
            this.setOpacity(Math.max(0.0f, this.fadeAlpha));
        });
        outTimer.start();
    }

    public boolean showDialog() {
        this.fadeTimer.start();
        this.setVisible(true);
        return this.confirmed;
    }

    public Map<String, Boolean> getModStates() {
        return this.modStates;
    }

    public void applyChanges(File modsDir) {
        for (ModEntry mod : this.mods) {
            String[] dependencies;
            String modKey = this.getModKey(mod.fileName);
            if (!MOD_GROUPS.containsKey(modKey)) continue;
            block3: for (String depKey : dependencies = MOD_GROUPS.get(modKey)) {
                for (ModEntry depMod : this.mods) {
                    if (!this.getModKey(depMod.fileName).equals(depKey)) continue;
                    depMod.enabled = mod.enabled;
                    this.modStates.put(depMod.fileName, mod.enabled);
                    continue block3;
                }
            }
        }
        for (ModEntry mod : this.mods) {
            try {
                File newFile;
                File currentFile = mod.file;
                String baseName = mod.fileName + ".jar";
                if (mod.enabled) {
                    if (!currentFile.getName().endsWith(".disabled") || !currentFile.renameTo(newFile = new File(currentFile.getParent(), baseName))) continue;
                    mod.file = newFile;
                    LogHelper.info("Enabled mod: " + mod.fileName);
                    continue;
                }
                if (currentFile.getName().endsWith(".disabled") || !currentFile.renameTo(newFile = new File(currentFile.getParent(), baseName + ".disabled"))) continue;
                mod.file = newFile;
                LogHelper.info("Disabled mod: " + mod.fileName);
            }
            catch (Exception e) {
                LogHelper.error("Failed to toggle mod: " + mod.fileName, e);
            }
        }
    }

    private String getModKey(String fileName) {
        String lower = fileName.toLowerCase();
        for (String key : KNOWN_MODS.keySet()) {
            if (!lower.contains(key)) continue;
            return key;
        }
        return lower;
    }

    static {
        CATEGORIES.put("gameplay", "\u0413\u0435\u0439\u043c\u043f\u043b\u0435\u0439");
        CATEGORIES.put("visual", "\u0412\u0438\u0437\u0443\u0430\u043b\u044c\u043d\u044b\u0435 \u0443\u043b\u0443\u0447\u0448\u0435\u043d\u0438\u044f");
        CATEGORIES.put("optim", "\u041e\u043f\u0442\u0438\u043c\u0438\u0437\u0430\u0446\u0438\u044f");
        CATEGORIES.put("util", "\u0423\u0442\u0438\u043b\u0438\u0442\u044b");
        CATEGORIES.put("other", "\u0414\u0440\u0443\u0433\u043e\u0435");
        KNOWN_MODS = new HashMap<String, ModInfo>();
        KNOWN_MODS.put("smartmoving", new ModInfo("Smart Moving", "\u041f\u0430\u0440\u043a\u0443\u0440, \u043f\u043e\u043b\u0437\u0430\u043d\u0438\u0435, \u043b\u0430\u0437\u0430\u043d\u0438\u0435 \u043f\u043e \u0441\u0442\u0435\u043d\u0430\u043c, \u043f\u043b\u0430\u0432\u0430\u043d\u0438\u0435", "gameplay", true));
        KNOWN_MODS.put("smartrender", new ModInfo("Smart Render", "\u0411\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0430 \u0434\u043b\u044f Smart Moving", "gameplay", true, true));
        KNOWN_MODS.put("smartcore", new ModInfo("Smart Core", "\u0411\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0430 \u0434\u043b\u044f Smart Moving", "gameplay", true, true));
        KNOWN_MODS.put("playerapi", new ModInfo("Player API", "\u0411\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0430 \u0434\u043b\u044f Smart Moving", "gameplay", true, true));
        KNOWN_MODS.put("renderplayerapi", new ModInfo("Render Player API", "\u0411\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0430 \u0434\u043b\u044f Smart Moving", "gameplay", true, true));
        KNOWN_MODS.put("dynamiclights", new ModInfo("Dynamic Lights", "\u0414\u0438\u043d\u0430\u043c\u0438\u0447\u0435\u0441\u043a\u043e\u0435 \u043e\u0441\u0432\u0435\u0449\u0435\u043d\u0438\u0435 \u043e\u0442 \u0444\u0430\u043a\u0435\u043b\u043e\u0432 \u0432 \u0440\u0443\u043a\u0435", "visual", true));
        KNOWN_MODS.put("betterfoliage", new ModInfo("Better Foliage", "\u0423\u043b\u0443\u0447\u0448\u0435\u043d\u043d\u0430\u044f \u043b\u0438\u0441\u0442\u0432\u0430 \u0438 \u0442\u0440\u0430\u0432\u0430", "visual", true));
        KNOWN_MODS.put("motionblur", new ModInfo("Motion Blur", "\u042d\u0444\u0444\u0435\u043a\u0442 \u0440\u0430\u0437\u043c\u044b\u0442\u0438\u044f \u0432 \u0434\u0432\u0438\u0436\u0435\u043d\u0438\u0438", "visual", false));
        KNOWN_MODS.put("shader", new ModInfo("Shaders Mod", "\u041f\u043e\u0434\u0434\u0435\u0440\u0436\u043a\u0430 \u0448\u0435\u0439\u0434\u0435\u0440\u043e\u0432", "visual", false));
        KNOWN_MODS.put("optifine", new ModInfo("OptiFine", "\u041e\u043f\u0442\u0438\u043c\u0438\u0437\u0430\u0446\u0438\u044f + \u0448\u0435\u0439\u0434\u0435\u0440\u044b + \u0437\u0443\u043c", "visual", true));
        KNOWN_MODS.put("colorfulsky", new ModInfo("Colorful Sky", "\u041a\u0440\u0430\u0441\u0438\u0432\u043e\u0435 \u043d\u0435\u0431\u043e", "visual", true));
        KNOWN_MODS.put("particleculling", new ModInfo("Particle Culling", "\u041e\u043f\u0442\u0438\u043c\u0438\u0437\u0430\u0446\u0438\u044f \u0447\u0430\u0441\u0442\u0438\u0446", "visual", true));
        KNOWN_MODS.put("fastcraft", new ModInfo("FastCraft", "\u0423\u0441\u043a\u043e\u0440\u0435\u043d\u0438\u0435 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u0447\u0430\u043d\u043a\u043e\u0432", "optim", true));
        KNOWN_MODS.put("betterfps", new ModInfo("BetterFPS", "\u041e\u043f\u0442\u0438\u043c\u0438\u0437\u0430\u0446\u0438\u044f \u043c\u0430\u0442\u0435\u043c\u0430\u0442\u0438\u043a\u0438", "optim", true));
        KNOWN_MODS.put("foamfix", new ModInfo("FoamFix", "\u0423\u043c\u0435\u043d\u044c\u0448\u0435\u043d\u0438\u0435 \u043f\u043e\u0442\u0440\u0435\u0431\u043b\u0435\u043d\u0438\u044f RAM", "optim", true));
        KNOWN_MODS.put("phosphor", new ModInfo("Phosphor", "\u041e\u043f\u0442\u0438\u043c\u0438\u0437\u0430\u0446\u0438\u044f \u043e\u0441\u0432\u0435\u0449\u0435\u043d\u0438\u044f", "optim", true));
        KNOWN_MODS.put("vanillafix", new ModInfo("VanillaFix", "\u0418\u0441\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u043a\u0440\u0430\u0448\u0435\u0439", "optim", true));
        KNOWN_MODS.put("rei", new ModInfo("REI Minimap", "\u041c\u0438\u043d\u0438\u043a\u0430\u0440\u0442\u0430", "util", false));
        KNOWN_MODS.put("journeymap", new ModInfo("JourneyMap", "\u041f\u0440\u043e\u0434\u0432\u0438\u043d\u0443\u0442\u0430\u044f \u043a\u0430\u0440\u0442\u0430", "util", false));
        KNOWN_MODS.put("voxelmap", new ModInfo("VoxelMap", "\u041a\u0430\u0440\u0442\u0430 \u0441 \u043c\u0435\u0442\u043a\u0430\u043c\u0438", "util", false));
        KNOWN_MODS.put("inventorytweaks", new ModInfo("Inventory Tweaks", "\u0421\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0430 \u0438\u043d\u0432\u0435\u043d\u0442\u0430\u0440\u044f", "util", true));
        KNOWN_MODS.put("itemphysic", new ModInfo("ItemPhysic", "\u0420\u0435\u0430\u043b\u0438\u0441\u0442\u0438\u0447\u043d\u044b\u0435 \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u044b", "util", false));
        KNOWN_MODS.put("mousetweaks", new ModInfo("Mouse Tweaks", "\u0423\u043b\u0443\u0447\u0448\u0435\u043d\u043d\u043e\u0435 \u0443\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043c\u044b\u0448\u044c\u044e", "util", true));
        KNOWN_MODS.put("statuseffecthud", new ModInfo("Status Effect HUD", "\u041e\u0442\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u044d\u0444\u0444\u0435\u043a\u0442\u043e\u0432", "util", true));
        KNOWN_MODS.put("armorstatushud", new ModInfo("Armor Status HUD", "\u041e\u0442\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u0431\u0440\u043e\u043d\u0438", "util", true));
        KNOWN_MODS.put("damageindicators", new ModInfo("Damage Indicators", "\u0418\u043d\u0434\u0438\u043a\u0430\u0442\u043e\u0440\u044b \u0443\u0440\u043e\u043d\u0430", "util", false));
        MOD_GROUPS = new HashMap<String, String[]>();
        MOD_GROUPS.put("smartmoving", new String[]{"smartrender", "smartcore", "playerapi", "renderplayerapi"});
    }

    private class ModernScrollBarUI
    extends BasicScrollBarUI {
        private ModernScrollBarUI() {
        }

        @Override
        protected void configureScrollBarColors() {
            this.thumbColor = new Color(100, 110, 130);
            this.trackColor = new Color(30, 35, 45);
        }

        @Override
        protected JButton createDecreaseButton(int orientation) {
            return this.createZeroButton();
        }

        @Override
        protected JButton createIncreaseButton(int orientation) {
            return this.createZeroButton();
        }

        private JButton createZeroButton() {
            JButton btn = new JButton();
            btn.setPreferredSize(new Dimension(0, 0));
            return btn;
        }

        @Override
        protected void paintThumb(Graphics g, JComponent c, Rectangle r) {
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setColor(this.thumbColor);
            g2d.fillRoundRect(r.x + 2, r.y, r.width - 4, r.height, 8, 8);
            g2d.dispose();
        }

        @Override
        protected void paintTrack(Graphics g, JComponent c, Rectangle r) {
            g.setColor(this.trackColor);
            g.fillRect(r.x, r.y, r.width, r.height);
        }
    }

    private class AnimatedToggle
    extends JToggleButton {
        private float animProgress = 0.0f;
        private Timer animTimer;
        private Color trackOff = new Color(70, 80, 100);
        private Color trackOn = Theme.ACCENT_PRIMARY;

        public AnimatedToggle(boolean selected) {
            this.setSelected(selected);
            this.animProgress = selected ? 1.0f : 0.0f;
            this.setPreferredSize(new Dimension(50, 26));
            this.setOpaque(false);
            this.setContentAreaFilled(false);
            this.setBorderPainted(false);
            this.setFocusPainted(false);
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.addActionListener(e -> this.animate(this.isSelected()));
        }

        private void animate(boolean on) {
            if (this.animTimer != null) {
                this.animTimer.stop();
            }
            this.animTimer = new Timer(16, e -> {
                if (on) {
                    this.animProgress += 0.12f;
                    if (this.animProgress >= 1.0f) {
                        this.animProgress = 1.0f;
                        this.animTimer.stop();
                    }
                } else {
                    this.animProgress -= 0.12f;
                    if (this.animProgress <= 0.0f) {
                        this.animProgress = 0.0f;
                        this.animTimer.stop();
                    }
                }
                this.repaint();
            });
            this.animTimer.start();
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int w = this.getWidth();
            int h = this.getHeight();
            int trackH = 22;
            int trackY = (h - trackH) / 2;
            int thumbSize = 18;
            Color trackColor = this.interpolateColor(this.trackOff, this.trackOn, this.animProgress);
            g2d.setColor(trackColor);
            g2d.fillRoundRect(0, trackY, w, trackH, trackH, trackH);
            int thumbX = (int)(3.0f + (float)(w - thumbSize - 6) * this.animProgress);
            int thumbY = trackY + (trackH - thumbSize) / 2;
            g2d.setColor(new Color(0, 0, 0, 40));
            g2d.fillOval(thumbX + 1, thumbY + 2, thumbSize, thumbSize);
            g2d.setColor(Color.WHITE);
            g2d.fillOval(thumbX, thumbY, thumbSize, thumbSize);
            g2d.dispose();
        }

        private Color interpolateColor(Color c1, Color c2, float t) {
            return new Color((int)((float)c1.getRed() + (float)(c2.getRed() - c1.getRed()) * t), (int)((float)c1.getGreen() + (float)(c2.getGreen() - c1.getGreen()) * t), (int)((float)c1.getBlue() + (float)(c2.getBlue() - c1.getBlue()) * t));
        }
    }

    private static class ModInfo {
        String name;
        String description;
        String category;
        boolean enabledByDefault;
        boolean hidden;

        ModInfo(String name, String description, String category, boolean enabledByDefault) {
            this(name, description, category, enabledByDefault, false);
        }

        ModInfo(String name, String description, String category, boolean enabledByDefault, boolean hidden) {
            this.name = name;
            this.description = description;
            this.category = category;
            this.enabledByDefault = enabledByDefault;
            this.hidden = hidden;
        }
    }

    private static class ModEntry {
        File file;
        String fileName;
        boolean enabled;
        boolean isOptional;
        ModInfo info;

        private ModEntry() {
        }
    }
}

