/*
 * Decompiled with CFR 0.152.
 */
package ru.minezone.launcher.gui.components;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import ru.minezone.launcher.gui.Theme;

public class ModernProgressBar
extends JProgressBar {
    private String statusText = "";
    private float displayedValue = 0.0f;
    private float shimmerPhase = 0.0f;
    private Timer animTimer;
    private Timer shimmerTimer;
    private float[] particles = new float[5];
    private float[] particleSpeeds = new float[]{1.2f, 0.8f, 1.5f, 1.0f, 1.3f};

    public ModernProgressBar() {
        super(0, 100);
        this.setOpaque(false);
        this.setBorderPainted(false);
        this.setPreferredSize(new Dimension(300, 28));
        this.setFont(Theme.FONT_SMALL);
        this.animTimer = new Timer(16, e -> {
            float target = this.getValue();
            if (Math.abs(this.displayedValue - target) > 0.5f) {
                this.displayedValue += (target - this.displayedValue) * 0.1f;
                this.repaint();
            }
        });
        this.animTimer.start();
        this.shimmerTimer = new Timer(30, e -> {
            this.shimmerPhase += 0.03f;
            if (this.shimmerPhase > 1.0f) {
                this.shimmerPhase = -0.3f;
            }
            for (int i = 0; i < this.particles.length; ++i) {
                int n = i;
                this.particles[n] = this.particles[n] + this.particleSpeeds[i] * 0.02f;
                if (!(this.particles[i] > 1.0f)) continue;
                this.particles[i] = 0.0f;
            }
            if (this.getValue() > 0 && this.getValue() < 100) {
                this.repaint();
            }
        });
        this.shimmerTimer.start();
    }

    @Override
    protected void paintComponent(Graphics g) {
        int height;
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int width = this.getWidth();
        int arc = height = this.getHeight();
        g2d.setColor(new Color(0, 0, 0, 30));
        g2d.fill(new RoundRectangle2D.Double(2.0, 4.0, width - 4, height - 4, arc, arc));
        GradientPaint trackBg = new GradientPaint(0.0f, 0.0f, new Color(30, 38, 52), 0.0f, height, new Color(20, 26, 36));
        g2d.setPaint(trackBg);
        g2d.fill(new RoundRectangle2D.Double(0.0, 0.0, width, height, arc, arc));
        g2d.setColor(new Color(0, 0, 0, 40));
        g2d.setStroke(new BasicStroke(2.0f));
        g2d.draw(new RoundRectangle2D.Double(1.0, 1.0, width - 2, height - 2, arc - 2, arc - 2));
        if (this.displayedValue > 0.0f) {
            int shimmerX;
            int progressWidth = (int)((float)(width - 4) * (this.displayedValue / (float)this.getMaximum()));
            progressWidth = Math.max(progressWidth, height - 4);
            GradientPaint gradient = new GradientPaint(0.0f, 0.0f, Theme.ACCENT_SECONDARY, progressWidth, 0.0f, Theme.ACCENT_PRIMARY);
            g2d.setPaint(gradient);
            g2d.fill(new RoundRectangle2D.Double(2.0, 2.0, progressWidth, height - 4, arc - 4, arc - 4));
            GradientPaint shine = new GradientPaint(0.0f, 2.0f, new Color(255, 255, 255, 80), 0.0f, height / 2, new Color(255, 255, 255, 0));
            g2d.setPaint(shine);
            g2d.fill(new RoundRectangle2D.Double(2.0, 2.0, progressWidth, (height - 4) / 2, arc - 4, arc - 4));
            if (this.getValue() < 100 && (shimmerX = (int)(this.shimmerPhase * (float)(progressWidth + 60)) - 30) > 0 && shimmerX < progressWidth) {
                GradientPaint shimmer = new GradientPaint(shimmerX - 30, 0.0f, new Color(255, 255, 255, 0), shimmerX, 0.0f, new Color(255, 255, 255, 60), true);
                g2d.setPaint(shimmer);
                g2d.setClip(new RoundRectangle2D.Double(2.0, 2.0, progressWidth, height - 4, arc - 4, arc - 4));
                g2d.fillRect(shimmerX - 30, 2, 60, height - 4);
                g2d.setClip(null);
            }
            if (this.getValue() > 0 && this.getValue() < 100) {
                for (int i = 0; i < this.particles.length; ++i) {
                    float p = this.particles[i];
                    int px = progressWidth - 5 + (int)(p * 20.0f);
                    int py = 4 + (int)(Math.sin((double)p * Math.PI) * (double)(height - 12));
                    float alpha = 1.0f - p;
                    g2d.setColor(new Color(255, 255, 255, (int)(alpha * 150.0f)));
                    g2d.fillOval(px, py, 3, 3);
                }
            }
            if (progressWidth > 10) {
                RadialGradientPaint glow = new RadialGradientPaint(progressWidth, (float)height / 2.0f, 20.0f, new float[]{0.0f, 1.0f}, new Color[]{new Color(Theme.ACCENT_PRIMARY.getRed(), Theme.ACCENT_PRIMARY.getGreen(), Theme.ACCENT_PRIMARY.getBlue(), 100), new Color(Theme.ACCENT_PRIMARY.getRed(), Theme.ACCENT_PRIMARY.getGreen(), Theme.ACCENT_PRIMARY.getBlue(), 0)});
                g2d.setPaint(glow);
                g2d.fillOval(progressWidth - 15, -5, 30, height + 10);
            }
        }
        g2d.setColor(new Color(80, 90, 110, 100));
        g2d.setStroke(new BasicStroke(1.0f));
        g2d.draw(new RoundRectangle2D.Double(0.0, 0.0, width - 1, height - 1, arc, arc));
        g2d.setFont(new Font("Segoe UI", 1, 11));
        String text = this.statusText.isEmpty() ? String.format("%.0f%%", Float.valueOf(this.displayedValue)) : this.statusText + " \u2022 " + String.format("%.0f%%", Float.valueOf(this.displayedValue));
        FontMetrics fm = g2d.getFontMetrics();
        int textX = (width - fm.stringWidth(text)) / 2;
        int textY = (height + fm.getAscent() - fm.getDescent()) / 2;
        g2d.setColor(new Color(0, 0, 0, 100));
        g2d.drawString(text, textX + 1, textY + 1);
        g2d.setColor(Theme.TEXT_PRIMARY);
        g2d.drawString(text, textX, textY);
        g2d.dispose();
    }

    public void setStatusText(String statusText) {
        this.statusText = statusText;
        this.repaint();
    }

    @Override
    public void setValue(int n) {
        super.setValue(n);
    }
}

