/*
 * Decompiled with CFR 0.152.
 */
package ru.minezone.launcher.gui.components;

import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JPasswordField;
import javax.swing.border.EmptyBorder;
import ru.minezone.launcher.gui.Theme;

public class ModernPasswordField
extends JPasswordField {
    private String placeholder;
    private boolean focused = false;

    public ModernPasswordField() {
        this("\u041f\u0430\u0440\u043e\u043b\u044c");
    }

    public ModernPasswordField(String placeholder) {
        this.placeholder = placeholder;
        this.init();
    }

    private void init() {
        this.setOpaque(false);
        this.setFont(Theme.FONT_REGULAR);
        this.setForeground(Theme.TEXT_PRIMARY);
        this.setCaretColor(Theme.ACCENT_PRIMARY);
        this.setBorder(new EmptyBorder(10, 15, 10, 15));
        this.setPreferredSize(new Dimension(250, 45));
        this.setEchoChar('\u25cf');
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ModernPasswordField.this.focused = true;
                ModernPasswordField.this.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                ModernPasswordField.this.focused = false;
                ModernPasswordField.this.repaint();
            }
        });
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int width = this.getWidth();
        int height = this.getHeight();
        g2d.setColor(Theme.BACKGROUND_LIGHT);
        g2d.fill(new RoundRectangle2D.Double(0.0, 0.0, width, height, 12.0, 12.0));
        g2d.setColor(this.focused ? Theme.ACCENT_PRIMARY : Theme.BORDER_DEFAULT);
        g2d.setStroke(new BasicStroke(this.focused ? 2.0f : 1.0f));
        g2d.draw(new RoundRectangle2D.Double(1.0, 1.0, width - 2, height - 2, 12.0, 12.0));
        g2d.dispose();
        super.paintComponent(g);
        if (this.getPassword().length == 0 && !this.focused) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2.setColor(Theme.TEXT_PLACEHOLDER);
            g2.setFont(this.getFont());
            FontMetrics fm = g2.getFontMetrics();
            int y = (height + fm.getAscent() - fm.getDescent()) / 2;
            g2.drawString(this.placeholder, 15, y);
            g2.dispose();
        }
    }
}

