/*
 * Decompiled with CFR 0.152.
 */
package ru.minezone.launcher.gui.components;

import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import ru.minezone.launcher.gui.Theme;

public class ModernComboBox<E>
extends JComboBox<E> {
    public ModernComboBox() {
        this.init();
    }

    public ModernComboBox(E[] items) {
        super(items);
        this.init();
    }

    private void init() {
        this.setFont(Theme.FONT_REGULAR);
        this.setForeground(Theme.TEXT_PRIMARY);
        this.setBackground(Theme.BACKGROUND_LIGHT);
        this.setPreferredSize(new Dimension(200, 45));
        this.setRenderer(new ModernListCellRenderer());
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int width = this.getWidth();
        int height = this.getHeight();
        g2d.setColor(Theme.BACKGROUND_LIGHT);
        g2d.fill(new RoundRectangle2D.Double(0.0, 0.0, width, height, 12.0, 12.0));
        g2d.setColor(Theme.BORDER_DEFAULT);
        g2d.setStroke(new BasicStroke(1.5f));
        g2d.draw(new RoundRectangle2D.Double(1.0, 1.0, width - 2, height - 2, 12.0, 12.0));
        g2d.setColor(Theme.TEXT_PRIMARY);
        g2d.setFont(this.getFont());
        String text = this.getSelectedItem() != null ? this.getSelectedItem().toString() : "";
        FontMetrics fm = g2d.getFontMetrics();
        g2d.drawString(text, 15, (height + fm.getAscent() - fm.getDescent()) / 2);
        g2d.setColor(Theme.TEXT_SECONDARY);
        int arrowX = width - 25;
        int arrowY = height / 2 - 2;
        int[] xPoints = new int[]{arrowX, arrowX + 10, arrowX + 5};
        int[] yPoints = new int[]{arrowY, arrowY, arrowY + 6};
        g2d.fillPolygon(xPoints, yPoints, 3);
        g2d.dispose();
    }

    private class ModernListCellRenderer
    extends DefaultListCellRenderer {
        private ModernListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            label.setFont(Theme.FONT_REGULAR);
            label.setBorder(BorderFactory.createEmptyBorder(10, 15, 10, 15));
            label.setBackground(isSelected ? Theme.ACCENT_PRIMARY : Theme.BACKGROUND_MEDIUM);
            label.setForeground(Theme.TEXT_PRIMARY);
            return label;
        }
    }
}

