/*
 * Decompiled with CFR 0.152.
 */
package ru.minezone.launcher.gui.components;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JButton;
import ru.minezone.launcher.gui.Theme;

public class ModernButton
extends JButton {
    private ButtonType type;
    private boolean hover = false;
    private boolean pressed = false;

    public ModernButton(String text) {
        this(text, ButtonType.PRIMARY);
    }

    public ModernButton(String text, ButtonType type) {
        super(text);
        this.type = type;
        this.init();
    }

    private void init() {
        this.setFont(Theme.FONT_BUTTON);
        this.setForeground(Theme.TEXT_PRIMARY);
        this.setPreferredSize(new Dimension(150, 45));
        this.setBorderPainted(false);
        this.setContentAreaFilled(false);
        this.setFocusPainted(false);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                ModernButton.this.hover = true;
                ModernButton.this.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ModernButton.this.hover = false;
                ModernButton.this.pressed = false;
                ModernButton.this.repaint();
            }

            @Override
            public void mousePressed(MouseEvent e) {
                ModernButton.this.pressed = true;
                ModernButton.this.repaint();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                ModernButton.this.pressed = false;
                ModernButton.this.repaint();
            }
        });
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int width = this.getWidth();
        int height = this.getHeight();
        Color bgColor = this.getBackgroundColor();
        if (this.pressed) {
            bgColor = bgColor.darker();
        } else if (this.hover) {
            bgColor = bgColor.brighter();
        }
        if (this.type == ButtonType.GHOST) {
            if (this.hover || this.pressed) {
                g2d.setColor(new Color(bgColor.getRed(), bgColor.getGreen(), bgColor.getBlue(), 50));
                g2d.fill(new RoundRectangle2D.Double(0.0, 0.0, width, height, 12.0, 12.0));
            }
            g2d.setColor(Theme.BORDER_DEFAULT);
            g2d.setStroke(new BasicStroke(1.5f));
            g2d.draw(new RoundRectangle2D.Double(1.0, 1.0, width - 2, height - 2, 12.0, 12.0));
        } else {
            GradientPaint gradient = new GradientPaint(0.0f, 0.0f, bgColor, 0.0f, height, bgColor.darker());
            g2d.setPaint(gradient);
            g2d.fill(new RoundRectangle2D.Double(0.0, 0.0, width, height, 12.0, 12.0));
        }
        g2d.setFont(this.getFont());
        g2d.setColor(this.getForeground());
        FontMetrics fm = g2d.getFontMetrics();
        int textX = (width - fm.stringWidth(this.getText())) / 2;
        int textY = (height + fm.getAscent() - fm.getDescent()) / 2;
        g2d.drawString(this.getText(), textX, textY);
        g2d.dispose();
    }

    private Color getBackgroundColor() {
        switch (this.type) {
            case PRIMARY: {
                return Theme.ACCENT_PRIMARY;
            }
            case SECONDARY: {
                return Theme.BACKGROUND_LIGHTER;
            }
            case SUCCESS: {
                return Theme.SUCCESS;
            }
            case DANGER: {
                return Theme.ERROR;
            }
            case GHOST: {
                return Theme.BACKGROUND_LIGHT;
            }
        }
        return Theme.ACCENT_PRIMARY;
    }

    public static enum ButtonType {
        PRIMARY,
        SECONDARY,
        SUCCESS,
        DANGER,
        GHOST;

    }
}

