/*
 * Decompiled with CFR 0.152.
 */
package ru.minezone.launcher.gui.components;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import ru.minezone.launcher.gui.Theme;
import ru.minezone.launcher.gui.components.ModernButton;

public class ConfirmDialog
extends JDialog {
    private boolean confirmed = false;
    private float fadeAlpha = 0.0f;
    private Timer fadeTimer;

    public ConfirmDialog(Frame owner, String title, String message, DialogType type, boolean showCancel) {
        super(owner, title, true);
        this.initUI(title, message, type, showCancel);
    }

    private void initUI(String title, String message, final DialogType type, boolean showCancel) {
        this.setUndecorated(true);
        int height = Math.min(350, 180 + message.split("\n").length * 20);
        this.setSize(480, height);
        this.setLocationRelativeTo(this.getOwner());
        this.setBackground(new Color(0, 0, 0, 0));
        JPanel mainPanel = new JPanel(new BorderLayout()){

            @Override
            protected void paintComponent(Graphics g) {
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                for (int i = 0; i < 8; ++i) {
                    g2d.setColor(new Color(0, 0, 0, 25 - i * 3));
                    g2d.fill(new RoundRectangle2D.Double(i, i, this.getWidth() - i * 2, this.getHeight() - i * 2, 20.0, 20.0));
                }
                GradientPaint bg = new GradientPaint(0.0f, 0.0f, new Color(30, 38, 55), 0.0f, this.getHeight(), new Color(20, 26, 40));
                g2d.setPaint(bg);
                g2d.fill(new RoundRectangle2D.Double(4.0, 4.0, this.getWidth() - 8, this.getHeight() - 8, 18.0, 18.0));
                Color borderColor = ConfirmDialog.this.getBorderColor(type);
                g2d.setColor(borderColor);
                g2d.setStroke(new BasicStroke(2.0f));
                g2d.draw(new RoundRectangle2D.Double(4.0, 4.0, this.getWidth() - 8, this.getHeight() - 8, 18.0, 18.0));
                g2d.setColor(borderColor);
                g2d.fillRoundRect(4, 4, this.getWidth() - 8, 4, 4, 4);
                g2d.dispose();
            }
        };
        mainPanel.setOpaque(false);
        mainPanel.setBorder(BorderFactory.createEmptyBorder(25, 30, 20, 30));
        JPanel headerPanel = new JPanel(new FlowLayout(0, 12, 0));
        headerPanel.setOpaque(false);
        JLabel iconLabel = new JLabel(this.getIcon(type));
        iconLabel.setFont(new Font("Segoe UI", 0, 28));
        iconLabel.setForeground(this.getBorderColor(type));
        headerPanel.add(iconLabel);
        JLabel titleLabel = new JLabel(title);
        titleLabel.setFont(new Font("Segoe UI", 1, 18));
        titleLabel.setForeground(Theme.TEXT_PRIMARY);
        headerPanel.add(titleLabel);
        mainPanel.add((Component)headerPanel, "North");
        JTextArea messageArea = new JTextArea(message);
        messageArea.setFont(Theme.FONT_REGULAR);
        messageArea.setForeground(Theme.TEXT_SECONDARY);
        messageArea.setOpaque(false);
        messageArea.setEditable(false);
        messageArea.setWrapStyleWord(true);
        messageArea.setLineWrap(true);
        messageArea.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        JScrollPane scrollPane = new JScrollPane(messageArea);
        scrollPane.setOpaque(false);
        scrollPane.getViewport().setOpaque(false);
        scrollPane.setBorder(null);
        scrollPane.setHorizontalScrollBarPolicy(31);
        mainPanel.add((Component)scrollPane, "Center");
        JPanel buttonsPanel = new JPanel(new FlowLayout(2, 10, 0));
        buttonsPanel.setOpaque(false);
        buttonsPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        if (showCancel) {
            ModernButton cancelBtn = new ModernButton("\u041e\u0442\u043c\u0435\u043d\u0430", ModernButton.ButtonType.SECONDARY);
            cancelBtn.setPreferredSize(new Dimension(100, 38));
            cancelBtn.addActionListener(e -> {
                this.confirmed = false;
                this.fadeOut();
            });
            buttonsPanel.add(cancelBtn);
        }
        String okText = showCancel ? "\u0414\u0430" : "OK";
        ModernButton.ButtonType btnType = type == DialogType.ERROR || type == DialogType.WARNING ? ModernButton.ButtonType.SECONDARY : ModernButton.ButtonType.PRIMARY;
        ModernButton okBtn = new ModernButton(okText, btnType);
        okBtn.setPreferredSize(new Dimension(100, 38));
        okBtn.addActionListener(e -> {
            this.confirmed = true;
            this.fadeOut();
        });
        buttonsPanel.add(okBtn);
        mainPanel.add((Component)buttonsPanel, "South");
        this.setContentPane(mainPanel);
        this.getRootPane().registerKeyboardAction(e -> {
            this.confirmed = false;
            this.fadeOut();
        }, KeyStroke.getKeyStroke(27, 0), 2);
        this.getRootPane().registerKeyboardAction(e -> {
            this.confirmed = true;
            this.fadeOut();
        }, KeyStroke.getKeyStroke(10, 0), 2);
        this.setOpacity(0.0f);
        this.fadeTimer = new Timer(16, e -> {
            this.fadeAlpha += 0.1f;
            if (this.fadeAlpha >= 1.0f) {
                this.fadeAlpha = 1.0f;
                this.fadeTimer.stop();
            }
            this.setOpacity(this.fadeAlpha);
        });
    }

    private Color getBorderColor(DialogType type) {
        switch (type) {
            case ERROR: {
                return Theme.ERROR;
            }
            case WARNING: {
                return Theme.WARNING;
            }
            case QUESTION: {
                return Theme.ACCENT_PRIMARY;
            }
        }
        return Theme.SUCCESS;
    }

    private String getIcon(DialogType type) {
        switch (type) {
            case ERROR: {
                return "X";
            }
            case WARNING: {
                return "!";
            }
            case QUESTION: {
                return "?";
            }
        }
        return "i";
    }

    private void fadeOut() {
        Timer outTimer = new Timer(16, null);
        outTimer.addActionListener(e -> {
            this.fadeAlpha -= 0.15f;
            if (this.fadeAlpha <= 0.0f) {
                this.fadeAlpha = 0.0f;
                outTimer.stop();
                this.dispose();
            }
            this.setOpacity(Math.max(0.0f, this.fadeAlpha));
        });
        outTimer.start();
    }

    public boolean showDialog() {
        this.fadeTimer.start();
        this.setVisible(true);
        return this.confirmed;
    }

    public static void showInfo(Frame owner, String title, String message) {
        ConfirmDialog dialog = new ConfirmDialog(owner, title, message, DialogType.INFO, false);
        dialog.showDialog();
    }

    public static void showWarning(Frame owner, String title, String message) {
        ConfirmDialog dialog = new ConfirmDialog(owner, title, message, DialogType.WARNING, false);
        dialog.showDialog();
    }

    public static void showError(Frame owner, String title, String message) {
        ConfirmDialog dialog = new ConfirmDialog(owner, title, message, DialogType.ERROR, false);
        dialog.showDialog();
    }

    public static boolean showConfirm(Frame owner, String title, String message) {
        ConfirmDialog dialog = new ConfirmDialog(owner, title, message, DialogType.QUESTION, true);
        return dialog.showDialog();
    }

    public static boolean showWarningConfirm(Frame owner, String title, String message) {
        ConfirmDialog dialog = new ConfirmDialog(owner, title, message, DialogType.WARNING, true);
        return dialog.showDialog();
    }

    public static enum DialogType {
        INFO,
        WARNING,
        ERROR,
        QUESTION;

    }
}

