/*
 * Decompiled with CFR 0.152.
 */
package ru.minezone.launcher.gui;

import com.sun.management.OperatingSystemMXBean;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import java.io.File;
import java.lang.management.ManagementFactory;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import ru.minezone.launcher.MineZoneLauncher;
import ru.minezone.launcher.gui.MainFrame;
import ru.minezone.launcher.gui.Theme;
import ru.minezone.launcher.gui.components.ConfirmDialog;
import ru.minezone.launcher.gui.components.ModernButton;
import ru.minezone.launcher.utils.Config;
import ru.minezone.launcher.utils.LogHelper;

public class SettingsPanel
extends JPanel {
    private MainFrame mainFrame;
    private Config config;
    private JSlider ramSlider;
    private JLabel ramValueLabel;
    private JLabel ramHintLabel;
    private JCheckBox fullscreenCheckbox;
    private JCheckBox hideLauncherCheckbox;
    private int systemRamMB;

    public SettingsPanel(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
        this.config = MineZoneLauncher.getInstance().getConfig();
        this.systemRamMB = this.getSystemMemoryMB();
        this.init();
    }

    private int getSystemMemoryMB() {
        try {
            OperatingSystemMXBean os = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
            long totalMemory = os.getTotalPhysicalMemorySize();
            return (int)(totalMemory / 0x100000L);
        }
        catch (Exception e) {
            try {
                long maxMemory = Runtime.getRuntime().maxMemory();
                return Math.max(4096, (int)(maxMemory / 0x100000L) * 2);
            }
            catch (Exception e2) {
                return 8192;
            }
        }
    }

    private int getDefaultRam() {
        if (this.systemRamMB >= 6144) {
            return 4096;
        }
        return 2048;
    }

    private String getRamHint(int ramMB) {
        if (ramMB < 2048) {
            return "\u041d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u043f\u0430\u043c\u044f\u0442\u0438 \u0434\u043b\u044f \u043a\u043e\u043c\u0444\u043e\u0440\u0442\u043d\u043e\u0439 \u0438\u0433\u0440\u044b";
        }
        if (ramMB <= 2048) {
            return "\u041d\u043e\u0440\u043c\u0430\u043b\u044c\u043d\u043e (\u043c\u0438\u043d\u0438\u043c\u0443\u043c \u0434\u043b\u044f \u043c\u043e\u0434\u043e\u0432)";
        }
        if (ramMB <= 4096) {
            return "\u041e\u0442\u043b\u0438\u0447\u043d\u043e (\u0440\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u0442\u0441\u044f)";
        }
        if (ramMB <= 8192) {
            return "\u041f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e";
        }
        return "\u0421\u043b\u0438\u0448\u043a\u043e\u043c \u043c\u043d\u043e\u0433\u043e (\u043c\u043e\u0436\u0435\u0442 \u0437\u0430\u043c\u0435\u0434\u043b\u0438\u0442\u044c GC)";
    }

    private Color getRamHintColor(int ramMB) {
        if (ramMB < 2048) {
            return Theme.ERROR;
        }
        if (ramMB <= 2048) {
            return Theme.WARNING;
        }
        if (ramMB <= 8192) {
            return Theme.SUCCESS;
        }
        return Theme.WARNING;
    }

    private void init() {
        this.setOpaque(false);
        this.setLayout(new BorderLayout(20, 20));
        this.setBorder(BorderFactory.createEmptyBorder(20, 30, 30, 30));
        JPanel headerPanel = this.createHeaderPanel();
        this.add((Component)headerPanel, "North");
        JPanel contentPanel = this.createContentPanel();
        JScrollPane scrollPane = new JScrollPane(contentPanel);
        scrollPane.setOpaque(false);
        scrollPane.getViewport().setOpaque(false);
        scrollPane.setBorder(null);
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.getVerticalScrollBar().setUnitIncrement(16);
        this.add((Component)scrollPane, "Center");
        JPanel buttonsPanel = this.createButtonsPanel();
        this.add((Component)buttonsPanel, "South");
        this.loadSettings();
    }

    private JPanel createHeaderPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(false);
        ModernButton backButton = new ModernButton("< \u041d\u0430\u0437\u0430\u0434", ModernButton.ButtonType.GHOST);
        backButton.setPreferredSize(new Dimension(120, 40));
        backButton.addActionListener(e -> {
            this.saveSettings();
            this.mainFrame.showPanel("main");
        });
        panel.add((Component)backButton, "West");
        JLabel titleLabel = new JLabel("\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438", 0);
        titleLabel.setFont(Theme.FONT_TITLE);
        titleLabel.setForeground(Theme.TEXT_PRIMARY);
        panel.add((Component)titleLabel, "Center");
        JPanel placeholder = new JPanel();
        placeholder.setOpaque(false);
        placeholder.setPreferredSize(new Dimension(120, 40));
        panel.add((Component)placeholder, "East");
        return panel;
    }

    private JPanel createContentPanel() {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new BoxLayout(panel, 1));
        JPanel memoryPanel = this.createSectionPanel("\u041f\u0430\u043c\u044f\u0442\u044c Java");
        JLabel systemInfoLabel = new JLabel("\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u043e \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435: " + this.systemRamMB + " MB (" + this.systemRamMB / 1024 + " GB)");
        systemInfoLabel.setFont(Theme.FONT_SMALL);
        systemInfoLabel.setForeground(Theme.TEXT_SECONDARY);
        systemInfoLabel.setAlignmentX(0.0f);
        memoryPanel.add(systemInfoLabel);
        memoryPanel.add(Box.createVerticalStrut(15));
        int maxSliderRam = Math.min(this.systemRamMB - 2048, 16384);
        maxSliderRam = Math.max(maxSliderRam, 2048);
        JPanel ramPanel = new JPanel(new BorderLayout(15, 0));
        ramPanel.setOpaque(false);
        ramPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 50));
        ramPanel.setAlignmentX(0.0f);
        JLabel ramTextLabel = new JLabel("\u0412\u044b\u0434\u0435\u043b\u0438\u0442\u044c RAM:");
        ramTextLabel.setFont(Theme.FONT_REGULAR);
        ramTextLabel.setForeground(Theme.TEXT_SECONDARY);
        ramTextLabel.setPreferredSize(new Dimension(150, 30));
        ramPanel.add((Component)ramTextLabel, "West");
        this.ramSlider = new JSlider(1024, maxSliderRam, this.getDefaultRam());
        this.ramSlider.setOpaque(false);
        this.ramSlider.setMajorTickSpacing(1024);
        this.ramSlider.setSnapToTicks(false);
        ramPanel.add((Component)this.ramSlider, "Center");
        this.ramValueLabel = new JLabel(this.getDefaultRam() + " MB");
        this.ramValueLabel.setFont(Theme.FONT_BUTTON);
        this.ramValueLabel.setForeground(Theme.ACCENT_PRIMARY);
        this.ramValueLabel.setPreferredSize(new Dimension(90, 30));
        ramPanel.add((Component)this.ramValueLabel, "East");
        memoryPanel.add(ramPanel);
        memoryPanel.add(Box.createVerticalStrut(10));
        this.ramHintLabel = new JLabel(this.getRamHint(this.getDefaultRam()));
        this.ramHintLabel.setFont(Theme.FONT_REGULAR);
        this.ramHintLabel.setForeground(this.getRamHintColor(this.getDefaultRam()));
        this.ramHintLabel.setAlignmentX(0.0f);
        memoryPanel.add(this.ramHintLabel);
        this.ramSlider.addChangeListener(e -> {
            int value = this.ramSlider.getValue();
            this.ramValueLabel.setText(value + " MB");
            this.ramHintLabel.setText(this.getRamHint(value));
            this.ramHintLabel.setForeground(this.getRamHintColor(value));
        });
        panel.add(memoryPanel);
        panel.add(Box.createVerticalStrut(20));
        JPanel graphicsPanel = this.createSectionPanel("\u0413\u0440\u0430\u0444\u0438\u043a\u0430");
        this.fullscreenCheckbox = new JCheckBox("\u041f\u043e\u043b\u043d\u043e\u044d\u043a\u0440\u0430\u043d\u043d\u044b\u0439 \u0440\u0435\u0436\u0438\u043c");
        this.fullscreenCheckbox.setFont(Theme.FONT_REGULAR);
        this.fullscreenCheckbox.setForeground(Theme.TEXT_PRIMARY);
        this.fullscreenCheckbox.setOpaque(false);
        this.fullscreenCheckbox.setAlignmentX(0.0f);
        graphicsPanel.add(this.fullscreenCheckbox);
        panel.add(graphicsPanel);
        panel.add(Box.createVerticalStrut(20));
        JPanel launcherPanel = this.createSectionPanel("\u041b\u0430\u0443\u043d\u0447\u0435\u0440");
        this.hideLauncherCheckbox = new JCheckBox("\u0421\u043a\u0440\u044b\u0432\u0430\u0442\u044c \u043f\u0440\u0438 \u0437\u0430\u043f\u0443\u0441\u043a\u0435 \u0438\u0433\u0440\u044b");
        this.hideLauncherCheckbox.setFont(Theme.FONT_REGULAR);
        this.hideLauncherCheckbox.setForeground(Theme.TEXT_PRIMARY);
        this.hideLauncherCheckbox.setOpaque(false);
        this.hideLauncherCheckbox.setAlignmentX(0.0f);
        launcherPanel.add(this.hideLauncherCheckbox);
        panel.add(launcherPanel);
        panel.add(Box.createVerticalStrut(20));
        JPanel dataPanel = this.createSectionPanel("\u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0434\u0430\u043d\u043d\u044b\u043c\u0438");
        JPanel buttonsRow = new JPanel(new FlowLayout(0, 10, 0));
        buttonsRow.setOpaque(false);
        buttonsRow.setAlignmentX(0.0f);
        buttonsRow.setMaximumSize(new Dimension(Integer.MAX_VALUE, 45));
        ModernButton openFolderBtn = new ModernButton("\u041e\u0442\u043a\u0440\u044b\u0442\u044c \u043f\u0430\u043f\u043a\u0443", ModernButton.ButtonType.SECONDARY);
        openFolderBtn.setPreferredSize(new Dimension(140, 38));
        openFolderBtn.addActionListener(e -> this.openLauncherFolder());
        buttonsRow.add(openFolderBtn);
        ModernButton deleteClientsBtn = new ModernButton("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043a\u043b\u0438\u0435\u043d\u0442\u044b", ModernButton.ButtonType.SECONDARY);
        deleteClientsBtn.setPreferredSize(new Dimension(150, 38));
        deleteClientsBtn.addActionListener(e -> this.deleteClients());
        buttonsRow.add(deleteClientsBtn);
        ModernButton clearCacheBtn = new ModernButton("\u041e\u0447\u0438\u0441\u0442\u0438\u0442\u044c \u043a\u044d\u0448", ModernButton.ButtonType.SECONDARY);
        clearCacheBtn.setPreferredSize(new Dimension(140, 38));
        clearCacheBtn.addActionListener(e -> this.clearCache());
        buttonsRow.add(clearCacheBtn);
        dataPanel.add(buttonsRow);
        dataPanel.add(Box.createVerticalStrut(10));
        JLabel dataHintLabel = new JLabel("\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0434\u0430\u043d\u043d\u044b\u0445 \u043d\u0435\u043e\u0431\u0440\u0430\u0442\u0438\u043c\u043e! \u0411\u0443\u0434\u0435\u0442 \u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0435\u043d\u043e \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435.");
        dataHintLabel.setFont(Theme.FONT_SMALL);
        dataHintLabel.setForeground(Theme.TEXT_SECONDARY);
        dataHintLabel.setAlignmentX(0.0f);
        dataPanel.add(dataHintLabel);
        panel.add(dataPanel);
        panel.add(Box.createVerticalGlue());
        return panel;
    }

    private void openLauncherFolder() {
        try {
            File workDir = MineZoneLauncher.getInstance().getWorkDir();
            if (workDir.exists()) {
                Desktop.getDesktop().open(workDir);
                LogHelper.info("Opened launcher folder: " + workDir.getAbsolutePath());
            } else {
                ConfirmDialog.showError(this.mainFrame, "\u041e\u0448\u0438\u0431\u043a\u0430", "\u041f\u0430\u043f\u043a\u0430 \u043b\u0430\u0443\u043d\u0447\u0435\u0440\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430!");
            }
        }
        catch (Exception e) {
            LogHelper.error("Failed to open launcher folder", e);
            ConfirmDialog.showError(this.mainFrame, "\u041e\u0448\u0438\u0431\u043a\u0430", "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u0442\u043a\u0440\u044b\u0442\u044c \u043f\u0430\u043f\u043a\u0443:\n" + e.getMessage());
        }
    }

    private void deleteClients() {
        boolean confirm = ConfirmDialog.showWarningConfirm(this.mainFrame, "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043a\u043b\u0438\u0435\u043d\u0442\u043e\u0432", "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0412\u0421\u0415 \u043a\u043b\u0438\u0435\u043d\u0442\u044b?\n\n\u0411\u0443\u0434\u0443\u0442 \u0443\u0434\u0430\u043b\u0435\u043d\u044b:\n- \u0412\u0441\u0435 \u0441\u043a\u0430\u0447\u0430\u043d\u043d\u044b\u0435 \u043a\u043b\u0438\u0435\u043d\u0442\u044b \u0438\u0433\u0440\u044b\n- \u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u043c\u043e\u0434\u043e\u0432\n- \u041b\u043e\u043a\u0430\u043b\u044c\u043d\u044b\u0435 \u043c\u0438\u0440\u044b (\u0435\u0441\u043b\u0438 \u0435\u0441\u0442\u044c)\n\nAssets \u0438 Java \u0431\u0443\u0434\u0443\u0442 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u044b.");
        if (confirm) {
            try {
                File workDir = MineZoneLauncher.getInstance().getWorkDir();
                File clientsDir = new File(workDir, "clients");
                if (clientsDir.exists()) {
                    File[] clients = clientsDir.listFiles();
                    if (clients != null) {
                        int deleted = 0;
                        long freedSpace = 0L;
                        for (File client : clients) {
                            String name = client.getName().toLowerCase();
                            if (name.startsWith("assets") || name.startsWith("jre")) continue;
                            freedSpace += this.getFolderSize(client);
                            if (!this.deleteRecursive(client)) continue;
                            ++deleted;
                        }
                        ConfirmDialog.showInfo(this.mainFrame, "\u0423\u0441\u043f\u0435\u0448\u043d\u043e", "\u0423\u0434\u0430\u043b\u0435\u043d\u043e \u043a\u043b\u0438\u0435\u043d\u0442\u043e\u0432: " + deleted + "\n\u041e\u0441\u0432\u043e\u0431\u043e\u0436\u0434\u0435\u043d\u043e: " + this.formatSize(freedSpace) + "\n\nAssets \u0438 Java \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u044b.");
                        LogHelper.info("Deleted " + deleted + " clients, freed: " + this.formatSize(freedSpace));
                    }
                } else {
                    ConfirmDialog.showInfo(this.mainFrame, "\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f", "\u041f\u0430\u043f\u043a\u0430 \u043a\u043b\u0438\u0435\u043d\u0442\u043e\u0432 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430.");
                }
            }
            catch (Exception e) {
                LogHelper.error("Failed to delete clients", e);
                ConfirmDialog.showError(this.mainFrame, "\u041e\u0448\u0438\u0431\u043a\u0430", "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0438:\n" + e.getMessage());
            }
        }
    }

    private void clearCache() {
        boolean finalConfirm;
        boolean confirm = ConfirmDialog.showWarningConfirm(this.mainFrame, "\u041f\u043e\u043b\u043d\u0430\u044f \u043e\u0447\u0438\u0441\u0442\u043a\u0430", "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u043e\u0447\u0438\u0441\u0442\u0438\u0442\u044c \u0412\u0415\u0421\u042c \u043a\u044d\u0448?\n\n\u0411\u0443\u0434\u0443\u0442 \u0443\u0434\u0430\u043b\u0435\u043d\u044b:\n- \u0412\u0441\u0435 \u043a\u043b\u0438\u0435\u043d\u0442\u044b \u0438\u0433\u0440\u044b\n- Assets (\u0437\u0432\u0443\u043a\u0438, \u0442\u0435\u043a\u0441\u0442\u0443\u0440\u044b)\n- \u0421\u043a\u0430\u0447\u0430\u043d\u043d\u0430\u044f Java\n\n\u0412\u0421\u0401 \u043f\u0440\u0438\u0434\u0451\u0442\u0441\u044f \u0441\u043a\u0430\u0447\u0438\u0432\u0430\u0442\u044c \u0437\u0430\u043d\u043e\u0432\u043e!");
        if (confirm && (finalConfirm = ConfirmDialog.showWarningConfirm(this.mainFrame, "\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0435 \u043f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435", "\u0422\u041e\u0427\u041d\u041e \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0412\u0421\u0401?\n\n\u042d\u0442\u043e \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0435 \u043d\u0435\u043b\u044c\u0437\u044f \u043e\u0442\u043c\u0435\u043d\u0438\u0442\u044c!"))) {
            try {
                File logsDir;
                File workDir = MineZoneLauncher.getInstance().getWorkDir();
                File clientsDir = new File(workDir, "clients");
                long freedSpace = 0L;
                if (clientsDir.exists()) {
                    freedSpace = this.getFolderSize(clientsDir);
                    this.deleteRecursive(clientsDir);
                }
                if ((logsDir = new File(workDir, "logs")).exists()) {
                    freedSpace += this.getFolderSize(logsDir);
                    this.deleteRecursive(logsDir);
                }
                ConfirmDialog.showInfo(this.mainFrame, "\u0423\u0441\u043f\u0435\u0448\u043d\u043e", "\u041a\u044d\u0448 \u043e\u0447\u0438\u0449\u0435\u043d!\n\n\u041e\u0441\u0432\u043e\u0431\u043e\u0436\u0434\u0435\u043d\u043e: " + this.formatSize(freedSpace) + "\n\n\u041f\u0440\u0438 \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0435\u043c \u0437\u0430\u043f\u0443\u0441\u043a\u0435 \u0438\u0433\u0440\u044b \u0432\u0441\u0451 \u0431\u0443\u0434\u0435\u0442 \u0441\u043a\u0430\u0447\u0430\u043d\u043e \u0437\u0430\u043d\u043e\u0432\u043e.");
                LogHelper.info("Cache cleared, freed: " + this.formatSize(freedSpace));
            }
            catch (Exception e) {
                LogHelper.error("Failed to clear cache", e);
                ConfirmDialog.showError(this.mainFrame, "\u041e\u0448\u0438\u0431\u043a\u0430", "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0447\u0438\u0441\u0442\u043a\u0435:\n" + e.getMessage());
            }
        }
    }

    private boolean deleteRecursive(File file) {
        File[] children;
        if (file.isDirectory() && (children = file.listFiles()) != null) {
            for (File child : children) {
                this.deleteRecursive(child);
            }
        }
        return file.delete();
    }

    private long getFolderSize(File folder) {
        long size = 0L;
        if (folder.isDirectory()) {
            File[] files = folder.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (file.isFile()) {
                        size += file.length();
                        continue;
                    }
                    size += this.getFolderSize(file);
                }
            }
        } else {
            size = folder.length();
        }
        return size;
    }

    private String formatSize(long bytes) {
        if (bytes < 1024L) {
            return bytes + " B";
        }
        if (bytes < 0x100000L) {
            return String.format("%.1f KB", (double)bytes / 1024.0);
        }
        if (bytes < 0x40000000L) {
            return String.format("%.1f MB", (double)bytes / 1048576.0);
        }
        return String.format("%.2f GB", (double)bytes / 1.073741824E9);
    }

    private JPanel createSectionPanel(String title) {
        JPanel panel = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setColor(new Color(25, 30, 40, 200));
                g2d.fill(new RoundRectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight(), 15.0, 15.0));
                g2d.dispose();
            }
        };
        panel.setOpaque(false);
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createEmptyBorder(20, 25, 20, 25));
        panel.setAlignmentX(0.0f);
        panel.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        JLabel titleLabel = new JLabel(title);
        titleLabel.setFont(Theme.FONT_SUBTITLE);
        titleLabel.setForeground(Theme.ACCENT_PRIMARY);
        titleLabel.setAlignmentX(0.0f);
        panel.add(titleLabel);
        panel.add(Box.createVerticalStrut(15));
        return panel;
    }

    private JPanel createButtonsPanel() {
        JPanel panel = new JPanel(new FlowLayout(1, 20, 0));
        panel.setOpaque(false);
        ModernButton saveButton = new ModernButton("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c", ModernButton.ButtonType.PRIMARY);
        saveButton.setPreferredSize(new Dimension(180, 50));
        saveButton.addActionListener(e -> {
            this.saveSettings();
            ConfirmDialog.showInfo(this.mainFrame, "\u0423\u0441\u043f\u0435\u0448\u043d\u043e", "\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u044b!");
        });
        panel.add(saveButton);
        return panel;
    }

    private void loadSettings() {
        int savedRam = this.config.getInt("ram.max", this.getDefaultRam());
        this.ramSlider.setValue(savedRam);
        this.ramValueLabel.setText(savedRam + " MB");
        this.ramHintLabel.setText(this.getRamHint(savedRam));
        this.ramHintLabel.setForeground(this.getRamHintColor(savedRam));
        this.fullscreenCheckbox.setSelected(this.config.getBoolean("fullscreen", false));
        this.hideLauncherCheckbox.setSelected(this.config.getBoolean("hide.launcher", true));
    }

    private void saveSettings() {
        int ram = this.ramSlider.getValue();
        int minRam = Math.max(512, ram / 2);
        this.config.set("ram.min", String.valueOf(minRam));
        this.config.set("ram.max", String.valueOf(ram));
        this.config.set("fullscreen", String.valueOf(this.fullscreenCheckbox.isSelected()));
        this.config.set("hide.launcher", String.valueOf(this.hideLauncherCheckbox.isSelected()));
        this.config.save();
    }
}

