/*
 * Decompiled with CFR 0.152.
 */
package ru.minezone.launcher.gui;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import ru.minezone.launcher.MineZoneLauncher;
import ru.minezone.launcher.client.ClientLauncher;
import ru.minezone.launcher.client.ClientProfile;
import ru.minezone.launcher.download.DownloadManager;
import ru.minezone.launcher.gui.MainFrame;
import ru.minezone.launcher.gui.Theme;
import ru.minezone.launcher.gui.components.ModernButton;
import ru.minezone.launcher.gui.components.ModernProgressBar;
import ru.minezone.launcher.gui.components.ModsDialog;
import ru.minezone.launcher.gui.components.RadialMenuButton;
import ru.minezone.launcher.gui.components.ServerCard;
import ru.minezone.launcher.gui.components.ServerOfflineDialog;
import ru.minezone.launcher.gui.components.SnowfallPanel;
import ru.minezone.launcher.gui.components.VoteDialog;
import ru.minezone.launcher.security.ClientIntegrityChecker;
import ru.minezone.launcher.utils.Config;
import ru.minezone.launcher.utils.LogHelper;

public class MainPanel
extends JPanel {
    private MainFrame mainFrame;
    private String username;
    private String sessionId;
    private String accessToken;
    private String uuid;
    private String skinUrl;
    private JLabel playerNameLabel;
    private JLabel avatarLabel;
    private JPanel serversPanel;
    private List<ServerCard> serverCards;
    private ClientProfile selectedProfile;
    private ModernButton playButton;
    private ModernProgressBar progressBar;
    private JLabel statusLabel;
    private JLabel speedLabel;
    private SnowfallPanel snowfallPanel;
    private DownloadManager downloadManager;
    private ClientLauncher currentLauncher;
    private ClientIntegrityChecker integrityChecker;
    private volatile boolean isDownloading = false;
    private volatile boolean isLaunching = false;
    private BufferedImage skinHead;

    public MainPanel(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
        this.serverCards = new ArrayList<ServerCard>();
        this.downloadManager = new DownloadManager();
        this.init();
    }

    private void init() {
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.snowfallPanel = new SnowfallPanel();
        this.snowfallPanel.setLayout(new BorderLayout(20, 20));
        this.snowfallPanel.setBorder(BorderFactory.createEmptyBorder(20, 30, 30, 30));
        JPanel topPanel = this.createTopPanel();
        this.snowfallPanel.add((Component)topPanel, "North");
        JPanel centerPanel = this.createCenterPanel();
        this.snowfallPanel.add((Component)centerPanel, "Center");
        JPanel bottomPanel = this.createBottomPanel();
        this.snowfallPanel.add((Component)bottomPanel, "South");
        this.add((Component)this.snowfallPanel, "Center");
    }

    private JPanel createTopPanel() {
        JPanel panel = new JPanel(new BorderLayout(20, 0)){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setColor(new Color(15, 23, 42, 180));
                g2d.fill(new RoundRectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight(), 15.0, 15.0));
                g2d.dispose();
            }
        };
        panel.setOpaque(false);
        panel.setBorder(BorderFactory.createEmptyBorder(15, 20, 15, 20));
        JPanel profilePanel = new JPanel(new FlowLayout(0, 15, 0));
        profilePanel.setOpaque(false);
        this.avatarLabel = new JLabel(){

            @Override
            protected void paintComponent(Graphics g) {
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                g2d.setColor(Theme.ACCENT_GLOW);
                g2d.fillOval(-5, -5, 60, 60);
                if (MainPanel.this.skinHead != null) {
                    g2d.setClip(new Ellipse2D.Double(0.0, 0.0, 50.0, 50.0));
                    g2d.drawImage(MainPanel.this.skinHead, 0, 0, 50, 50, null);
                    g2d.setClip(null);
                    g2d.setColor(Theme.ACCENT_PRIMARY);
                    g2d.setStroke(new BasicStroke(2.0f));
                    g2d.drawOval(0, 0, 50, 50);
                } else {
                    GradientPaint gradient = new GradientPaint(0.0f, 0.0f, Theme.ACCENT_PRIMARY, 50.0f, 50.0f, Theme.ACCENT_SECONDARY);
                    g2d.setPaint(gradient);
                    g2d.fillOval(0, 0, 50, 50);
                    g2d.setColor(Color.WHITE);
                    g2d.setFont(new Font("Segoe UI", 1, 20));
                    String initial = MainPanel.this.username != null ? MainPanel.this.username.substring(0, 1).toUpperCase() : "?";
                    FontMetrics fm = g2d.getFontMetrics();
                    int x = (50 - fm.stringWidth(initial)) / 2;
                    int y = (50 + fm.getAscent() - fm.getDescent()) / 2;
                    g2d.drawString(initial, x, y);
                }
                g2d.dispose();
            }
        };
        this.avatarLabel.setPreferredSize(new Dimension(50, 50));
        profilePanel.add(this.avatarLabel);
        JPanel namePanel = new JPanel();
        namePanel.setOpaque(false);
        namePanel.setLayout(new BoxLayout(namePanel, 1));
        this.playerNameLabel = new JLabel("\u0418\u0433\u0440\u043e\u043a");
        this.playerNameLabel.setFont(Theme.FONT_SUBTITLE);
        this.playerNameLabel.setForeground(Theme.TEXT_PRIMARY);
        namePanel.add(this.playerNameLabel);
        JLabel statusOnline = new JLabel("\u2022 \u0412 \u0441\u0435\u0442\u0438");
        statusOnline.setFont(Theme.FONT_SMALL);
        statusOnline.setForeground(Theme.ONLINE);
        namePanel.add(statusOnline);
        profilePanel.add(namePanel);
        panel.add((Component)profilePanel, "West");
        RadialMenuButton radialMenu = new RadialMenuButton();
        JPanel centerPanel = new JPanel(new FlowLayout(1, 0, 0));
        centerPanel.setOpaque(false);
        centerPanel.add(radialMenu);
        panel.add((Component)centerPanel, "Center");
        JPanel buttonsPanel = new JPanel(new FlowLayout(2, 10, 0));
        buttonsPanel.setOpaque(false);
        ModernButton settingsBtn = new ModernButton("", ModernButton.ButtonType.GHOST){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setColor(this.getForeground());
                int cx = this.getWidth() / 2;
                int cy = this.getHeight() / 2;
                g2d.setStroke(new BasicStroke(2.0f));
                g2d.drawOval(cx - 6, cy - 6, 12, 12);
                for (int i = 0; i < 8; ++i) {
                    double angle = 0.7853981633974483 * (double)i;
                    int x1 = cx + (int)(Math.cos(angle) * 6.0);
                    int y1 = cy + (int)(Math.sin(angle) * 6.0);
                    int x2 = cx + (int)(Math.cos(angle) * 10.0);
                    int y2 = cy + (int)(Math.sin(angle) * 10.0);
                    g2d.drawLine(x1, y1, x2, y2);
                }
                g2d.dispose();
            }
        };
        settingsBtn.setPreferredSize(new Dimension(45, 45));
        settingsBtn.setForeground(Theme.TEXT_SECONDARY);
        settingsBtn.addActionListener(e -> this.mainFrame.showPanel("settings"));
        buttonsPanel.add(settingsBtn);
        ModernButton logoutBtn = new ModernButton("", ModernButton.ButtonType.GHOST){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setColor(this.getForeground());
                g2d.setStroke(new BasicStroke(2.5f));
                int cx = this.getWidth() / 2;
                int cy = this.getHeight() / 2;
                g2d.drawLine(cx + 5, cy, cx - 8, cy);
                g2d.drawLine(cx - 8, cy, cx - 3, cy - 5);
                g2d.drawLine(cx - 8, cy, cx - 3, cy + 5);
                g2d.drawLine(cx + 5, cy - 8, cx + 5, cy + 8);
                g2d.dispose();
            }
        };
        logoutBtn.setPreferredSize(new Dimension(45, 45));
        logoutBtn.setForeground(Theme.TEXT_SECONDARY);
        logoutBtn.addActionListener(e -> {
            if (this.isDownloading) {
                this.downloadManager.cancel();
            }
            this.mainFrame.showPanel("login");
        });
        buttonsPanel.add(logoutBtn);
        panel.add((Component)buttonsPanel, "East");
        return panel;
    }

    private JPanel createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout(0, 20));
        panel.setOpaque(false);
        JPanel headerPanel = new JPanel(new BorderLayout());
        headerPanel.setOpaque(false);
        JLabel titleLabel = new JLabel("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0435\u0440\u0432\u0435\u0440");
        titleLabel.setFont(Theme.FONT_TITLE);
        titleLabel.setForeground(Theme.TEXT_PRIMARY);
        headerPanel.add((Component)titleLabel, "West");
        JLabel subtitleLabel = new JLabel("\u0417\u0438\u043c\u043d\u0438\u0439 \u0441\u0435\u0437\u043e\u043d 2026");
        subtitleLabel.setFont(Theme.FONT_REGULAR);
        subtitleLabel.setForeground(Theme.ACCENT_PRIMARY);
        headerPanel.add((Component)subtitleLabel, "East");
        panel.add((Component)headerPanel, "North");
        this.serversPanel = new JPanel(new GridLayout(1, 2, 20, 0));
        this.serversPanel.setOpaque(false);
        this.loadServers();
        panel.add((Component)this.serversPanel, "Center");
        return panel;
    }

    private JPanel createBottomPanel() {
        JPanel panel = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setColor(new Color(15, 23, 42, 180));
                g2d.fill(new RoundRectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight(), 15.0, 15.0));
                g2d.dispose();
            }
        };
        panel.setOpaque(false);
        panel.setLayout(new BorderLayout(15, 10));
        panel.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        JPanel statusPanel = new JPanel();
        statusPanel.setOpaque(false);
        statusPanel.setLayout(new BoxLayout(statusPanel, 1));
        this.statusLabel = new JLabel("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0435\u0440\u0432\u0435\u0440 \u0434\u043b\u044f \u0438\u0433\u0440\u044b");
        this.statusLabel.setFont(Theme.FONT_REGULAR);
        this.statusLabel.setForeground(Theme.TEXT_SECONDARY);
        this.statusLabel.setAlignmentX(0.0f);
        statusPanel.add(this.statusLabel);
        statusPanel.add(Box.createVerticalStrut(3));
        this.speedLabel = new JLabel(" ");
        this.speedLabel.setFont(new Font("Segoe UI", 1, 13));
        this.speedLabel.setForeground(Theme.ACCENT_PRIMARY);
        this.speedLabel.setAlignmentX(0.0f);
        statusPanel.add(this.speedLabel);
        statusPanel.add(Box.createVerticalStrut(3));
        this.progressBar = new ModernProgressBar();
        this.progressBar.setAlignmentX(0.0f);
        this.progressBar.setMaximumSize(new Dimension(Integer.MAX_VALUE, 25));
        this.progressBar.setVisible(false);
        statusPanel.add(this.progressBar);
        panel.add((Component)statusPanel, "Center");
        this.playButton = new ModernButton("\u0418\u0413\u0420\u0410\u0422\u042c", ModernButton.ButtonType.PRIMARY){

            @Override
            protected void paintComponent(Graphics g) {
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                int width = this.getWidth();
                int height = this.getHeight();
                GradientPaint gradient = new GradientPaint(0.0f, 0.0f, this.isEnabled() ? Theme.ACCENT_PRIMARY : Theme.TEXT_DISABLED, width, height, this.isEnabled() ? Theme.ACCENT_SECONDARY : Theme.TEXT_DISABLED);
                g2d.setPaint(gradient);
                g2d.fill(new RoundRectangle2D.Double(0.0, 0.0, width, height, 12.0, 12.0));
                if (this.isEnabled()) {
                    g2d.setComposite(AlphaComposite.getInstance(3, 0.2f));
                    g2d.setColor(Color.WHITE);
                    g2d.fill(new RoundRectangle2D.Double(0.0, 0.0, width, height / 2, 12.0, 12.0));
                    g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
                }
                g2d.setFont(this.getFont());
                g2d.setColor(Color.WHITE);
                FontMetrics fm = g2d.getFontMetrics();
                int textX = (width - fm.stringWidth(this.getText())) / 2;
                int textY = (height + fm.getAscent() - fm.getDescent()) / 2;
                g2d.drawString(this.getText(), textX, textY);
                g2d.dispose();
            }
        };
        this.playButton.setPreferredSize(new Dimension(160, 55));
        this.playButton.setFont(new Font("Segoe UI", 1, 16));
        this.playButton.addActionListener(e -> this.startGame());
        this.playButton.setEnabled(false);
        panel.add((Component)this.playButton, "East");
        return panel;
    }

    private void loadServers() {
        ClientProfile hitech = new ClientProfile("HiTech", "1.7.10", "\u0418\u043d\u0434\u0443\u0441\u0442\u0440\u0438\u0430\u043b\u044c\u043d\u044b\u0439 \u0441\u0435\u0440\u0432\u0435\u0440 \u0441 \u0442\u0435\u0445\u043d\u0438\u0447\u0435\u0441\u043a\u0438\u043c\u0438 \u043c\u043e\u0434\u0430\u043c\u0438", 45, "HiTech", "minezone.su", 25565);
        hitech.setOnline(42);
        ClientProfile magic = new ClientProfile("TechnoMagic", "1.12.2", "\u041c\u0430\u0433\u0438\u0447\u0435\u0441\u043a\u0438\u0435 \u0438 \u0442\u0435\u0445\u043d\u0438\u0447\u0435\u0441\u043a\u0438\u0435 \u043c\u043e\u0434\u044b \u0432 \u043e\u0434\u043d\u043e\u0439 \u0441\u0431\u043e\u0440\u043a\u0435", 78, "TechnoMagic", "minezone.su", 25566);
        magic.setOnline(67);
        this.addServerCard(hitech);
        this.addServerCard(magic);
    }

    private void addServerCard(ClientProfile profile) {
        ServerCard card = new ServerCard(profile);
        card.addSelectListener(e -> this.selectServer(card));
        this.serverCards.add(card);
        this.serversPanel.add(card);
    }

    private void selectServer(ServerCard selectedCard) {
        if (this.isDownloading || this.isLaunching) {
            return;
        }
        for (ServerCard card : this.serverCards) {
            card.setSelected(false);
        }
        selectedCard.setSelected(true);
        this.selectedProfile = selectedCard.getProfile();
        this.statusLabel.setText("\u0412\u044b\u0431\u0440\u0430\u043d \u0441\u0435\u0440\u0432\u0435\u0440: " + this.selectedProfile.getTitle());
        this.playButton.setEnabled(true);
        this.playButton.setText("\u0418\u0413\u0420\u0410\u0422\u042c");
        MineZoneLauncher.getInstance().getConfig().set("last.server", this.selectedProfile.getTitle());
        LogHelper.info("Selected server: " + this.selectedProfile.getTitle());
    }

    public void setPlayerData(String username, String sessionId, String accessToken, String uuid, String skinUrl) {
        this.username = username;
        this.sessionId = sessionId;
        this.accessToken = accessToken;
        this.uuid = uuid;
        this.skinUrl = skinUrl;
        this.playerNameLabel.setText(username);
        this.loadSkinHead();
        SwingUtilities.invokeLater(() -> {
            if (VoteDialog.shouldShow(username)) {
                VoteDialog dialog = new VoteDialog(this.mainFrame, MineZoneLauncher.getInstance().getConfig());
                dialog.setOnVoteClick(() -> VoteDialog.markVoted(username));
                dialog.setVisible(true);
            }
        });
    }

    public void setPlayerData(String username, String sessionId, String skinUrl) {
        this.setPlayerData(username, sessionId, null, null, skinUrl);
    }

    private void loadSkinHead() {
        if (this.username == null) {
            return;
        }
        new SwingWorker<BufferedImage, Void>(){

            @Override
            protected BufferedImage doInBackground() {
                try {
                    String skinUrl = "https://minezone.su/skins/" + MainPanel.this.username + ".png";
                    LogHelper.info("Loading skin from: " + skinUrl);
                    URL url = new URL(skinUrl);
                    BufferedImage fullSkin = ImageIO.read(url);
                    if (fullSkin != null) {
                        BufferedImage head = fullSkin.getSubimage(8, 8, 8, 8);
                        BufferedImage scaledHead = new BufferedImage(64, 64, 2);
                        Graphics2D g = scaledHead.createGraphics();
                        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                        g.drawImage(head, 0, 0, 64, 64, null);
                        if (fullSkin.getWidth() >= 64 && fullSkin.getHeight() >= 16) {
                            BufferedImage overlay = fullSkin.getSubimage(40, 8, 8, 8);
                            g.drawImage(overlay, 0, 0, 64, 64, null);
                        }
                        g.dispose();
                        return scaledHead;
                    }
                }
                catch (Exception e) {
                    LogHelper.warning("Failed to load skin: " + e.getMessage());
                }
                return null;
            }

            @Override
            protected void done() {
                try {
                    MainPanel.this.skinHead = (BufferedImage)this.get();
                    MainPanel.this.avatarLabel.repaint();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.execute();
    }

    private void startGame() {
        boolean proceed;
        if (this.selectedProfile == null) {
            this.statusLabel.setText("\u0421\u043d\u0430\u0447\u0430\u043b\u0430 \u0432\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0435\u0440\u0432\u0435\u0440!");
            return;
        }
        if (this.isDownloading || this.isLaunching) {
            return;
        }
        ServerCard selectedCard = null;
        for (ServerCard card : this.serverCards) {
            if (card.getProfile() != this.selectedProfile) continue;
            selectedCard = card;
            break;
        }
        if (selectedCard != null && !selectedCard.isServerOnline() && !(proceed = ServerOfflineDialog.show(this.mainFrame, this.selectedProfile.getTitle()))) {
            this.statusLabel.setText("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u0440\u0443\u0433\u043e\u0439 \u0441\u0435\u0440\u0432\u0435\u0440");
            return;
        }
        this.isDownloading = true;
        this.progressBar.setVisible(true);
        this.progressBar.setValue(0);
        this.playButton.setEnabled(false);
        this.playButton.setText("\u0417\u0410\u0413\u0420\u0423\u0417\u041a\u0410...");
        for (ServerCard card : this.serverCards) {
            card.setEnabled(false);
        }
        new SwingWorker<Boolean, DownloadManager.DownloadProgress>(){

            @Override
            protected Boolean doInBackground() {
                return MainPanel.this.downloadManager.downloadClient(MainPanel.this.selectedProfile, progress -> this.publish(progress));
            }

            @Override
            protected void process(List<DownloadManager.DownloadProgress> chunks) {
                if (!chunks.isEmpty()) {
                    DownloadManager.DownloadProgress progress = chunks.get(chunks.size() - 1);
                    String status = progress.status;
                    if (status.length() > 50) {
                        int colonPos = status.lastIndexOf(": ");
                        if (colonPos > 0) {
                            String prefix = status.substring(0, colonPos + 2);
                            String fileName = status.substring(colonPos + 2);
                            if (fileName.length() > 35) {
                                fileName = fileName.substring(0, 32) + "...";
                            }
                            status = prefix + fileName;
                        } else if (status.length() > 50) {
                            status = status.substring(0, 47) + "...";
                        }
                    }
                    MainPanel.this.statusLabel.setText(status);
                    String speedStr = progress.getFormattedSpeed();
                    if (!speedStr.isEmpty()) {
                        MainPanel.this.speedLabel.setText(speedStr);
                    }
                    MainPanel.this.progressBar.setValue(progress.percent);
                    if (progress.totalFiles > 0) {
                        MainPanel.this.progressBar.setStatusText(progress.currentFile + "/" + progress.totalFiles);
                    }
                }
            }

            @Override
            protected void done() {
                MainPanel.this.isDownloading = false;
                MainPanel.this.speedLabel.setText(" ");
                try {
                    boolean success = (Boolean)this.get();
                    if (success) {
                        MainPanel.this.showModsDialogAndLaunch();
                    } else {
                        MainPanel.this.statusLabel.setText("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u043a\u043b\u0438\u0435\u043d\u0442\u0430");
                        MainPanel.this.resetUI();
                    }
                }
                catch (Exception e) {
                    LogHelper.error("Download error", e);
                    MainPanel.this.statusLabel.setText("\u041e\u0448\u0438\u0431\u043a\u0430: " + e.getMessage());
                    MainPanel.this.resetUI();
                }
            }
        }.execute();
    }

    private void showModsDialogAndLaunch() {
        ModsDialog modsDialog;
        boolean confirmed;
        File clientDir = this.selectedProfile.getClientDir();
        File modsDir = new File(clientDir, "mods");
        File optionalDir = new File(modsDir, "optional");
        if (!optionalDir.exists()) {
            optionalDir.mkdirs();
        }
        if (!(confirmed = (modsDialog = new ModsDialog((Frame)this.mainFrame, modsDir)).showDialog())) {
            this.statusLabel.setText("\u0417\u0430\u043f\u0443\u0441\u043a \u043e\u0442\u043c\u0435\u043d\u0451\u043d");
            this.resetUI();
            return;
        }
        modsDialog.applyChanges(modsDir);
        this.launchGame();
    }

    private void launchGame() {
        this.isLaunching = true;
        this.statusLabel.setText("\u0417\u0430\u043f\u0443\u0441\u043a \u0438\u0433\u0440\u044b...");
        this.progressBar.setValue(100);
        this.progressBar.setStatusText("\u0417\u0430\u043f\u0443\u0441\u043a");
        this.playButton.setText("\u0417\u0410\u041f\u0423\u0421\u041a...");
        new SwingWorker<Boolean, String>(){

            @Override
            protected Boolean doInBackground() {
                File clientDir = MainPanel.this.selectedProfile.getClientDir();
                MainPanel.this.integrityChecker = new ClientIntegrityChecker(clientDir, MainPanel.this.selectedProfile);
                MainPanel.this.integrityChecker.initialize();
                this.publish("\u0417\u0430\u043f\u0443\u0441\u043a \u0438\u0433\u0440\u044b...");
                MainPanel.this.currentLauncher = MainPanel.this.selectedProfile.createLauncher(MainPanel.this.username, MainPanel.this.accessToken, MainPanel.this.uuid);
                return MainPanel.this.currentLauncher.launch();
            }

            @Override
            protected void process(List<String> chunks) {
                if (!chunks.isEmpty()) {
                    MainPanel.this.statusLabel.setText(chunks.get(chunks.size() - 1));
                }
            }

            @Override
            protected void done() {
                MainPanel.this.isLaunching = false;
                try {
                    boolean success = (Boolean)this.get();
                    if (success) {
                        Process gameProcess;
                        MainPanel.this.statusLabel.setText("\u0418\u0433\u0440\u0430 \u0437\u0430\u043f\u0443\u0449\u0435\u043d\u0430! \u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0444\u0430\u0439\u043b\u043e\u0432...");
                        MainPanel.this.playButton.setText("\u0418\u0413\u0420\u0410\u0415\u0422...");
                        Config config = MineZoneLauncher.getInstance().getConfig();
                        if (config.getBoolean("hide.launcher", true)) {
                            MainPanel.this.mainFrame.setVisible(false);
                        }
                        if ((gameProcess = MainPanel.this.currentLauncher.getGameProcess()) != null && MainPanel.this.integrityChecker != null) {
                            MainPanel.this.integrityChecker.startMonitoring(gameProcess, deletedFile -> LogHelper.warning("Deleted illegal mod: " + deletedFile));
                        }
                        new Thread(() -> {
                            try {
                                MainPanel.this.currentLauncher.waitFor();
                                if (MainPanel.this.integrityChecker != null) {
                                    MainPanel.this.integrityChecker.stopMonitoring();
                                    List<String> deleted = MainPanel.this.integrityChecker.getDeletedFiles();
                                    if (!deleted.isEmpty()) {
                                        SwingUtilities.invokeLater(() -> {
                                            StringBuilder msg = new StringBuilder("\u0412\u043e \u0432\u0440\u0435\u043c\u044f \u0438\u0433\u0440\u044b \u0431\u044b\u043b\u0438 \u0443\u0434\u0430\u043b\u0435\u043d\u044b \u043f\u043e\u0434\u043b\u043e\u0436\u0435\u043d\u043d\u044b\u0435 \u043c\u043e\u0434\u044b:\n\n");
                                            for (String f : deleted) {
                                                msg.append("\u2022 ").append(f).append("\n");
                                            }
                                            JOptionPane.showMessageDialog(MainPanel.this.mainFrame, msg.toString(), "\u0423\u0434\u0430\u043b\u0435\u043d\u044b \u043f\u043e\u0434\u043b\u043e\u0436\u0435\u043d\u043d\u044b\u0435 \u0444\u0430\u0439\u043b\u044b", 2);
                                        });
                                    }
                                }
                                SwingUtilities.invokeLater(() -> {
                                    MainPanel.this.mainFrame.setVisible(true);
                                    MainPanel.this.resetUI();
                                    MainPanel.this.statusLabel.setText("\u0418\u0433\u0440\u0430 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430");
                                    for (ServerCard card : MainPanel.this.serverCards) {
                                        card.refreshModsCount();
                                    }
                                });
                            }
                            catch (Exception e) {
                                LogHelper.error("Error waiting for game", e);
                            }
                        }).start();
                    } else {
                        MainPanel.this.statusLabel.setText("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u043f\u0443\u0441\u043a\u0430 \u0438\u0433\u0440\u044b");
                        MainPanel.this.resetUI();
                    }
                }
                catch (Exception e) {
                    LogHelper.error("Launch error", e);
                    MainPanel.this.statusLabel.setText("\u041e\u0448\u0438\u0431\u043a\u0430: " + e.getMessage());
                    MainPanel.this.resetUI();
                }
            }
        }.execute();
    }

    private void resetUI() {
        this.progressBar.setVisible(false);
        this.progressBar.setValue(0);
        this.playButton.setEnabled(this.selectedProfile != null);
        this.playButton.setText("\u0418\u0413\u0420\u0410\u0422\u042c");
        for (ServerCard card : this.serverCards) {
            card.setEnabled(true);
        }
    }
}

