/*
 * Decompiled with CFR 0.152.
 */
package ru.minezone.launcher.gui;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ru.minezone.launcher.MineZoneLauncher;
import ru.minezone.launcher.gui.LoginPanel;
import ru.minezone.launcher.gui.MainPanel;
import ru.minezone.launcher.gui.SettingsPanel;
import ru.minezone.launcher.gui.Theme;
import ru.minezone.launcher.utils.LogHelper;

public class MainFrame
extends JFrame {
    private static final int WIDTH = 1000;
    private static final int HEIGHT = 650;
    private JPanel contentPanel;
    private LoginPanel loginPanel;
    private MainPanel mainPanel;
    private SettingsPanel settingsPanel;
    private Point dragPoint;

    public MainFrame() {
        this.initFrame();
        this.initComponents();
    }

    private void initFrame() {
        this.setTitle("MineZone Launcher");
        this.setSize(1000, 650);
        this.setDefaultCloseOperation(3);
        this.setLocationRelativeTo(null);
        this.setUndecorated(true);
        this.setResizable(false);
        try {
            File iconFile;
            ArrayList<BufferedImage> icons = new ArrayList<BufferedImage>();
            InputStream iconStream = this.getClass().getResourceAsStream("/images/icon.png");
            if (iconStream != null) {
                icons.add(ImageIO.read(iconStream));
                iconStream.close();
            }
            if ((iconFile = new File("icon.png")).exists()) {
                icons.add(ImageIO.read(iconFile));
            }
            if ((iconFile = new File("icon.ico")).exists()) {
                icons.add(ImageIO.read(iconFile));
            }
            if (!icons.isEmpty()) {
                this.setIconImages(icons);
                LogHelper.info("Loaded application icon");
            }
        }
        catch (Exception e) {
            LogHelper.warning("Could not load icon: " + e.getMessage());
        }
        try {
            this.setShape(new RoundRectangle2D.Double(0.0, 0.0, 1000.0, 650.0, 20.0, 20.0));
        }
        catch (Exception e) {
            LogHelper.warning("Could not set rounded shape");
        }
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                MainFrame.this.dragPoint = e.getPoint();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                Point location = MainFrame.this.getLocation();
                MainFrame.this.setLocation(location.x + e.getX() - ((MainFrame)MainFrame.this).dragPoint.x, location.y + e.getY() - ((MainFrame)MainFrame.this).dragPoint.y);
            }
        });
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        JPanel mainContainer = new JPanel(new BorderLayout()){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                int width = this.getWidth();
                int height = this.getHeight();
                GradientPaint gradient = new GradientPaint(0.0f, 0.0f, new Color(15, 23, 42), 0.0f, height, new Color(30, 58, 95));
                g2d.setPaint(gradient);
                g2d.fillRect(0, 0, width, height);
                g2d.setComposite(AlphaComposite.getInstance(3, 0.1f));
                GradientPaint circle1 = new GradientPaint(-100.0f, -100.0f, new Color(56, 189, 248), 200.0f, 200.0f, new Color(56, 189, 248, 0));
                g2d.setPaint(circle1);
                g2d.fillOval(-150, -150, 400, 400);
                GradientPaint circle2 = new GradientPaint(width, height, new Color(59, 130, 246), width - 300, height - 300, new Color(59, 130, 246, 0));
                g2d.setPaint(circle2);
                g2d.fillOval(width - 300, height - 300, 500, 500);
                g2d.setComposite(AlphaComposite.getInstance(3, 0.05f));
                g2d.setColor(new Color(139, 92, 246));
                g2d.fillOval(width / 2 - 200, -100, 400, 400);
                g2d.dispose();
            }
        };
        mainContainer.setOpaque(false);
        JPanel headerPanel = this.createHeaderPanel();
        mainContainer.add((Component)headerPanel, "North");
        this.contentPanel = new JPanel(new CardLayout());
        this.contentPanel.setOpaque(false);
        this.loginPanel = new LoginPanel(this);
        this.mainPanel = new MainPanel(this);
        this.settingsPanel = new SettingsPanel(this);
        this.contentPanel.add((Component)this.loginPanel, "login");
        this.contentPanel.add((Component)this.mainPanel, "main");
        this.contentPanel.add((Component)this.settingsPanel, "settings");
        mainContainer.add((Component)this.contentPanel, "Center");
        this.add(mainContainer);
        this.showPanel("login");
    }

    private JPanel createHeaderPanel() {
        JPanel header = new JPanel(new BorderLayout()){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.setColor(new Color(0, 0, 0, 60));
                g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
                g2d.setColor(new Color(56, 189, 248, 30));
                g2d.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
                g2d.dispose();
            }
        };
        header.setOpaque(false);
        header.setPreferredSize(new Dimension(1000, 50));
        header.setBorder(BorderFactory.createEmptyBorder(10, 20, 10, 20));
        JPanel leftPanel = new JPanel(new FlowLayout(0, 10, 0));
        leftPanel.setOpaque(false);
        JLabel logoLabel = new JLabel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                int cx = 12;
                int cy = 12;
                g2d.setColor(Theme.ACCENT_PRIMARY);
                g2d.setStroke(new BasicStroke(2.0f, 1, 1));
                for (int i = 0; i < 6; ++i) {
                    double angle = 1.0471975511965976 * (double)i;
                    int len = 10;
                    int x2 = cx + (int)(Math.cos(angle) * (double)len);
                    int y2 = cy + (int)(Math.sin(angle) * (double)len);
                    g2d.drawLine(cx, cy, x2, y2);
                    int mx = cx + (int)(Math.cos(angle) * (double)len * 0.6);
                    int my = cy + (int)(Math.sin(angle) * (double)len * 0.6);
                    int blen = 4;
                    g2d.drawLine(mx, my, mx + (int)(Math.cos(angle + 0.6) * (double)blen), my + (int)(Math.sin(angle + 0.6) * (double)blen));
                    g2d.drawLine(mx, my, mx + (int)(Math.cos(angle - 0.6) * (double)blen), my + (int)(Math.sin(angle - 0.6) * (double)blen));
                }
                g2d.dispose();
            }

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(24, 24);
            }
        };
        JLabel titleLabel = new JLabel("MineZone");
        titleLabel.setFont(Theme.FONT_SUBTITLE);
        titleLabel.setForeground(Theme.TEXT_PRIMARY);
        JLabel versionLabel = new JLabel("v1.0.0");
        versionLabel.setFont(Theme.FONT_SMALL);
        versionLabel.setForeground(Theme.TEXT_SECONDARY);
        JLabel seasonLabel = new JLabel("Winter Edition");
        seasonLabel.setFont(Theme.FONT_SMALL);
        seasonLabel.setForeground(Theme.ACCENT_PRIMARY);
        leftPanel.add(logoLabel);
        leftPanel.add(titleLabel);
        leftPanel.add(versionLabel);
        leftPanel.add(Box.createHorizontalStrut(10));
        leftPanel.add(seasonLabel);
        header.add((Component)leftPanel, "West");
        JPanel controlPanel = new JPanel(new FlowLayout(2, 5, 0));
        controlPanel.setOpaque(false);
        JButton minimizeBtn = this.createWindowButton("min");
        minimizeBtn.addActionListener(e -> this.setState(1));
        JButton closeBtn = this.createWindowButton("close");
        closeBtn.addActionListener(e -> {
            MineZoneLauncher.getInstance().getConfig().save();
            System.exit(0);
        });
        controlPanel.add(minimizeBtn);
        controlPanel.add(closeBtn);
        header.add((Component)controlPanel, "East");
        return header;
    }

    private JButton createWindowButton(final String type) {
        final JButton button = new JButton(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setColor(this.getForeground());
                g2d.setStroke(new BasicStroke(2.0f, 1, 1));
                int cx = this.getWidth() / 2;
                int cy = this.getHeight() / 2;
                if (type.equals("min")) {
                    g2d.drawLine(cx - 6, cy, cx + 6, cy);
                } else if (type.equals("close")) {
                    g2d.drawLine(cx - 5, cy - 5, cx + 5, cy + 5);
                    g2d.drawLine(cx + 5, cy - 5, cx - 5, cy + 5);
                }
                g2d.dispose();
            }
        };
        button.setPreferredSize(new Dimension(35, 35));
        button.setForeground(Theme.TEXT_SECONDARY);
        button.setBorderPainted(false);
        button.setContentAreaFilled(false);
        button.setFocusPainted(false);
        button.setCursor(Cursor.getPredefinedCursor(12));
        button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                button.setForeground(Theme.TEXT_PRIMARY);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                button.setForeground(Theme.TEXT_SECONDARY);
            }
        });
        return button;
    }

    public void showPanel(String name) {
        CardLayout cl = (CardLayout)this.contentPanel.getLayout();
        cl.show(this.contentPanel, name);
    }

    public LoginPanel getLoginPanel() {
        return this.loginPanel;
    }

    public MainPanel getMainPanel() {
        return this.mainPanel;
    }

    public SettingsPanel getSettingsPanel() {
        return this.settingsPanel;
    }
}

