/*
 * Decompiled with CFR 0.152.
 */
package ru.minezone.launcher.gui;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.LinearGradientPaint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import ru.minezone.launcher.MineZoneLauncher;
import ru.minezone.launcher.auth.AuthManager;
import ru.minezone.launcher.auth.AuthResponse;
import ru.minezone.launcher.gui.MainFrame;
import ru.minezone.launcher.gui.Theme;
import ru.minezone.launcher.gui.components.ModernButton;
import ru.minezone.launcher.gui.components.ModernPasswordField;
import ru.minezone.launcher.gui.components.ModernTextField;
import ru.minezone.launcher.utils.Config;

public class LoginPanel
extends JPanel {
    private MainFrame mainFrame;
    private ModernTextField loginField;
    private ModernPasswordField passwordField;
    private ModernButton loginButton;
    private JCheckBox rememberCheckbox;
    private JLabel statusLabel;
    private JLabel serverStatusLabel;
    private boolean isLoading = false;
    private JDialog authDialog;
    private JLabel authStatusLabel;
    private JPanel authIconPanel;
    private Timer authAnimTimer;
    private int authAnimFrame = 0;
    private boolean authSuccess = false;
    private float authCheckProgress = 0.0f;
    private Timer masterAnimTimer;
    private double time = 0.0;
    private double glowPhase = 0.0;
    private double borderProgress = 0.0;
    private Point mousePos = new Point(400, 300);
    private Rectangle containerBounds = new Rectangle(0, 0, 1, 1);
    private List<Particle> particles = new ArrayList<Particle>();
    private List<FloatingShape> shapes = new ArrayList<FloatingShape>();
    private List<AuroraWave> auroraWaves = new ArrayList<AuroraWave>();
    private List<Point2D> cachedBorderPoints = null;
    private int cachedWidth = 0;
    private int cachedHeight = 0;
    private static final Color CYAN = new Color(56, 189, 248);
    private static final Color PURPLE = new Color(139, 92, 246);
    private static final Color PINK = new Color(236, 72, 153);
    private static final Color BLUE = new Color(59, 130, 246);

    public LoginPanel(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
        this.initParticles();
        this.init();
        this.startAnimations();
        this.loadSavedCredentials();
        this.checkServerStatus();
    }

    private void initParticles() {
        int i;
        Random rand = new Random();
        for (i = 0; i < 50; ++i) {
            this.particles.add(new Particle(rand));
        }
        for (i = 0; i < 5; ++i) {
            this.shapes.add(new FloatingShape(rand, i));
        }
        for (i = 0; i < 4; ++i) {
            this.auroraWaves.add(new AuroraWave(i));
        }
    }

    private void startAnimations() {
        this.masterAnimTimer = new Timer(16, e -> {
            this.time += 0.016;
            this.glowPhase += 0.02;
            this.borderProgress += 0.002;
            if (this.borderProgress >= 1.0) {
                this.borderProgress -= 1.0;
            }
            for (Particle p : this.particles) {
                p.update(this.mousePos, this.containerBounds);
            }
            for (FloatingShape s : this.shapes) {
                s.update(this.time);
            }
            this.repaint();
        });
        this.masterAnimTimer.start();
    }

    private void init() {
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        JPanel backgroundPanel = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                int w = this.getWidth();
                int h = this.getHeight();
                g2d.setPaint(new GradientPaint(0.0f, 0.0f, new Color(8, 12, 21), w, h, new Color(18, 24, 38)));
                g2d.fillRect(0, 0, w, h);
                g2d.setComposite(AlphaComposite.getInstance(3, 0.1f));
                for (AuroraWave wave : LoginPanel.this.auroraWaves) {
                    wave.draw(g2d, w, h, LoginPanel.this.time);
                }
                g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
                for (FloatingShape shape : LoginPanel.this.shapes) {
                    shape.draw(g2d);
                }
                for (Particle p : LoginPanel.this.particles) {
                    p.draw(g2d, w, h);
                }
                g2d.dispose();
            }
        };
        backgroundPanel.setLayout(new GridBagLayout());
        backgroundPanel.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                LoginPanel.this.mousePos = e.getPoint();
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                LoginPanel.this.mousePos = e.getPoint();
            }
        });
        final JPanel container = this.createLoginContainer();
        backgroundPanel.add(container);
        backgroundPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                SwingUtilities.invokeLater(() -> {
                    Point loc = container.getLocation();
                    Dimension size = container.getSize();
                    LoginPanel.this.containerBounds = new Rectangle(loc.x - 40, loc.y - 40, size.width + 80, size.height + 80);
                });
            }
        });
        this.add((Component)backgroundPanel, "Center");
    }

    private JPanel createLoginContainer() {
        JPanel container = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                int w = this.getWidth();
                int h = this.getHeight();
                Shape shape = this.createShape(w, h);
                if (LoginPanel.this.cachedBorderPoints == null || w != LoginPanel.this.cachedWidth || h != LoginPanel.this.cachedHeight) {
                    LoginPanel.this.cachedBorderPoints = this.calcBorderPoints(shape);
                    LoginPanel.this.cachedWidth = w;
                    LoginPanel.this.cachedHeight = h;
                }
                double intensity = 0.5 + Math.sin(LoginPanel.this.glowPhase) * 0.25;
                for (int i = 20; i > 0; --i) {
                    float alpha = (float)(0.004 * intensity * (double)(20 - i) / 20.0);
                    double cp = LoginPanel.this.glowPhase * 0.4 + (double)i * 0.04;
                    Color gc = LoginPanel.this.blend(CYAN, PURPLE, (float)(Math.sin(cp) * 0.5 + 0.5));
                    g2d.setColor(new Color(gc.getRed(), gc.getGreen(), gc.getBlue(), LoginPanel.this.clamp((int)(alpha * 255.0f))));
                    AffineTransform at = AffineTransform.getTranslateInstance(-i, -i);
                    at.scale(((double)w + (double)i * 2.0) / (double)w, ((double)h + (double)i * 2.0) / (double)h);
                    g2d.fill(at.createTransformedShape(shape));
                }
                g2d.setPaint(new GradientPaint(0.0f, 0.0f, new Color(18, 26, 42, 235), 0.0f, h, new Color(10, 16, 28, 250)));
                g2d.fill(shape);
                g2d.setClip(new Area(shape));
                g2d.setPaint(new GradientPaint(0.0f, 0.0f, new Color(255, 255, 255, 22), 0.0f, (float)h * 0.28f, new Color(255, 255, 255, 0)));
                g2d.fillRect(0, 0, w, (int)((float)h * 0.28f));
                g2d.setClip(null);
                g2d.setStroke(new BasicStroke(2.0f));
                double co = LoginPanel.this.glowPhase * 0.25;
                Color bc1 = LoginPanel.this.blend(CYAN, PURPLE, (float)(Math.sin(co) * 0.5 + 0.5));
                Color bc2 = LoginPanel.this.blend(PURPLE, PINK, (float)(Math.sin(co + 1.2) * 0.5 + 0.5));
                g2d.setPaint(new LinearGradientPaint(0.0f, 0.0f, w, h, new float[]{0.0f, 0.5f, 1.0f}, new Color[]{bc1, bc2, bc1}));
                g2d.draw(shape);
                if (LoginPanel.this.cachedBorderPoints != null && LoginPanel.this.cachedBorderPoints.size() > 5) {
                    double exactIdx = LoginPanel.this.borderProgress * (double)LoginPanel.this.cachedBorderPoints.size();
                    int i1 = (int)exactIdx % LoginPanel.this.cachedBorderPoints.size();
                    int i2 = (i1 + 1) % LoginPanel.this.cachedBorderPoints.size();
                    double frac = exactIdx - (double)((int)exactIdx);
                    Point2D p1 = (Point2D)LoginPanel.this.cachedBorderPoints.get(i1);
                    Point2D p2 = (Point2D)LoginPanel.this.cachedBorderPoints.get(i2);
                    double px = p1.getX() + (p2.getX() - p1.getX()) * frac;
                    double py = p1.getY() + (p2.getY() - p1.getY()) * frac;
                    for (int i = 10; i > 0; --i) {
                        g2d.setColor(new Color(255, 255, 255, LoginPanel.this.clamp((int)((double)(12 * (10 - i)) / 10.0))));
                        int sz = i * 3;
                        g2d.fillOval((int)(px - (double)(sz / 2)), (int)(py - (double)(sz / 2)), sz, sz);
                    }
                    g2d.setColor(new Color(255, 255, 255, 180));
                    g2d.fillOval((int)(px - 3.0), (int)(py - 3.0), 6, 6);
                }
                this.drawCorners(g2d, w, h, intensity);
                g2d.dispose();
            }

            private Shape createShape(int w, int h) {
                int cut = 22;
                Path2D.Double p = new Path2D.Double();
                ((Path2D)p).moveTo(cut, 0.0);
                ((Path2D)p).lineTo(w / 2 - 45, 0.0);
                ((Path2D)p).quadTo(w / 2 - 35, 0.0, w / 2 - 28, 10.0);
                ((Path2D)p).lineTo(w / 2 - 18, 14.0);
                ((Path2D)p).quadTo(w / 2, 18.0, w / 2 + 18, 14.0);
                ((Path2D)p).lineTo(w / 2 + 28, 10.0);
                ((Path2D)p).quadTo(w / 2 + 35, 0.0, w / 2 + 45, 0.0);
                ((Path2D)p).lineTo(w - cut, 0.0);
                ((Path2D)p).lineTo(w, cut);
                ((Path2D)p).lineTo(w, h - 28);
                ((Path2D)p).quadTo(w, h, w - 28, h);
                ((Path2D)p).lineTo(28.0, h);
                ((Path2D)p).quadTo(0.0, h, 0.0, h - 28);
                ((Path2D)p).lineTo(0.0, cut);
                p.closePath();
                return p;
            }

            private List<Point2D> calcBorderPoints(Shape shape) {
                ArrayList<Point2D> pts = new ArrayList<Point2D>();
                PathIterator pi = shape.getPathIterator(null, 0.5);
                double[] c = new double[6];
                while (!pi.isDone()) {
                    int t = pi.currentSegment(c);
                    if (t == 1 || t == 0) {
                        pts.add(new Point2D.Double(c[0], c[1]));
                    }
                    pi.next();
                }
                return pts;
            }

            private void drawCorners(Graphics2D g2d, int w, int h, double intensity) {
                g2d.setStroke(new BasicStroke(1.5f));
                int a = LoginPanel.this.clamp((int)((0.25 + intensity * 0.2) * 255.0));
                g2d.setColor(new Color(CYAN.getRed(), CYAN.getGreen(), CYAN.getBlue(), a));
                g2d.drawLine(8, 28, 8, 50);
                g2d.drawLine(8, 28, 30, 28);
                g2d.fillOval(5, 25, 6, 6);
                g2d.setColor(new Color(PURPLE.getRed(), PURPLE.getGreen(), PURPLE.getBlue(), a));
                g2d.drawLine(w - 8, 28, w - 8, 50);
                g2d.drawLine(w - 8, 28, w - 30, 28);
                g2d.fillOval(w - 11, 25, 6, 6);
                g2d.drawLine(8, h - 28, 8, h - 50);
                g2d.drawLine(8, h - 28, 30, h - 28);
                g2d.fillOval(5, h - 31, 6, 6);
                g2d.setColor(new Color(CYAN.getRed(), CYAN.getGreen(), CYAN.getBlue(), a));
                g2d.drawLine(w - 8, h - 28, w - 8, h - 50);
                g2d.drawLine(w - 8, h - 28, w - 30, h - 28);
                g2d.fillOval(w - 11, h - 31, 6, 6);
            }
        };
        container.setOpaque(false);
        container.setLayout(new BoxLayout(container, 1));
        container.setBorder(BorderFactory.createEmptyBorder(30, 50, 28, 50));
        container.setPreferredSize(new Dimension(440, 520));
        container.add(Box.createVerticalStrut(18));
        JPanel logoPanel = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                String text = "MINEZONE";
                Font font = new Font("Segoe UI", 1, 46);
                g2d.setFont(font);
                FontMetrics fm = g2d.getFontMetrics();
                int tw = fm.stringWidth(text);
                int x = (this.getWidth() - tw) / 2;
                int y = this.getHeight() / 2 + fm.getAscent() / 3;
                double gi = 0.35 + Math.sin(LoginPanel.this.glowPhase * 0.6) * 0.2;
                for (int i = 12; i > 0; --i) {
                    float a = (float)(gi * 0.018 * (double)(12 - i) / 12.0);
                    double cp = LoginPanel.this.glowPhase * 0.2;
                    Color gc = LoginPanel.this.blend(CYAN, PURPLE, (float)(Math.sin(cp) * 0.5 + 0.5));
                    g2d.setColor(new Color(gc.getRed(), gc.getGreen(), gc.getBlue(), LoginPanel.this.clamp((int)(a * 255.0f))));
                    g2d.drawString(text, x, y + i / 3);
                }
                double go = LoginPanel.this.time * 0.1;
                Color c1 = LoginPanel.this.blend(CYAN, PURPLE, (float)(Math.sin(go) * 0.5 + 0.5));
                Color c2 = LoginPanel.this.blend(PURPLE, PINK, (float)(Math.sin(go + 0.8) * 0.5 + 0.5));
                g2d.setPaint(new LinearGradientPaint(x, 0.0f, x + tw, 0.0f, new float[]{0.0f, 0.5f, 1.0f}, new Color[]{c1, c2, c1}));
                g2d.drawString(text, x, y);
                double hp = LoginPanel.this.time * 0.25 % 1.4 - 0.2;
                if (hp >= 0.0 && hp <= 1.0) {
                    int hx = x + (int)(hp * (double)tw) - 12;
                    g2d.setComposite(AlphaComposite.getInstance(3, 0.35f));
                    g2d.setClip(x - 3, y - fm.getAscent(), tw + 6, fm.getHeight());
                    g2d.setPaint(new GradientPaint(hx, 0.0f, new Color(255, 255, 255, 0), hx + 12, 0.0f, new Color(255, 255, 255, 255)));
                    g2d.fillRect(hx, y - fm.getAscent(), 24, fm.getHeight());
                    g2d.setClip(null);
                }
                g2d.dispose();
            }

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(380, 75);
            }

            @Override
            public Dimension getMaximumSize() {
                return new Dimension(480, 75);
            }
        };
        logoPanel.setOpaque(false);
        logoPanel.setAlignmentX(0.5f);
        container.add(logoPanel);
        container.add(Box.createVerticalStrut(12));
        this.serverStatusLabel = new JLabel("\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430...");
        this.serverStatusLabel.setForeground(Theme.WARNING);
        JPanel serverPanel = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                g2d.setFont(Theme.FONT_SMALL);
                FontMetrics fm = g2d.getFontMetrics();
                String txt = LoginPanel.this.serverStatusLabel.getText();
                Color sc = LoginPanel.this.serverStatusLabel.getForeground();
                int tw = 12 + fm.stringWidth(txt);
                int sx = (this.getWidth() - tw) / 2;
                int sy = this.getHeight() / 2;
                double pulse = Math.sin(LoginPanel.this.time * 2.5) * 0.5 + 0.5;
                int ps = (int)(5.0 + pulse * 5.0);
                g2d.setColor(new Color(sc.getRed(), sc.getGreen(), sc.getBlue(), (int)(18.0 * pulse)));
                g2d.fillOval(sx + 3 - ps / 2, sy - ps / 2, ps, ps);
                g2d.setColor(sc);
                g2d.fillOval(sx, sy - 3, 7, 7);
                g2d.setColor(new Color(255, 255, 255, 90));
                g2d.fillOval(sx + 1, sy - 2, 3, 3);
                g2d.setColor(sc);
                g2d.drawString(txt, sx + 14, sy + fm.getAscent() / 2 - 1);
                g2d.dispose();
            }

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(180, 26);
            }
        };
        serverPanel.setOpaque(false);
        serverPanel.setAlignmentX(0.5f);
        container.add(serverPanel);
        container.add(Box.createVerticalStrut(18));
        container.add(this.createSeparator());
        container.add(Box.createVerticalStrut(18));
        container.add(this.createLabel("\u041b\u041e\u0413\u0418\u041d"));
        container.add(Box.createVerticalStrut(6));
        this.loginField = new ModernTextField("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043b\u043e\u0433\u0438\u043d");
        this.loginField.setMaximumSize(new Dimension(310, 46));
        this.loginField.setAlignmentX(0.5f);
        container.add(this.loginField);
        container.add(Box.createVerticalStrut(14));
        container.add(this.createLabel("\u041f\u0410\u0420\u041e\u041b\u042c"));
        container.add(Box.createVerticalStrut(6));
        this.passwordField = new ModernPasswordField("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043f\u0430\u0440\u043e\u043b\u044c");
        this.passwordField.setMaximumSize(new Dimension(310, 46));
        this.passwordField.setAlignmentX(0.5f);
        container.add(this.passwordField);
        container.add(Box.createVerticalStrut(12));
        this.rememberCheckbox = new JCheckBox("\u0417\u0430\u043f\u043e\u043c\u043d\u0438\u0442\u044c \u043c\u0435\u043d\u044f");
        this.rememberCheckbox.setFont(Theme.FONT_SMALL);
        this.rememberCheckbox.setForeground(new Color(150, 160, 180));
        this.rememberCheckbox.setOpaque(false);
        this.rememberCheckbox.setFocusPainted(false);
        this.rememberCheckbox.setCursor(Cursor.getPredefinedCursor(12));
        this.rememberCheckbox.setAlignmentX(0.5f);
        container.add(this.rememberCheckbox);
        container.add(Box.createVerticalStrut(18));
        this.loginButton = new ModernButton("\u0412\u041e\u0419\u0422\u0418 \u0412 \u0418\u0413\u0420\u0423", ModernButton.ButtonType.PRIMARY);
        this.loginButton.setMaximumSize(new Dimension(310, 50));
        this.loginButton.setFont(new Font("Segoe UI", 1, 14));
        this.loginButton.setAlignmentX(0.5f);
        this.loginButton.addActionListener(e -> this.performLogin());
        container.add(this.loginButton);
        container.add(Box.createVerticalStrut(12));
        this.statusLabel = new JLabel(" ");
        this.statusLabel.setFont(Theme.FONT_SMALL);
        this.statusLabel.setForeground(Theme.ERROR);
        this.statusLabel.setAlignmentX(0.5f);
        container.add(this.statusLabel);
        container.add(Box.createVerticalStrut(14));
        container.add(this.createSeparator());
        container.add(Box.createVerticalStrut(12));
        JPanel linksPanel = new JPanel(new FlowLayout(1, 22, 0));
        linksPanel.setOpaque(false);
        linksPanel.add(this.createLink("\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f"));
        linksPanel.add(this.createLink("\u0417\u0430\u0431\u044b\u043b\u0438 \u043f\u0430\u0440\u043e\u043b\u044c?"));
        linksPanel.setAlignmentX(0.5f);
        container.add(linksPanel);
        KeyAdapter enterKey = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    LoginPanel.this.performLogin();
                }
            }
        };
        this.loginField.addKeyListener(enterKey);
        this.passwordField.addKeyListener(enterKey);
        return container;
    }

    private JLabel createLabel(String text) {
        JLabel l = new JLabel(text);
        l.setFont(new Font("Segoe UI", 1, 10));
        l.setForeground(new Color(110, 130, 170));
        l.setAlignmentX(0.5f);
        return l;
    }

    private JPanel createSeparator() {
        JPanel sep = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                int w = this.getWidth();
                int y = this.getHeight() / 2;
                int cx = w / 2;
                g2d.setPaint(new GradientPaint(25.0f, y, new Color(255, 255, 255, 0), cx - 35, y, new Color(CYAN.getRed(), CYAN.getGreen(), CYAN.getBlue(), 45)));
                g2d.drawLine(25, y, cx - 35, y);
                g2d.setPaint(new GradientPaint(cx + 35, y, new Color(PURPLE.getRed(), PURPLE.getGreen(), PURPLE.getBlue(), 45), w - 25, y, new Color(255, 255, 255, 0)));
                g2d.drawLine(cx + 35, y, w - 25, y);
                double glow = 0.4 + Math.sin(LoginPanel.this.time * 1.5) * 0.2;
                Color gc = LoginPanel.this.blend(CYAN, PURPLE, (float)(Math.sin(LoginPanel.this.time * 0.4) * 0.5 + 0.5));
                g2d.setColor(new Color(gc.getRed(), gc.getGreen(), gc.getBlue(), LoginPanel.this.clamp((int)(glow * 255.0))));
                int[] xp = new int[]{cx, cx + 9, cx, cx - 9};
                int[] yp = new int[]{y - 6, y, y + 6, y};
                g2d.fillPolygon(xp, yp, 4);
                g2d.setColor(new Color(255, 255, 255, LoginPanel.this.clamp((int)(glow * 140.0))));
                g2d.setStroke(new BasicStroke(1.0f));
                g2d.drawPolygon(xp, yp, 4);
                g2d.dispose();
            }
        };
        sep.setOpaque(false);
        sep.setPreferredSize(new Dimension(310, 16));
        sep.setMaximumSize(new Dimension(310, 16));
        sep.setAlignmentX(0.5f);
        return sep;
    }

    private JLabel createLink(String text) {
        final JLabel link = new JLabel(text);
        link.setFont(Theme.FONT_SMALL);
        link.setForeground(new Color(130, 145, 170));
        link.setCursor(Cursor.getPredefinedCursor(12));
        link.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                link.setForeground(CYAN);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                link.setForeground(new Color(130, 145, 170));
            }
        });
        return link;
    }

    private Color blend(Color c1, Color c2, float r) {
        r = Math.max(0.0f, Math.min(1.0f, r));
        float ir = 1.0f - r;
        return new Color((int)((float)c1.getRed() * ir + (float)c2.getRed() * r), (int)((float)c1.getGreen() * ir + (float)c2.getGreen() * r), (int)((float)c1.getBlue() * ir + (float)c2.getBlue() * r));
    }

    private int clamp(int v) {
        return Math.max(0, Math.min(255, v));
    }

    private void loadSavedCredentials() {
        Config cfg = MineZoneLauncher.getInstance().getConfig();
        String sl = cfg.get("saved.login", "");
        String sp = cfg.get("saved.password", "");
        if (!sl.isEmpty()) {
            this.loginField.setText(sl);
            this.rememberCheckbox.setSelected(true);
            if (!sp.isEmpty()) {
                try {
                    this.passwordField.setText(new String(Base64.getDecoder().decode(sp)));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void saveCredentials(String l, String p) {
        Config cfg = MineZoneLauncher.getInstance().getConfig();
        if (this.rememberCheckbox.isSelected()) {
            cfg.set("saved.login", l);
            cfg.set("saved.password", Base64.getEncoder().encodeToString(p.getBytes()));
        } else {
            cfg.set("saved.login", "");
            cfg.set("saved.password", "");
        }
        cfg.save();
    }

    private void checkServerStatus() {
        new SwingWorker<Boolean, Void>(){

            @Override
            protected Boolean doInBackground() {
                return AuthManager.checkServerStatus();
            }

            @Override
            protected void done() {
                try {
                    if (((Boolean)this.get()).booleanValue()) {
                        LoginPanel.this.serverStatusLabel.setText("\u0421\u0435\u0440\u0432\u0435\u0440 \u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d");
                        LoginPanel.this.serverStatusLabel.setForeground(Theme.ONLINE);
                    } else {
                        LoginPanel.this.serverStatusLabel.setText("\u0421\u0435\u0440\u0432\u0435\u0440 \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d");
                        LoginPanel.this.serverStatusLabel.setForeground(Theme.OFFLINE);
                    }
                }
                catch (Exception e) {
                    LoginPanel.this.serverStatusLabel.setText("\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f");
                    LoginPanel.this.serverStatusLabel.setForeground(Theme.ERROR);
                }
            }
        }.execute();
    }

    private void performLogin() {
        if (this.isLoading) {
            return;
        }
        final String login = this.loginField.getText().trim();
        final String password = new String(this.passwordField.getPassword());
        if (login.isEmpty()) {
            this.showError("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043b\u043e\u0433\u0438\u043d");
            return;
        }
        if (password.isEmpty()) {
            this.showError("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043f\u0430\u0440\u043e\u043b\u044c");
            return;
        }
        this.setLoading(true);
        this.statusLabel.setText(" ");
        this.showAuthDialog();
        new SwingWorker<AuthResponse, Void>(){

            @Override
            protected AuthResponse doInBackground() {
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return AuthManager.authenticate(login, password);
            }

            @Override
            protected void done() {
                try {
                    AuthResponse r = (AuthResponse)this.get();
                    if (r.isSuccess()) {
                        LoginPanel.this.showAuthSuccess(() -> {
                            LoginPanel.this.saveCredentials(login, password);
                            LoginPanel.this.mainFrame.getMainPanel().setPlayerData(r.getUsername(), r.getSessionId(), r.getAccessToken(), r.getUuid(), r.getSkinUrl());
                            LoginPanel.this.mainFrame.showPanel("main");
                        });
                    } else {
                        LoginPanel.this.showAuthError(r.getErrorMessage());
                    }
                }
                catch (Exception e) {
                    LoginPanel.this.showAuthError("\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f");
                }
            }
        }.execute();
    }

    private void showAuthDialog() {
        this.authDialog = new JDialog((Frame)this.mainFrame, true);
        this.authDialog.setUndecorated(true);
        this.authDialog.setSize(280, 155);
        this.authDialog.setLocationRelativeTo(this.mainFrame);
        this.authDialog.setBackground(new Color(0, 0, 0, 0));
        this.authSuccess = false;
        this.authCheckProgress = 0.0f;
        this.authAnimFrame = 0;
        JPanel panel = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                for (int i = 8; i > 0; --i) {
                    g2d.setColor(new Color(0, 0, 0, 12 - i));
                    g2d.fill(new RoundRectangle2D.Double(i, i, this.getWidth() - i * 2, this.getHeight() - i * 2, 20.0, 20.0));
                }
                g2d.setColor(new Color(18, 25, 38, 252));
                g2d.fill(new RoundRectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight(), 18.0, 18.0));
                g2d.setPaint(new GradientPaint(0.0f, 0.0f, CYAN, this.getWidth(), this.getHeight(), PURPLE));
                g2d.setStroke(new BasicStroke(2.0f));
                g2d.draw(new RoundRectangle2D.Double(1.0, 1.0, this.getWidth() - 2, this.getHeight() - 2, 18.0, 18.0));
                g2d.dispose();
            }
        };
        panel.setOpaque(false);
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createEmptyBorder(26, 26, 26, 26));
        this.authIconPanel = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                int cx = this.getWidth() / 2;
                int cy = this.getHeight() / 2;
                if (LoginPanel.this.authSuccess) {
                    g2d.setColor(Theme.ONLINE);
                    g2d.fillOval(cx - 20, cy - 20, 40, 40);
                    g2d.setColor(Color.WHITE);
                    g2d.setStroke(new BasicStroke(3.0f, 1, 1));
                    float p = Math.min(1.0f, LoginPanel.this.authCheckProgress);
                    int x1 = cx - 10;
                    int y1 = cy + 2;
                    int x2 = cx - 3;
                    int y2 = cy + 9;
                    int x3 = cx + 11;
                    int y3 = cy - 7;
                    if (p < 0.4f) {
                        float t = p / 0.4f;
                        g2d.drawLine(x1, y1, (int)((float)x1 + (float)(x2 - x1) * t), (int)((float)y1 + (float)(y2 - y1) * t));
                    } else {
                        g2d.drawLine(x1, y1, x2, y2);
                        float t = (p - 0.4f) / 0.6f;
                        g2d.drawLine(x2, y2, (int)((float)x2 + (float)(x3 - x2) * t), (int)((float)y2 + (float)(y3 - y2) * t));
                    }
                } else {
                    g2d.setStroke(new BasicStroke(2.5f, 1, 1));
                    for (int i = 0; i < 8; ++i) {
                        double a = 0.7853981633974483 * (double)i + Math.toRadians(LoginPanel.this.authAnimFrame * 8);
                        float al = (float)(8 - i) / 8.0f;
                        Color c = LoginPanel.this.blend(CYAN, PURPLE, (float)i / 8.0f);
                        g2d.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), (int)(al * 255.0f)));
                        g2d.drawLine(cx + (int)(Math.cos(a) * 8.0), cy + (int)(Math.sin(a) * 8.0), cx + (int)(Math.cos(a) * 16.0), cy + (int)(Math.sin(a) * 16.0));
                    }
                }
                g2d.dispose();
            }
        };
        this.authIconPanel.setOpaque(false);
        this.authIconPanel.setPreferredSize(new Dimension(50, 50));
        this.authIconPanel.setAlignmentX(0.5f);
        panel.add(this.authIconPanel);
        panel.add(Box.createVerticalStrut(12));
        this.authStatusLabel = new JLabel("\u0410\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u044f...");
        this.authStatusLabel.setFont(new Font("Segoe UI", 0, 14));
        this.authStatusLabel.setForeground(Color.WHITE);
        this.authStatusLabel.setAlignmentX(0.5f);
        panel.add(this.authStatusLabel);
        this.authDialog.setContentPane(panel);
        this.authAnimTimer = new Timer(25, e -> {
            ++this.authAnimFrame;
            if (this.authSuccess) {
                this.authCheckProgress += 0.1f;
            }
            this.authIconPanel.repaint();
        });
        this.authAnimTimer.start();
        SwingUtilities.invokeLater(() -> this.authDialog.setVisible(true));
    }

    private void showAuthSuccess(Runnable onComplete) {
        this.authSuccess = true;
        this.authCheckProgress = 0.0f;
        this.authStatusLabel.setText("\u0414\u043e\u0431\u0440\u043e \u043f\u043e\u0436\u0430\u043b\u043e\u0432\u0430\u0442\u044c!");
        this.authStatusLabel.setForeground(Theme.ONLINE);
        Timer t = new Timer(1100, e -> {
            this.authAnimTimer.stop();
            this.authDialog.dispose();
            this.setLoading(false);
            onComplete.run();
        });
        t.setRepeats(false);
        t.start();
    }

    private void showAuthError(String msg) {
        this.authAnimTimer.stop();
        this.authStatusLabel.setText(msg);
        this.authStatusLabel.setForeground(Theme.ERROR);
        Timer t = new Timer(1400, e -> {
            this.authDialog.dispose();
            this.setLoading(false);
            this.showError(msg);
        });
        t.setRepeats(false);
        t.start();
    }

    private void setLoading(boolean l) {
        this.isLoading = l;
        this.loginButton.setEnabled(!l);
        this.loginField.setEnabled(!l);
        this.passwordField.setEnabled(!l);
    }

    private void showError(String m) {
        this.statusLabel.setText(m);
        this.statusLabel.setForeground(Theme.ERROR);
    }

    class AuroraWave {
        double offset;
        Color color;

        AuroraWave(int i) {
            this.offset = (double)i * 1.4;
            Color[] c = new Color[]{CYAN, PURPLE, BLUE, PINK};
            this.color = c[i % c.length];
        }

        void draw(Graphics2D g, int w, int h, double t) {
            Path2D.Double p = new Path2D.Double();
            ((Path2D)p).moveTo(0.0, h);
            for (int x = 0; x <= w; x += 10) {
                double y = (double)h * 0.18 + Math.sin(t * 0.25 + (double)x * 0.004 + this.offset) * 110.0 + Math.sin(t * 0.15 + (double)x * 0.002 + this.offset * 2.0) * 70.0;
                ((Path2D)p).lineTo(x, y);
            }
            ((Path2D)p).lineTo(w, h);
            p.closePath();
            g.setPaint(new GradientPaint(0.0f, 0.0f, new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), 22), 0.0f, h, new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), 0)));
            g.fill(p);
        }
    }

    class FloatingShape {
        double x;
        double y;
        double baseY;
        double size;
        double rot;
        double rotSpd;
        double phase;
        int type;
        Color color;

        FloatingShape(Random r, int i) {
            this.x = 60.0 + r.nextDouble() * 680.0;
            this.y = this.baseY = 100.0 + r.nextDouble() * 500.0;
            this.size = 30.0 + r.nextDouble() * 50.0;
            this.rot = r.nextDouble() * 360.0;
            this.rotSpd = 0.08 + r.nextDouble() * 0.2;
            this.type = r.nextInt(3);
            this.phase = (double)i * 0.9;
            Color[] cols = new Color[]{CYAN, PURPLE, PINK, BLUE};
            this.color = cols[r.nextInt(cols.length)];
        }

        void update(double t) {
            this.y = this.baseY + Math.sin(t * 0.4 + this.phase) * 18.0;
            this.rot += this.rotSpd;
        }

        void draw(Graphics2D g) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setComposite(AlphaComposite.getInstance(3, 0.045f));
            g2.translate(this.x, this.y);
            g2.rotate(Math.toRadians(this.rot));
            g2.setColor(this.color);
            g2.setStroke(new BasicStroke(1.5f));
            int s = (int)this.size;
            if (this.type == 0) {
                int[] xp = new int[6];
                int[] yp = new int[6];
                for (int i = 0; i < 6; ++i) {
                    double a = 1.0471975511965976 * (double)i - 1.5707963267948966;
                    xp[i] = (int)(Math.cos(a) * (double)s / 2.0);
                    yp[i] = (int)(Math.sin(a) * (double)s / 2.0);
                }
                g2.drawPolygon(xp, yp, 6);
            } else if (this.type == 1) {
                g2.drawPolygon(new int[]{0, -s / 2, s / 2}, new int[]{-s / 2, s / 2, s / 2}, 3);
            } else {
                g2.drawPolygon(new int[]{0, s / 2, 0, -s / 2}, new int[]{-s / 2, 0, s / 2, 0}, 4);
            }
            g2.dispose();
        }
    }

    class Particle {
        double x;
        double y;
        double baseX;
        double baseY;
        double vx;
        double vy;
        double size;
        double alpha;
        double phase;
        Color color;

        Particle(Random r) {
            this.baseX = r.nextDouble() * 900.0;
            this.baseY = r.nextDouble() * 700.0;
            this.x = this.baseX;
            this.y = this.baseY;
            this.vx = 0.0;
            this.vy = 0.0;
            this.size = 2.0 + r.nextDouble() * 4.0;
            this.alpha = 0.2 + r.nextDouble() * 0.4;
            this.phase = r.nextDouble() * Math.PI * 2.0;
            this.color = r.nextBoolean() ? CYAN : PURPLE;
        }

        void update(Point mouse, Rectangle forbidden) {
            double pushRadius;
            double targetX = this.baseX + Math.sin(LoginPanel.this.time * 0.3 + this.phase) * 15.0;
            double targetY = this.baseY + Math.cos(LoginPanel.this.time * 0.25 + this.phase) * 12.0;
            double dx = this.x - (double)mouse.x;
            double dy = this.y - (double)mouse.y;
            double dist = Math.sqrt(dx * dx + dy * dy);
            if (dist < (pushRadius = 80.0) && dist > 0.0) {
                double force = (pushRadius - dist) / pushRadius * 3.0;
                this.vx += dx / dist * force;
                this.vy += dy / dist * force;
            }
            this.vx += (targetX - this.x) * 0.02;
            this.vy += (targetY - this.y) * 0.02;
            this.vx *= 0.92;
            this.vy *= 0.92;
            this.x += this.vx;
            this.y += this.vy;
        }

        void draw(Graphics2D g, int w, int h) {
            if (this.x < -20.0 || this.x > (double)(w + 20) || this.y < -20.0 || this.y > (double)(h + 20)) {
                return;
            }
            int glowSize = (int)(this.size * 2.5);
            g.setColor(new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), LoginPanel.this.clamp((int)(this.alpha * 40.0))));
            g.fillOval((int)(this.x - (double)(glowSize / 2)), (int)(this.y - (double)(glowSize / 2)), glowSize, glowSize);
            g.setColor(new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), LoginPanel.this.clamp((int)(this.alpha * 255.0))));
            g.fillOval((int)(this.x - this.size / 2.0), (int)(this.y - this.size / 2.0), (int)this.size, (int)this.size);
        }
    }
}

