/*
 * Decompiled with CFR 0.152.
 */
package ru.minezone.launcher.client;

import java.io.File;
import ru.minezone.launcher.MineZoneLauncher;
import ru.minezone.launcher.client.ClientLauncher;

public class ClientProfile {
    private String title;
    private String version;
    private String description;
    private int modsCount;
    private String clientDirName;
    private String serverIp;
    private int serverPort;
    private int online;
    private String mainClass;
    private String assetIndex;
    private String[] jvmArgs;
    private String[] gameArgs;
    private String sortIndex;
    private String[] updateExclusions;
    private String[] updateVerify;
    private boolean updateFastCheck;
    private File javaPath;

    public ClientProfile(String title, String version, String description, int modsCount, String clientDirName, String serverIp, int serverPort) {
        this.title = title;
        this.version = version;
        this.description = description;
        this.modsCount = modsCount;
        this.clientDirName = clientDirName;
        this.serverIp = serverIp;
        this.serverPort = serverPort;
        this.online = 0;
        if (version.startsWith("1.7")) {
            this.mainClass = "net.minecraft.launchwrapper.Launch";
            this.assetIndex = "1.7.10";
            this.jvmArgs = new String[]{"-XX:+UseConcMarkSweepGC", "-XX:+CMSIncrementalMode", "-XX:-UseAdaptiveSizePolicy", "-Dfml.ignorePatchDiscrepancies=true", "-Dfml.ignoreInvalidMinecraftCertificates=true"};
            this.gameArgs = new String[]{"--tweakClass", "cpw.mods.fml.common.launcher.FMLTweaker"};
        } else if (version.startsWith("1.12")) {
            this.mainClass = "net.minecraft.launchwrapper.Launch";
            this.assetIndex = "1.12";
            this.jvmArgs = new String[]{"-XX:+UseG1GC", "-XX:+UnlockExperimentalVMOptions", "-XX:G1NewSizePercent=20", "-XX:G1ReservePercent=20", "-XX:MaxGCPauseMillis=50", "-XX:G1HeapRegionSize=32M", "-Dfml.ignorePatchDiscrepancies=true", "-Dfml.ignoreInvalidMinecraftCertificates=true"};
            this.gameArgs = new String[]{"--tweakClass", "net.minecraftforge.fml.common.launcher.FMLTweaker"};
        } else if (version.startsWith("1.16") || version.startsWith("1.17") || version.startsWith("1.18") || version.startsWith("1.19") || version.startsWith("1.20")) {
            this.mainClass = "cpw.mods.modlauncher.Launcher";
            this.assetIndex = version.substring(0, 4);
            this.jvmArgs = new String[]{"-XX:+UseG1GC", "-XX:+UnlockExperimentalVMOptions", "-XX:G1NewSizePercent=20", "-XX:G1ReservePercent=20", "-XX:MaxGCPauseMillis=50", "-XX:G1HeapRegionSize=32M", "--add-exports=java.base/sun.security.util=ALL-UNNAMED", "--add-opens=java.base/java.util.jar=ALL-UNNAMED"};
            this.gameArgs = new String[]{"--launchTarget", "forgeclient"};
        } else {
            this.mainClass = "net.minecraft.launchwrapper.Launch";
            this.assetIndex = version;
            this.jvmArgs = new String[]{"-XX:+UseG1GC"};
            this.gameArgs = new String[0];
        }
        this.updateExclusions = new String[]{"mods", "resourcepacks"};
        this.updateVerify = new String[]{"libraries", "natives", "minecraft.jar"};
        this.updateFastCheck = true;
    }

    public ClientProfile(String title, String version, String description, int modsCount, String clientDirName) {
        this(title, version, description, modsCount, clientDirName, "", 25565);
    }

    public File getClientDir() {
        File workDir = MineZoneLauncher.getInstance().getWorkDir();
        return new File(workDir, "clients/" + this.clientDirName);
    }

    public ClientLauncher createLauncher(String username, String accessToken, String uuid) {
        return new ClientLauncher(this, username, accessToken, uuid);
    }

    public String getTitle() {
        return this.title;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public int getModsCount() {
        return this.modsCount;
    }

    public String getClientDirName() {
        return this.clientDirName;
    }

    public String getServerIp() {
        return this.serverIp;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public int getOnline() {
        return this.online;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public String getAssetIndex() {
        return this.assetIndex;
    }

    public String[] getJvmArgs() {
        return this.jvmArgs;
    }

    public String[] getGameArgs() {
        return this.gameArgs;
    }

    public String[] getUpdateExclusions() {
        return this.updateExclusions;
    }

    public String[] getUpdateVerify() {
        return this.updateVerify;
    }

    public boolean isUpdateFastCheck() {
        return this.updateFastCheck;
    }

    public File getJavaPath() {
        return this.javaPath;
    }

    public void setOnline(int online) {
        this.online = online;
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public void setAssetIndex(String assetIndex) {
        this.assetIndex = assetIndex;
    }

    public void setJvmArgs(String[] jvmArgs) {
        this.jvmArgs = jvmArgs;
    }

    public void setGameArgs(String[] gameArgs) {
        this.gameArgs = gameArgs;
    }

    public void setUpdateExclusions(String[] updateExclusions) {
        this.updateExclusions = updateExclusions;
    }

    public void setUpdateVerify(String[] updateVerify) {
        this.updateVerify = updateVerify;
    }

    public void setUpdateFastCheck(boolean updateFastCheck) {
        this.updateFastCheck = updateFastCheck;
    }

    public void setServerIp(String serverIp) {
        this.serverIp = serverIp;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public void setJavaPath(File javaPath) {
        this.javaPath = javaPath;
    }

    public String toString() {
        return this.title + " [" + this.version + "]";
    }
}

