/*
 * Decompiled with CFR 0.152.
 */
package ru.minezone.launcher.client;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import ru.minezone.launcher.MineZoneLauncher;
import ru.minezone.launcher.client.ClientProfile;
import ru.minezone.launcher.utils.Config;
import ru.minezone.launcher.utils.LogHelper;
import ru.minezone.launcher.utils.OSHelper;

public class ClientLauncher {
    private Process gameProcess;
    private ClientProfile profile;
    private String username;
    private String accessToken;
    private String uuid;
    private static final String AUTH_SERVER = "https://minezone.su/launcher/sessionserver.php";

    public ClientLauncher(ClientProfile profile, String username, String accessToken, String uuid) {
        this.profile = profile;
        this.username = username;
        this.accessToken = accessToken;
        this.uuid = uuid;
    }

    public boolean launch() {
        try {
            LogHelper.info("Launching client: " + this.profile.getTitle());
            File clientDir = this.profile.getClientDir();
            File javaPath = this.findJava();
            if (javaPath == null) {
                LogHelper.error("Java not found!");
                return false;
            }
            LogHelper.info("Using Java: " + javaPath.getAbsolutePath());
            List<String> classpath = this.buildClasspath(clientDir);
            if (classpath.isEmpty()) {
                LogHelper.error("Classpath is empty!");
                return false;
            }
            List<String> command = this.buildCommand(javaPath, clientDir, classpath);
            LogHelper.info("Launch command: " + String.join((CharSequence)" ", command));
            ProcessBuilder pb = new ProcessBuilder(command);
            pb.directory(clientDir);
            pb.redirectErrorStream(true);
            Map<String, String> env = pb.environment();
            env.put("APPDATA", clientDir.getAbsolutePath());
            File nativesDir = new File(clientDir, "natives");
            if (!nativesDir.exists()) {
                nativesDir = new File(clientDir, "versions/" + this.profile.getVersion() + "/natives");
            }
            if (nativesDir.exists()) {
                String nativesPath = nativesDir.getAbsolutePath();
                env.put("java.library.path", nativesPath);
            }
            this.gameProcess = pb.start();
            new Thread(() -> {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.gameProcess.getInputStream()));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        LogHelper.info("[MC] " + line);
                    }
                }
                catch (Exception e) {
                    LogHelper.error("Error reading game output", e);
                }
            }).start();
            LogHelper.info("Game process started");
            return true;
        }
        catch (Exception e) {
            LogHelper.error("Failed to launch client", e);
            return false;
        }
    }

    private String prefetchAuthlibMetadata(String authServer) {
        try {
            LogHelper.info("Prefetching authlib-injector metadata from: " + authServer);
            URL url = new URL(authServer);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(10000);
            conn.setReadTimeout(10000);
            conn.setRequestProperty("User-Agent", "MineZone-Launcher/1.0");
            int responseCode = conn.getResponseCode();
            if (responseCode != 200) {
                LogHelper.warning("Failed to fetch metadata, response code: " + responseCode);
                return null;
            }
            StringBuilder response = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
            }
            String metadata = response.toString();
            LogHelper.info("Fetched metadata: " + metadata.substring(0, Math.min(200, metadata.length())) + "...");
            String encodedMetadata = Base64.getEncoder().encodeToString(metadata.getBytes(StandardCharsets.UTF_8));
            LogHelper.info("Encoded metadata length: " + encodedMetadata.length());
            return encodedMetadata;
        }
        catch (Exception e) {
            LogHelper.warning("Failed to prefetch metadata: " + e.getMessage());
            return null;
        }
    }

    private File findJava() {
        File javaFromHome;
        File custom;
        if (this.profile.getJavaPath() != null && this.profile.getJavaPath().exists()) {
            LogHelper.info("Using downloaded Java: " + this.profile.getJavaPath());
            return this.profile.getJavaPath();
        }
        Config config = MineZoneLauncher.getInstance().getConfig();
        String customJava = config.get("java.path", "");
        if (!customJava.isEmpty() && (custom = new File(customJava)).exists()) {
            return custom;
        }
        File workDir = MineZoneLauncher.getInstance().getWorkDir();
        String requiredVersion = this.getRequiredJavaVersion();
        File bundledJava = new File(workDir, "clients/jre" + requiredVersion + "/bin/java" + (OSHelper.isWindows() ? ".exe" : ""));
        if (bundledJava.exists()) {
            LogHelper.info("Using bundled Java " + requiredVersion);
            return bundledJava;
        }
        File clientJava = new File(this.profile.getClientDir(), "jre/bin/java" + (OSHelper.isWindows() ? ".exe" : ""));
        if (clientJava.exists()) {
            return clientJava;
        }
        String javaHome = System.getenv("JAVA_HOME");
        if (javaHome != null && (javaFromHome = new File(javaHome, "bin/java" + (OSHelper.isWindows() ? ".exe" : ""))).exists()) {
            return javaFromHome;
        }
        if (OSHelper.isWindows()) {
            String[] paths = new String[]{"C:/Program Files/Java", "C:/Program Files (x86)/Java", System.getenv("LOCALAPPDATA") + "/Programs/Java"};
            String targetVersion = "jre" + requiredVersion;
            String targetJdk = "jdk" + (requiredVersion.equals("8") ? "1.8" : requiredVersion);
            for (String path : paths) {
                File java;
                File[] javaDirs;
                File dir = new File(path);
                if (!dir.exists() || (javaDirs = dir.listFiles(f -> f.isDirectory() && (f.getName().contains(targetVersion) || f.getName().contains(targetJdk)))) == null || javaDirs.length <= 0 || !(java = new File(javaDirs[0], "bin/java.exe")).exists()) continue;
                return java;
            }
        }
        LogHelper.warning("Using system Java from PATH");
        return new File("java");
    }

    private String getRequiredJavaVersion() {
        String mcVersion = this.profile.getVersion();
        if (mcVersion.startsWith("1.7") || mcVersion.startsWith("1.8") || mcVersion.startsWith("1.9") || mcVersion.startsWith("1.10") || mcVersion.startsWith("1.11") || mcVersion.startsWith("1.12") || mcVersion.startsWith("1.13") || mcVersion.startsWith("1.14") || mcVersion.startsWith("1.15") || mcVersion.startsWith("1.16")) {
            return "8";
        }
        if (mcVersion.startsWith("1.17")) {
            return "16";
        }
        return "17";
    }

    private List<String> buildClasspath(File clientDir) {
        File versionJar;
        File versionsDir;
        String[] libPaths;
        File[] clientJars;
        ArrayList<String> classpath = new ArrayList<String>();
        LogHelper.info("Building classpath from: " + clientDir.getAbsolutePath());
        for (File jar : clientJars = new File[]{new File(clientDir, "minecraft.jar"), new File(clientDir, "client.jar"), new File(clientDir, this.profile.getVersion() + ".jar")}) {
            if (!jar.exists()) continue;
            classpath.add(jar.getAbsolutePath());
            LogHelper.info("Added client jar: " + jar.getName());
            break;
        }
        for (String libPath : libPaths = new String[]{"libraries", "lib", "libs"}) {
            File librariesDir = new File(clientDir, libPath);
            if (!librariesDir.exists()) continue;
            this.collectJars(librariesDir, classpath);
            LogHelper.info("Collected jars from: " + librariesDir.getAbsolutePath());
        }
        File[] forgeJars = clientDir.listFiles((dir, name) -> name.toLowerCase().contains("forge") && name.endsWith(".jar"));
        if (forgeJars != null) {
            for (File jar : forgeJars) {
                if (classpath.contains(jar.getAbsolutePath())) continue;
                classpath.add(jar.getAbsolutePath());
                LogHelper.info("Added Forge jar: " + jar.getName());
            }
        }
        if ((versionsDir = new File(clientDir, "versions/" + this.profile.getVersion())).exists() && (versionJar = new File(versionsDir, this.profile.getVersion() + ".jar")).exists() && !classpath.contains(versionJar.getAbsolutePath())) {
            classpath.add(versionJar.getAbsolutePath());
            LogHelper.info("Added version jar: " + versionJar.getName());
        }
        LogHelper.info("Total classpath entries: " + classpath.size());
        return classpath;
    }

    private void collectJars(File dir, List<String> classpath) {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            String path;
            if (file.isDirectory()) {
                this.collectJars(file, classpath);
                continue;
            }
            if (!file.getName().endsWith(".jar") || classpath.contains(path = file.getAbsolutePath())) continue;
            classpath.add(path);
        }
    }

    private List<String> buildCommand(File javaPath, File clientDir, List<String> classpath) {
        File[] found;
        File libDir;
        ArrayList<String> command = new ArrayList<String>();
        Config config = MineZoneLauncher.getInstance().getConfig();
        command.add(javaPath.getAbsolutePath());
        int minRam = config.getInt("ram.min", 1024);
        int maxRam = config.getInt("ram.max", 4096);
        command.add("-Xms" + minRam + "M");
        command.add("-Xmx" + maxRam + "M");
        File nativesDir = this.findNativesDir(clientDir);
        if (nativesDir != null) {
            command.add("-Djava.library.path=" + nativesDir.getAbsolutePath());
        }
        if (this.profile.getJvmArgs() != null) {
            command.addAll(Arrays.asList(this.profile.getJvmArgs()));
        }
        command.add("-Dminecraft.applet.TargetDirectory=" + clientDir.getAbsolutePath());
        command.add("-Duser.home=" + clientDir.getAbsolutePath());
        File authlibInjector = new File(clientDir, "authlib-injector.jar");
        if (!authlibInjector.exists()) {
            authlibInjector = new File(clientDir, "libraries/authlib-injector.jar");
        }
        if (!authlibInjector.exists() && (libDir = new File(clientDir, "libraries")).exists() && (found = libDir.listFiles((d, n) -> n.toLowerCase().contains("authlib-injector") && n.endsWith(".jar"))) != null && found.length > 0) {
            authlibInjector = found[0];
        }
        if (authlibInjector.exists()) {
            String authServer = config.get("auth.server", AUTH_SERVER);
            String prefetchedMetadata = this.prefetchAuthlibMetadata(authServer);
            if (prefetchedMetadata != null && !prefetchedMetadata.isEmpty()) {
                command.add("-Dauthlibinjector.yggdrasil.prefetched=" + prefetchedMetadata);
                LogHelper.info("Using prefetched metadata (Base64 length: " + prefetchedMetadata.length() + ")");
            }
            command.add("-javaagent:" + authlibInjector.getAbsolutePath() + "=" + authServer);
            command.add("-Dauthlibinjector.debug");
            command.add("-Dauthlibinjector.noShowServerName");
            LogHelper.info("Authlib-injector enabled: " + authlibInjector.getAbsolutePath());
            LogHelper.info("Auth server: " + authServer);
        } else {
            LogHelper.warning("authlib-injector.jar NOT FOUND! Skins will NOT work!");
            LogHelper.warning("Expected locations:");
            LogHelper.warning("  - " + new File(clientDir, "authlib-injector.jar").getAbsolutePath());
            LogHelper.warning("  - " + new File(clientDir, "libraries/authlib-injector.jar").getAbsolutePath());
        }
        command.add("-cp");
        String separator = OSHelper.isWindows() ? ";" : ":";
        command.add(String.join((CharSequence)separator, classpath));
        command.add(this.profile.getMainClass());
        command.add("--username");
        command.add(this.username);
        command.add("--version");
        command.add(this.profile.getVersion());
        command.add("--gameDir");
        command.add(clientDir.getAbsolutePath());
        command.add("--assetsDir");
        File assetsDir = this.findAssetsDir(clientDir);
        LogHelper.info("Using assetsDir: " + assetsDir.getAbsolutePath());
        command.add(assetsDir.getAbsolutePath());
        command.add("--assetIndex");
        command.add(this.profile.getAssetIndex());
        command.add("--uuid");
        command.add(this.uuid != null ? this.uuid.replace("-", "") : UUID.randomUUID().toString().replace("-", ""));
        command.add("--accessToken");
        command.add(this.accessToken != null ? this.accessToken : "0");
        command.add("--userType");
        command.add("mojang");
        command.add("--userProperties");
        command.add("{}");
        if (config.getBoolean("fullscreen", false)) {
            command.add("--fullscreen");
        }
        if (this.profile.getGameArgs() != null) {
            command.addAll(Arrays.asList(this.profile.getGameArgs()));
        }
        return command;
    }

    private File findAssetsDir(File clientDir) {
        File minecraftAssets;
        String appData;
        File clientsDir;
        File assetsDir = new File(clientDir, "assets");
        if (!(assetsDir.exists() && new File(assetsDir, "indexes").exists() || (clientsDir = clientDir.getParentFile()) == null)) {
            File versionAssets = new File(clientsDir, "assets" + this.profile.getVersion());
            if (versionAssets.exists() && new File(versionAssets, "indexes").exists()) {
                return versionAssets;
            }
            File commonAssets = new File(clientsDir, "assets");
            if (commonAssets.exists() && new File(commonAssets, "indexes").exists()) {
                return commonAssets;
            }
        }
        if ((!assetsDir.exists() || !new File(assetsDir, "indexes").exists()) && (appData = System.getenv("APPDATA")) != null && (minecraftAssets = new File(appData, ".minecraft/assets")).exists() && new File(minecraftAssets, "indexes").exists()) {
            return minecraftAssets;
        }
        return assetsDir;
    }

    private File findNativesDir(File clientDir) {
        File[] possibilities;
        for (File dir : possibilities = new File[]{new File(clientDir, "natives"), new File(clientDir, "natives/" + this.getOSName()), new File(clientDir, "versions/" + this.profile.getVersion() + "/natives"), new File(clientDir, "libraries/natives")}) {
            if (!dir.exists() || !dir.isDirectory()) continue;
            return dir;
        }
        return null;
    }

    private String getOSName() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("win")) {
            return "windows";
        }
        if (os.contains("mac")) {
            return "osx";
        }
        return "linux";
    }

    public boolean isRunning() {
        return this.gameProcess != null && this.gameProcess.isAlive();
    }

    public void stop() {
        if (this.gameProcess != null) {
            this.gameProcess.destroy();
        }
    }

    public int waitFor() throws InterruptedException {
        if (this.gameProcess != null) {
            return this.gameProcess.waitFor();
        }
        return -1;
    }

    public Process getProcess() {
        return this.gameProcess;
    }

    public Process getGameProcess() {
        return this.gameProcess;
    }
}

