/*
 * Decompiled with CFR 0.152.
 */
package ru.minezone.launcher.auth;

import java.security.MessageDigest;
import java.util.HashMap;
import ru.minezone.launcher.auth.AuthResponse;
import ru.minezone.launcher.request.RequestManager;
import ru.minezone.launcher.request.Response;
import ru.minezone.launcher.security.LauncherGuard;
import ru.minezone.launcher.utils.LogHelper;

public class AuthManager {
    private static String currentSessionId;
    private static String currentUsername;

    public static AuthResponse authenticate(String login, String password) {
        LogHelper.info("Attempting to authenticate user: " + login);
        try {
            String hashedPassword = AuthManager.hashSHA256(password);
            String hwid = LauncherGuard.getHWID();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("action", "auth");
            params.put("login", login);
            params.put("password", hashedPassword);
            params.put("hwid", hwid);
            Response response = RequestManager.sendRequest("https://minezone.su/launcher/launcher.php", params);
            if (response.isSuccess()) {
                currentSessionId = response.getString("session");
                currentUsername = response.getString("username");
                LogHelper.info("Authentication successful for: " + currentUsername);
                return new AuthResponse(true, currentUsername, currentSessionId, response.getString("accessToken"), response.getString("uuid"), response.getString("skinUrl"), response.getString("capeUrl"), null);
            }
            String error = response.getString("error");
            LogHelper.warning("Authentication failed: " + error);
            return new AuthResponse(false, null, null, null, null, null, null, error);
        }
        catch (Exception e) {
            LogHelper.error("Authentication error", e);
            return new AuthResponse(false, null, null, null, null, null, null, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c");
        }
    }

    public static boolean checkServerStatus() {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("action", "ping");
            Response response = RequestManager.sendRequest("https://minezone.su/launcher/launcher.php", params);
            return response.isSuccess();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String hashSHA256(String input) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(input.getBytes());
            StringBuilder hexString = new StringBuilder();
            for (byte b : hash) {
                String hex = Integer.toHexString(0xFF & b);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        }
        catch (Exception e) {
            return input;
        }
    }

    public static String getCurrentSessionId() {
        return currentSessionId;
    }

    public static String getCurrentUsername() {
        return currentUsername;
    }
}

