/*
 * Decompiled with CFR 0.152.
 */
package ru.minezone.launcher;

import java.io.File;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import ru.minezone.launcher.gui.MainFrame;
import ru.minezone.launcher.security.AntiDump;
import ru.minezone.launcher.security.LauncherGuard;
import ru.minezone.launcher.security.SingleInstanceLock;
import ru.minezone.launcher.utils.Config;
import ru.minezone.launcher.utils.LogHelper;
import ru.minezone.launcher.utils.OSHelper;

public class MineZoneLauncher {
    public static final String LAUNCHER_VERSION = "1.0.0";
    public static final String PROJECT_NAME = "MineZone";
    public static final String API_URL = "https://minezone.su/launcher/launcher.php";
    private static MineZoneLauncher instance;
    private Config config;
    private File workDir;
    private MainFrame mainFrame;

    public static void main(String[] args) {
        if (!SingleInstanceLock.tryLock()) {
            JOptionPane.showMessageDialog(null, "\u041b\u0430\u0443\u043d\u0447\u0435\u0440 \u0443\u0436\u0435 \u0437\u0430\u043f\u0443\u0449\u0435\u043d!", "MineZone Launcher", 2);
            System.exit(0);
            return;
        }
        if (!LauncherGuard.initialize()) {
            System.exit(1);
            return;
        }
        AntiDump.enable();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            LogHelper.error("Failed to set look and feel", e);
        }
        SwingUtilities.invokeLater(() -> {
            instance = new MineZoneLauncher();
            instance.start();
        });
    }

    public void start() {
        LogHelper.info("Starting MineZone Launcher v1.0.0");
        LogHelper.info("HWID: " + LauncherGuard.getHWID());
        this.workDir = OSHelper.getWorkDir();
        if (!this.workDir.exists()) {
            this.workDir.mkdirs();
        }
        this.config = new Config(new File(this.workDir, "config.properties"));
        this.config.load();
        this.mainFrame = new MainFrame();
        this.mainFrame.setVisible(true);
        SingleInstanceLock.startCommandListener(() -> {
            this.mainFrame.setVisible(true);
            this.mainFrame.toFront();
            this.mainFrame.requestFocus();
        });
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            AntiDump.clearSensitiveData();
            SingleInstanceLock.release();
        }));
        LogHelper.info("Launcher started successfully");
    }

    public static MineZoneLauncher getInstance() {
        return instance;
    }

    public Config getConfig() {
        return this.config;
    }

    public File getWorkDir() {
        return this.workDir;
    }

    public MainFrame getMainFrame() {
        return this.mainFrame;
    }
}

